<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('listings', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->uuid('uuid');
            $table->string('title');
            $table->text('description')->nullable();
            $table->decimal('price', 15, 2);
            $table->json('financing_options')->nullable();
            $table->string('location');
            $table->json('image_url')->nullable();
            $table->string('owner_id');
            $table->tinyInteger('status')->default(0);
            $table->foreignId('condition_id')->nullable()->constrained('conditions')->nullOnDelete();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('listings');
    }
};
