<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicle_specifications', function (Blueprint $table) {
            $table->id();
            $table->string('listing_id')->unique();

            // Basic Information
            $table->string('make'); // Honda, Toyota, etc.
            $table->string('model');
            $table->integer('year');
            $table->string('trim')->nullable(); // Edition/variant
            $table->string('vin')->unique(); // Vehicle Identification Number

            // Technical Specifications
            $table->integer('engine_capacity'); // in cc
            $table->enum('fuel_type', ['gasoline', 'diesel', 'hybrid', 'electric']);
            $table->enum('transmission', ['automatic', 'manual']);
            $table->enum('drive_type', ['AWD', 'FWD', 'RWD', '4WD']);
            $table->integer('mileage');

            // Body & Exterior
            $table->enum('body_type', ['SUV', 'sedan', 'pickup', 'coupe', 'hatchback', 'van', 'convertible']);
            $table->string('exterior_color');
            $table->string('interior_color');
            $table->integer('seats');
            $table->integer('doors');

            $table->foreign('listing_id')->references('id')->on('listings')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicle_specifications');
    }
};
