<?php

namespace Database\Seeders;

use App\Models\Buyer\Buyer;
use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BuyerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Buyer::factory()
            ->count(5)
            ->has(User::factory()->count(1))
            ->create()
            ->each(function ($buyer) {
                $user = $buyer->user;
                $user->settings()->createMany([
                    ['key' => 'is_dark_mode', 'value' => false],
                    ['key' => 'is_compact_sidebar', 'value' => false],
                ]);

                $user->assignRole(Role::BUYER);
            });
    }
}
