<?php

namespace Database\Seeders;


use App\Models\City;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class CitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        City::truncate();
        Schema::enableForeignKeyConstraints();

        $statusInactive = City::STATUS_INACTIVE;
        $statusActive = City::STATUS_ACTIVE;
        $now = now();

        $cities = [

            // india states against cities

            // Andhra Pradesh
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Visakhapatnam', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Vijayawada', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Guntur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Nellore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Kurnool', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Rajahmundry', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Tirupati', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Kadapa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1095, 'name' => 'Anantapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Arunachal Pradesh
            array('uuid' => getUuid(), 'state_id' => 1096, 'name' => 'Jairampur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1096, 'name' => 'Deomali', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1096, 'name' => 'Khonsa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1096, 'name' => 'Itanagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1096, 'name' => 'Naharlagun', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Assam
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Guwahati', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Silchar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Dibrugarh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Jorhat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Nagaon', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Tinsukia', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Tezpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Karimganj', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1097, 'name' => 'Sivasagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Bihar
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Patna', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Gaya', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Bhagalpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Muzaffarpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Darbhanga', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Purnia', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Bihar Sharif', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Arrah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1098, 'name' => 'Begusarai', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Chhattisgarh
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Raipur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Bhilai', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Korba', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Bilaspur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Durg', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Raigarh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Rajnandgaon', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Jagdalpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1099, 'name' => 'Ambikapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),


            // Goa
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Panaji', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Margao', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Vasco da Gama', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Mapusa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Ponda', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Bicholim', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Curchorem', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Sanquelim', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1100, 'name' => 'Valpoi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Gujarat
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Ahmedabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Surat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Vadodara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Rajkot', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Bhavnagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Jamnagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Junagadh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Gandhinagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Gandhidham', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1101, 'name' => 'Anand', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Haryana
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Faridabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Gurgaon', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Panipat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Ambala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Yamunanagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Rohtak', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Hisar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Karnal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Sonipat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1102, 'name' => 'Panchkula', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Himachal Pradesh
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Shimla', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Solan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Dharamshala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Mandi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Palampur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Kullu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Chamba', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Bilaspur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1103, 'name' => 'Nahan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Jharkhand
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Ranchi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Jamshedpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Dhanbad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Bokaro Steel City', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Deoghar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Phusro', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Hazaribagh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Giridih', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1104, 'name' => 'Ramgarh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Karnataka
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Bangalore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Mysore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Hubli-Dharwad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Mangalore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Belgaum', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Gulbarga', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Davanagere', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Bellary', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1105, 'name' => 'Bijapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Kerala
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Thiruvananthapuram', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Kochi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Kozhikode', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Kollam', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Thrissur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Palakkad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Alappuzha', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Malappuram', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1106, 'name' => 'Kannur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Madhya Pradesh
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Indore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Bhopal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Jabalpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Gwalior', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Ujjain', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Sagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Dewas', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Satna', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1107, 'name' => 'Ratlam', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Maharashtra
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Mumbai', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Pune', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Nagpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Nashik', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Aurangabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Solapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Amravati', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Malegaon', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1108, 'name' => 'Kolhapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Manipur
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Imphal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Thoubal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Kakching', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Lilong', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Mayang Imphal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Thongkhong Laxmi Bazar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Kakching Khunou', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Wangoi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1109, 'name' => 'Thoubal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Meghalaya
            array('uuid' => getUuid(), 'state_id' => 1110, 'name' => 'Shillong', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1110, 'name' => 'Tura', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1110, 'name' => 'Nongstoin', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1110, 'name' => 'Jowai', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1110, 'name' => 'Baghmara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1110, 'name' => 'Williamnagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1110, 'name' => 'Nongpoh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Mizoram
            array('uuid' => getUuid(), 'state_id' => 1111, 'name' => 'Aizawl', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1111, 'name' => 'Lunglei', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1111, 'name' => 'Saiha', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1111, 'name' => 'Champhai', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1111, 'name' => 'Kolasib', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1111, 'name' => 'Serchhip', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1111, 'name' => 'Lawngtlai', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Nagaland
            array('uuid' => getUuid(), 'state_id' => 1112, 'name' => 'Kohima', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1112, 'name' => 'Dimapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1112, 'name' => 'Mokokchung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1112, 'name' => 'Tuensang', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1112, 'name' => 'Wokha', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1112, 'name' => 'Zunheboto', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1112, 'name' => 'Phek', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Odisha
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Bhubaneswar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Cuttack', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Rourkela', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Berhampur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Sambalpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Puri', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Baleshwar Town', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Baripada Town', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1113, 'name' => 'Bhadrak', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // punjab
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Amritsar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Bathinda', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Jalandhar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Kapurthala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Hosiarpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Ludhiana', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Firozpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Patiala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Gurdaspur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Mohali', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Faridkot', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Fatehgarh Sahib', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Bahawalpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Batala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Khanna', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Barnala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Sangrur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'bagha Purana', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1114, 'name' => 'Mandi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Rajasthan
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Tonak', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Ajmer', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Udaipur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Bikaner', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Baran', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Pali', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Sikar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'kota', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Alwar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Jodhpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Jaipur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Sri Ganganagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Bhilwara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Dholpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Bharatpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Hanumangarh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Banswara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Beawar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1115, 'name' => 'Dungarpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Chandigarh
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Atawa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Badheri', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Bahlana', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Bajwara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Burail', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Dariya', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Dhanas', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Fatehgarh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Jhampur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Kasil', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Kursan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1124, 'name' => 'Mastgarh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Delhi
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'begum Pur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Muzaffarnagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Ghaziabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Firozabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Bulandshahr', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Alwar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Agra', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Meerut', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Faridabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Rohtak', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Farrukhabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Gurugram', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Mathura', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Haridwar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Karnal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Panipat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Ambala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Hapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Sonipat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1127, 'name' => 'Jalandhar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),


            // Nepal states against cities

            // Bagmati
            array('uuid' => getUuid(), 'state_id' => 1866, 'name' => 'Kathmandu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1866, 'name' => 'Bhaktapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1866, 'name' => 'Lalitpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Gandaki
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Pokhara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Besisahar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Gorkha', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Baglung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Chame', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Bhanu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Galkot', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Galyang', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Karaputar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Kawasoti', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1867, 'name' => 'Kushma', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Malang
            array('uuid' => getUuid(), 'state_id' => 1868, 'name' => 'Kushma', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1868, 'name' => 'Kushma', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1868, 'name' => 'Kushma', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1868, 'name' => 'Kushma', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1868, 'name' => 'Kushma', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 1868, 'name' => 'Kushma', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),


            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Pokhara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Lalitpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Biratnagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Bhaktapur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Janakpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Butwal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Dhangadhi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Hetauda', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Bhairahawa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Ilam', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Nepalgunj', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Tansen', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Gulariya', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 154, 'name' => 'Dharan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // pakistan states against cities

            // punjab
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Multan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Faisalabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Bahawalpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Gujranwala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Lahore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Islamabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Dera Ghazi Khan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Rawalpindi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Sargodha', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Sialkot', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Hafizabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Jhang District', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Kasur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Ahmadpur Sial', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Chakwal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Chiniot', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Sheikhupura', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Attock', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Bahawalnagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Sahiwal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2046, 'name' => 'Okara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // sindh
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Hyderabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Larkana', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Karachi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Sukkur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Jacobabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Khairpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Ghotki', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Shikarpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Thatta', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Jamshoro', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Matiari', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Mirpur Khas', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Sujawal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Kashmore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Naushahro', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Qambar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Tando Allah Yar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Badin', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Dadu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Tando Muhammad khan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2047, 'name' => 'Shaheed Benazirabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // khyber pakhtunkhwa (kpk)
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Abbottabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Bannu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Charsadda', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Dera Ismail Khan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Haripur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Kohat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'kurram', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Landi Kotal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Mardan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Mingora', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Nawan Shehr', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Peshawar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2045, 'name' => 'Sadda', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // gilgit baltistan
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Gilgit', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Skardu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Khaplu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Dambudas', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Aliabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Askole', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Astore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Nagar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Hunza', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2044, 'name' => 'Ghizer', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Azad Jammu and Kashmir
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Muzaffarabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Mirpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Kotli', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Rawalakot', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Bagh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Hattian Bala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Haveli', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Sudhnuti', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Poonch', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2041, 'name' => 'Bhimber', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Balochistan
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Quetta', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Khuzdar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Chaman', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Turbat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Sibi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Zhob', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Dera Bugti', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Kohlu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Kharan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Mastung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Nushki', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Kalat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Makran', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Lasbela', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Awaran', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Barkhan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Chagai', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Duki', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Gwadar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Jafarabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Jhal Magsi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Kachhi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 2042, 'name' => 'Kech', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),


            // afganistan
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Kabul', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Kandahar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Herat', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Mazar-i-Sharif', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Jalalabad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Ghazni', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Baghlan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Balkh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Nangarhar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Paktia', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Paktika', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Takhar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Logar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Wardak', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Faryab', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Bamyan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Kunar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Khost', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Nimroz', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Zabul', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Urozgan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Daykundi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Nuristan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Samangan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Ghor', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Badghis', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Jowzjan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 3, 'name' => 'Sar-e Pol', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // bangladash
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Dhaka', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Chittagong', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Rajshahi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Khulna', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Sylhet', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Barisal', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Rangpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Mymensingh', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Comilla', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Narayanganj', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Tangail', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Pabna', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Naogaon', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Jashore', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Narsingdi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Meherpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Chandpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Manikganj', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Brahmanbaria', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Habiganj', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Netrakona', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Shariatpur', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Chilmari', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 19, 'name' => 'Kurigram', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // sri lanka
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Colombo', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Kandy', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Galle', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Jaffna', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Negombo', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Anuradhapura', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Trincomalee', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Batticaloa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Matara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Kurunegala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Badulla', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Ratnapura', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Moneragala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Mullaitivu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Vavuniya', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Polonnaruwa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Kilinochchi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Puttalam', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Maharagama', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Kalutara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Colombo District', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 117, 'name' => 'Kegalle', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Maldives
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Malé', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Addu City', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Fuvahmulah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Kulhudhuffushi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Hinnavaru', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Thulusdhoo', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Mihdhoo', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Dhidhdhoo', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Bilehdhoo', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Kandoo', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Raa Atoll', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Gaafu Alif', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Shaviyani Atoll', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 141, 'name' => 'Laccadive Islands', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // iran
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Tehran', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Mashhad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Isfahan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Karaj', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Shiraz', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Tabriz', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Ahvaz', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Kermanshah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Qom', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Zahedan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Yazd', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Hamedan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Urmia', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Rasht', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Arak', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Kerman', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Bushehr', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Shahrekord', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Gorgan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Kish Island', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 96, 'name' => 'Sari', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // iraq
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Baghdad', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Basra', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Mosul', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Erbil', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Sulaymaniyah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Najaf', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Karbala', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Duhok', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Kut', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Samawah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Diwaniya', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Amara', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Tikrit', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Ramadi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Fallujah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Hilla', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Baghdadi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Ramadi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Khaniqin', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 95, 'name' => 'Babil', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // Taiwan
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Taipei', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Kaohsiung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Taichung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Tainan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Taipei County', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Keelung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Hsinchu', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Chiayi', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Taoyuan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Changhua', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Yunlin', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Miaoli', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Pingtung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Hualien', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Taitung', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Keelung City', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Chiayi City', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Kinmen', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 207, 'name' => 'Lienchiang', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // northern mariana islands
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Saipan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Garapan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'San Jose', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Kagman', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Capitol Hill', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Chalan Kanoa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Tinian', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Rota', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Kanoa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 136, 'name' => 'Maug Islands', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),

            // yemen
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Sana\'a', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Aden', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Taiz', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Hudaydah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Ibb', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Dhamar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Al Mukalla', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Zinjibar', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Rada\'a', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Marib', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Sayun', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Al Bayda', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Al Hudaydah', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Al Mahwit', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Al Jawf', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Abyan', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Al Dali', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Shabwa', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'state_id' => 224, 'name' => 'Hadramawt', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null)

        ];

        City::insert($cities);
    }
}
