<?php

namespace Database\Seeders;

use App\Models\Condition;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class ConditionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $conditions = [
            [
                'name' => 'New',
                'slug' => 'new',
                'description' => 'Brand new vehicle, never used',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Used',
                'slug' => 'used',
                'description' => 'Previously owned vehicle',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Certified Pre-Owned',
                'slug' => 'certified_pre_owned',
                'description' => 'Certified pre-owned vehicle with warranty',
                'is_active' => true,
                'sort_order' => 3,
            ],
        ];

        foreach ($conditions as $condition) {
            Condition::firstOrCreate(
                ['slug' => $condition['slug']],
                $condition
            );
        }
    }
}

