<?php

namespace Database\Seeders;

use App\Models\Country;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class CountrySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        Country::truncate();
        Schema::enableForeignKeyConstraints();

        $statusInactive = Country::STATUS_INACTIVE;
        $statusActive = Country::STATUS_ACTIVE;

        $countries = array(
            array('uuid' => getUuid(), 'name' => 'andorra', 'iso' => 'ad', 'dialing_code' => '376', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'united arab emirates', 'iso' => 'ae', 'dialing_code' => '971', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'afghanistan', 'iso' => 'af', 'dialing_code' => '93', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'antigua and barbuda', 'iso' => 'ag', 'dialing_code' => '1268', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'anguilla', 'iso' => 'ai', 'dialing_code' => '1264', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'albania', 'iso' => 'al', 'dialing_code' => '355', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'armenia', 'iso' => 'am', 'dialing_code' => '374', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'netherlands antilles', 'iso' => 'an', 'dialing_code' => '599', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'angola', 'iso' => 'ao', 'dialing_code' => '244', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'name' => 'antarctica', 'iso' => 'aq', 'dialing_code' => '672', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ar', 'name' => 'argentina', 'dialing_code' => '54', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'as', 'name' => 'american samoa', 'dialing_code' => '1684', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'at', 'name' => 'austria', 'dialing_code' => '43', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'au', 'name' => 'australia', 'dialing_code' => '61', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'aw', 'name' => 'aruba', 'dialing_code' => '297', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'az', 'name' => 'azerbaijan', 'dialing_code' => '994', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ba', 'name' => 'bosnia and herzegovina', 'dialing_code' => '387', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bb', 'name' => 'barbados', 'dialing_code' => '1246', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bd', 'name' => 'bangladesh', 'dialing_code' => '880', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'be', 'name' => 'belgium', 'dialing_code' => '32', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bf', 'name' => 'burkina faso', 'dialing_code' => '226', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bg', 'name' => 'bulgaria', 'dialing_code' => '359', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bh', 'name' => 'bahrain', 'dialing_code' => '973', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bi', 'name' => 'burundi', 'dialing_code' => '257', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bj', 'name' => 'benin', 'dialing_code' => '229', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bl', 'name' => 'saint barthelemy', 'dialing_code' => '590', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bm', 'name' => 'bermuda', 'dialing_code' => '1441', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bn', 'name' => 'brunei darussalam', 'dialing_code' => '673', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bo', 'name' => 'bolivia', 'dialing_code' => '591', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'br', 'name' => 'brazil', 'dialing_code' => '55', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bs', 'name' => 'bahamas', 'dialing_code' => '1242', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bt', 'name' => 'bhutan', 'dialing_code' => '975', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bw', 'name' => 'botswana', 'dialing_code' => '267', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'by', 'name' => 'belarus', 'dialing_code' => '375', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'bz', 'name' => 'belize', 'dialing_code' => '501', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ca', 'name' => 'canada', 'dialing_code' => '1', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cc', 'name' => 'cocos (keeling) islands', 'dialing_code' => '61', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cd', 'name' => 'congo, the democratic republic of the', 'dialing_code' => '243', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cf', 'name' => 'central african republic', 'dialing_code' => '236', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cg', 'name' => 'congo', 'dialing_code' => '242', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ch', 'name' => 'switzerland', 'dialing_code' => '41', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ci', 'name' => 'cote d ivoire', 'dialing_code' => '225', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ck', 'name' => 'cook islands', 'dialing_code' => '682', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cl', 'name' => 'chile', 'dialing_code' => '56', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cm', 'name' => 'cameroon', 'dialing_code' => '237', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cn', 'name' => 'china', 'dialing_code' => '86', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'co', 'name' => 'colombia', 'dialing_code' => '57', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cr', 'name' => 'costa rica', 'dialing_code' => '506', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cu', 'name' => 'cuba', 'dialing_code' => '53', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cv', 'name' => 'cape verde', 'dialing_code' => '238', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cx', 'name' => 'christmas island', 'dialing_code' => '61', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cy', 'name' => 'cyprus', 'dialing_code' => '357', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'cz', 'name' => 'czech republic', 'dialing_code' => '420', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'de', 'name' => 'germany', 'dialing_code' => '49', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'dj', 'name' => 'djibouti', 'dialing_code' => '253', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'dk', 'name' => 'denmark', 'dialing_code' => '45', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'dm', 'name' => 'dominica', 'dialing_code' => '1767', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'do', 'name' => 'dominican republic', 'dialing_code' => '1809', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'dz', 'name' => 'algeria', 'dialing_code' => '213', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ec', 'name' => 'ecuador', 'dialing_code' => '593', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ee', 'name' => 'estonia', 'dialing_code' => '372', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'eg', 'name' => 'egypt', 'dialing_code' => '20', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'er', 'name' => 'eritrea', 'dialing_code' => '291', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'es', 'name' => 'spain', 'dialing_code' => '34', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'et', 'name' => 'ethiopia', 'dialing_code' => '251', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'fi', 'name' => 'finland', 'dialing_code' => '358', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'fj', 'name' => 'fiji', 'dialing_code' => '679', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'fk', 'name' => 'falkland islands (malvinas)', 'dialing_code' => '500', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'fm', 'name' => 'micronesia, federated states of', 'dialing_code' => '691', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'fo', 'name' => 'faroe islands', 'dialing_code' => '298', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'fr', 'name' => 'france', 'dialing_code' => '33', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ga', 'name' => 'gabon', 'dialing_code' => '241', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gb', 'name' => 'united kingdom', 'dialing_code' => '44', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gd', 'name' => 'grenada', 'dialing_code' => '1473', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ge', 'name' => 'georgia', 'dialing_code' => '995', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gh', 'name' => 'ghana', 'dialing_code' => '233', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gi', 'name' => 'gibraltar', 'dialing_code' => '350', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gl', 'name' => 'greenland', 'dialing_code' => '299', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gm', 'name' => 'gambia', 'dialing_code' => '220', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gn', 'name' => 'guinea', 'dialing_code' => '224', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gq', 'name' => 'equatorial guinea', 'dialing_code' => '240', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gr', 'name' => 'greece', 'dialing_code' => '30', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gt', 'name' => 'guatemala', 'dialing_code' => '502', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gu', 'name' => 'guam', 'dialing_code' => '1671', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gw', 'name' => 'guinea-bissau', 'dialing_code' => '245', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'gy', 'name' => 'guyana', 'dialing_code' => '592', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'hk', 'name' => 'hong kong', 'dialing_code' => '852', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'hn', 'name' => 'honduras', 'dialing_code' => '504', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'hr', 'name' => 'croatia', 'dialing_code' => '385', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ht', 'name' => 'haiti', 'dialing_code' => '509', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'hu', 'name' => 'hungary', 'dialing_code' => '36', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'id', 'name' => 'indonesia', 'dialing_code' => '62', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ie', 'name' => 'ireland', 'dialing_code' => '353', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'il', 'name' => 'israel', 'dialing_code' => '972', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'im', 'name' => 'isle of man', 'dialing_code' => '44', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'in', 'name' => 'india', 'dialing_code' => '91', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'iq', 'name' => 'iraq', 'dialing_code' => '964', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ir', 'name' => 'iran, islamic republic of', 'dialing_code' => '98', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'is', 'name' => 'iceland', 'dialing_code' => '354', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'it', 'name' => 'italy', 'dialing_code' => '39', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'jm', 'name' => 'jamaica', 'dialing_code' => '1876', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'jo', 'name' => 'jordan', 'dialing_code' => '962', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'jp', 'name' => 'japan', 'dialing_code' => '81', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ke', 'name' => 'kenya', 'dialing_code' => '254', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'kg', 'name' => 'kyrgyzstan', 'dialing_code' => '996', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'kh', 'name' => 'cambodia', 'dialing_code' => '855', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ki', 'name' => 'kiribati', 'dialing_code' => '686', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'km', 'name' => 'comoros', 'dialing_code' => '269', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'kn', 'name' => 'saint kitts and nevis', 'dialing_code' => '1869', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'kp', 'name' => 'korea democratic peoples republic of', 'dialing_code' => '850', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'kr', 'name' => 'korea republic of', 'dialing_code' => '82', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'kw', 'name' => 'kuwait', 'dialing_code' => '965', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ky', 'name' => 'cayman islands', 'dialing_code' => '1345', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'kz', 'name' => 'kazakstan', 'dialing_code' => '7', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'la', 'name' => 'lao peoples democratic republic', 'dialing_code' => '856', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'lb', 'name' => 'lebanon', 'dialing_code' => '961', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'lc', 'name' => 'saint lucia', 'dialing_code' => '1758', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'li', 'name' => 'liechtenstein', 'dialing_code' => '423', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'lk', 'name' => 'sri lanka', 'dialing_code' => '94', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'lr', 'name' => 'liberia', 'dialing_code' => '231', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ls', 'name' => 'lesotho', 'dialing_code' => '266', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'lt', 'name' => 'lithuania', 'dialing_code' => '370', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'lu', 'name' => 'luxembourg', 'dialing_code' => '352', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'lv', 'name' => 'latvia', 'dialing_code' => '371', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ly', 'name' => 'libyan arab jamahiriya', 'dialing_code' => '218', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ma', 'name' => 'morocco', 'dialing_code' => '212', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mc', 'name' => 'monaco', 'dialing_code' => '377', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'md', 'name' => 'moldova, republic of', 'dialing_code' => '373', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'me', 'name' => 'montenegro', 'dialing_code' => '382', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mf', 'name' => 'saint martin', 'dialing_code' => '1599', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mg', 'name' => 'madagascar', 'dialing_code' => '261', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mh', 'name' => 'marshall islands', 'dialing_code' => '692', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mk', 'name' => 'macedonia, the former yugoslav republic of', 'dialing_code' => '389', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ml', 'name' => 'mali', 'dialing_code' => '223', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mm', 'name' => 'myanmar', 'dialing_code' => '95', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mn', 'name' => 'mongolia', 'dialing_code' => '976', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mo', 'name' => 'macau', 'dialing_code' => '853', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mp', 'name' => 'northern mariana islands', 'dialing_code' => '1670', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mr', 'name' => 'mauritania', 'dialing_code' => '222', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ms', 'name' => 'montserrat', 'dialing_code' => '1664', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mt', 'name' => 'malta', 'dialing_code' => '356', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mu', 'name' => 'mauritius', 'dialing_code' => '230', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mv', 'name' => 'maldives', 'dialing_code' => '960', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mw', 'name' => 'malawi', 'dialing_code' => '265', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mx', 'name' => 'mexico', 'dialing_code' => '52', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'my', 'name' => 'malaysia', 'dialing_code' => '60', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'mz', 'name' => 'mozambique', 'dialing_code' => '258', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'na', 'name' => 'namibia', 'dialing_code' => '264', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'nc', 'name' => 'new caledonia', 'dialing_code' => '687', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ne', 'name' => 'niger', 'dialing_code' => '227', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ng', 'name' => 'nigeria', 'dialing_code' => '234', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ni', 'name' => 'nicaragua', 'dialing_code' => '505', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'nl', 'name' => 'netherlands', 'dialing_code' => '31', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'no', 'name' => 'norway', 'dialing_code' => '47', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'np', 'name' => 'nepal', 'dialing_code' => '977', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'nr', 'name' => 'nauru', 'dialing_code' => '674', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'nu', 'name' => 'niue', 'dialing_code' => '683', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'nz', 'name' => 'new zealand', 'dialing_code' => '64', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'om', 'name' => 'oman', 'dialing_code' => '968', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pa', 'name' => 'panama', 'dialing_code' => '507', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pe', 'name' => 'peru', 'dialing_code' => '51', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pf', 'name' => 'french polynesia', 'dialing_code' => '689', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pg', 'name' => 'papua new guinea', 'dialing_code' => '675', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ph', 'name' => 'philippines', 'dialing_code' => '63', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pk', 'name' => 'pakistan', 'dialing_code' => '92', 'status' => $statusActive),
            array('uuid' => getUuid(), 'iso' => 'pl', 'name' => 'poland', 'dialing_code' => '48', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pm', 'name' => 'saint pierre and miquelon', 'dialing_code' => '508', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pn', 'name' => 'pitcairn', 'dialing_code' => '870', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pr', 'name' => 'puerto rico', 'dialing_code' => '1', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pt', 'name' => 'portugal', 'dialing_code' => '351', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'pw', 'name' => 'palau', 'dialing_code' => '680', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'py', 'name' => 'paraguay', 'dialing_code' => '595', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'qa', 'name' => 'qatar', 'dialing_code' => '974', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ro', 'name' => 'romania', 'dialing_code' => '40', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'rs', 'name' => 'serbia', 'dialing_code' => '381', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ru', 'name' => 'russian federation', 'dialing_code' => '7', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'rw', 'name' => 'rwanda', 'dialing_code' => '250', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sa', 'name' => 'saudi arabia', 'dialing_code' => '966', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sb', 'name' => 'solomon islands', 'dialing_code' => '677', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sc', 'name' => 'seychelles', 'dialing_code' => '248', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sd', 'name' => 'sudan', 'dialing_code' => '249', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'se', 'name' => 'sweden', 'dialing_code' => '46', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sg', 'name' => 'singapore', 'dialing_code' => '65', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sh', 'name' => 'saint helena', 'dialing_code' => '290', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'si', 'name' => 'slovenia', 'dialing_code' => '386', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sk', 'name' => 'slovakia', 'dialing_code' => '421', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sl', 'name' => 'sierra leone', 'dialing_code' => '232', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sm', 'name' => 'san marino', 'dialing_code' => '378', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sn', 'name' => 'senegal', 'dialing_code' => '221', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'so', 'name' => 'somalia', 'dialing_code' => '252', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sr', 'name' => 'suriname', 'dialing_code' => '597', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'st', 'name' => 'sao tome and principe', 'dialing_code' => '239', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sv', 'name' => 'el salvador', 'dialing_code' => '503', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sy', 'name' => 'syrian arab republic', 'dialing_code' => '963', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'sz', 'name' => 'swaziland', 'dialing_code' => '268', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tc', 'name' => 'turks and caicos islands', 'dialing_code' => '1649', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'td', 'name' => 'chad', 'dialing_code' => '235', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tg', 'name' => 'togo', 'dialing_code' => '228', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'th', 'name' => 'thailand', 'dialing_code' => '66', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tj', 'name' => 'tajikistan', 'dialing_code' => '992', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tk', 'name' => 'tokelau', 'dialing_code' => '690', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tl', 'name' => 'timor-leste', 'dialing_code' => '670', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tm', 'name' => 'turkmenistan', 'dialing_code' => '993', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tn', 'name' => 'tunisia', 'dialing_code' => '216', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'to', 'name' => 'tonga', 'dialing_code' => '676', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tr', 'name' => 'turkey', 'dialing_code' => '90', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tt', 'name' => 'trinidad and tobago', 'dialing_code' => '1868', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tv', 'name' => 'tuvalu', 'dialing_code' => '688', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tw', 'name' => 'taiwan, province of china', 'dialing_code' => '886', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'tz', 'name' => 'tanzania, united republic of', 'dialing_code' => '255', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ua', 'name' => 'ukraine', 'dialing_code' => '380', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ug', 'name' => 'uganda', 'dialing_code' => '256', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'us', 'name' => 'united states', 'dialing_code' => '1', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'uy', 'name' => 'uruguay', 'dialing_code' => '598', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'uz', 'name' => 'uzbekistan', 'dialing_code' => '998', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'va', 'name' => 'holy see (vatican city state)', 'dialing_code' => '39', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'vc', 'name' => 'saint vincent and the grenadines', 'dialing_code' => '1784', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 've', 'name' => 'venezuela', 'dialing_code' => '58', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'vg', 'name' => 'virgin islands, british', 'dialing_code' => '1284', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'vi', 'name' => 'virgin islands, U.S.', 'dialing_code' => '1340', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'vn', 'name' => 'viet nam', 'dialing_code' => '84', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'vu', 'name' => 'vanuatu', 'dialing_code' => '678', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'wf', 'name' => 'wallis and futuna', 'dialing_code' => '681', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ws', 'name' => 'samoa', 'dialing_code' => '685', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'xk', 'name' => 'kosovo', 'dialing_code' => '381', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'ye', 'name' => 'yemen', 'dialing_code' => '967', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'yt', 'name' => 'mayotte', 'dialing_code' => '262', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'za', 'name' => 'south africa', 'dialing_code' => '27', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'zm', 'name' => 'zambia', 'dialing_code' => '260', 'status' => $statusInactive),
            array('uuid' => getUuid(), 'iso' => 'zw', 'name' => 'zimbabwe', 'dialing_code' => '263', 'status' => $statusInactive)
        );

        Country::insert($countries);
    }
}
