<?php

namespace Database\Seeders;

use App\Models\Dealers\Dealer;
use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Enum\Status;

class DealerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Dealer::factory()
            ->count(5)
            ->has(User::factory()
                ->state(function () {
                    return [
                        'status' => fake()->randomElement(Status::cases())->value,
                    ];
                })
            )
            ->create()
            ->each(function ($dealer) {
                $user = $dealer->user;

                $user->settings()->createMany([
                    ['key' => 'is_dark_mode', 'value' => false],
                    ['key' => 'is_compact_sidebar', 'value' => false],
                ]);

                $user->assignRole(Role::DEALER);
            });
    }
}
