<?php

namespace Database\Seeders;

use App\Models\Documentation;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class DocumentationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        Documentation::truncate();
        Schema::enableForeignKeyConstraints();

        $now = now();

        Documentation::insert([
            [
                'uuid' => getUuid(),
                'key' => 'introduction',
                'title' => 'Quick introduction to the management system',
                'slug' => 'quick-introduction-to-the-management-system',
                'is_deletable' => false,
                'content' => '<p>Benvenuti nel sistema gestionale progettato specificamente per le RSA, con l\'obiettivo di ottimizzare la gestione operativa e migliorare la qualità del servizio. Questo gestionale è stato sviluppato utilizzando tecnologie avanzate come Laravel e MySQL, garantendo una piattaforma sicura, scalabile e adattabile alle esigenze delle strutture sanitarie.</p>
                <p>Il sistema integra tutte le funzionalità necessarie per una gestione completa: dalla pianificazione dei turni del personale alla gestione dei pazienti, dalla fatturazione alla rendicontazione delle ore lavorative, fino al monitoraggio dei prodotti di magazzino e dei servizi offerti. Ogni modulo del gestionale è stato progettato per essere intuitivo e facilmente utilizzabile, riducendo i tempi operativi e minimizzando gli errori.</p>
                <p>La nostra piattaforma si basa su un\'architettura moderna e modulare, che permette una gestione centralizzata e personalizzata di tutti i processi interni. Utilizzando strumenti e tecnologie di ultima generazione, il gestionale offre un’interfaccia utente semplice e accessibile, rendendo le operazioni quotidiane più efficienti e consentendo al personale di concentrarsi maggiormente sull’assistenza e sul benessere degli ospiti.</p>
                <p>Con questo gestionale, mettiamo a disposizione una soluzione completa e affidabile che facilita la comunicazione e il coordinamento tra tutti gli operatori, migliorando la qualità del servizio offerto. Il nostro impegno è fornire uno strumento che supporti la gestione della struttura a 360 gradi, contribuendo a un’organizzazione ottimizzata e a un ambiente di lavoro più sereno e produttivo.</p>',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'roles',
                'title' => 'Roles System Module Documentation',
                'slug' => 'roles-systems-module-documentation',
                'is_deletable' => false,
                'content' => '<h4>Overview</h4>
                <p>The Roles System Module is designed to manage and enforce different levels of access and permissions within the system. It consists of three core roles—Super Admin, Owner, and Agent—along with the ability to create and manage custom roles. This document outlines the roles, their permissions, and the process for creating and managing custom roles.</p>

                <h5>Core Roles</h5>
                <ul class="list">
                    <li>
                        <h6>Super Admin</h6>
                        <ul class="list">
                            <li>
                                <p><b>Description:</b> The Super Admin has the highest level of access within the system.</p>
                            </li>
                            <li>
                                <p><b>Permissions:</b></p>
                                <ul class="list">
                                    <li>Full access to all system features and settings.</li>
                                    <li>Cannot have permissions altered.</li>
                                    <li>Cannot be deleted.</li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <h6>User</h6>
                        <ul class="list">
                            <li>
                                <p><b>Description:</b> The User is responsible for managing a specific part or aspect of the system.</p>
                            </li>
                            <li>
                                <p><b>Permissions:</b></p>
                                <ul class="list">
                                    <li>Access to features and settings pertinent to their ownership.</li>
                                    <li>Can create, update, and delete content within their scope.</li>
                                    <li>Cannot be deleted.</li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                </ul>
                <h4>Custom Roles</h4>
                <ul>
                    <li>
                        <h5>Creating a Custom Role</h5>
                        <ul class="list">
                            <li><b>Access:</b> Navigate to the Roles Management section within the admin panel.</li>
                            <li><b>Click "Create Role":</b> Initiates the process of defining a new role.</li>
                            <li>
                                <p><b>Define Role Details:</b></p>
                                <ul>
                                    <li><b>Name:</b> Enter a unique name for the role.</li>
                                </ul>
                            </li>
                            <li><b>Assign Permissions:</b>
                                <ul>
                                    <li>Select the permissions that should be granted to this role.</li>
                                    <li>Permissions include access to specific features, actions (create, read, update, delete), and settings.</li>
                                </ul>
                            </li>
                            <li><b>Save Role:</b> Finalize the creation by saving the role.</li>
                        </ul>
                    </li>
                    <li>
                        <h5>Managing Custom Roles</h5>
                        <ul class="list">
                            <li>
                                <h6>Edit Role:</h6>
                                <ul>
                                    <li>Navigate to the Roles Management section.</li>
                                    <li>Select the role to be edited.</li>
                                    <li>Update the role details and permissions as needed.</li>
                                    <li>Save changes.</li>
                                </ul>
                            </li>
                            <li>
                                <h6>Delete Role:</h6>
                                <ul>
                                    <li>Navigate to the Roles Management section.</li>
                                    <li>Select the role to be deleted.</li>
                                    <li>Confirm the deletion.</li>
                                    <li>Note: Only roles without critical dependencies can be deleted.</li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li>
                        <h5>Permissions for Creating and Deleting Roles</h5>
                        <ul class="list">
                            <li><b>Who Can Create Roles:</b> Only users with the appropriate permissions (typically Owners or Super Admins) can create new roles.</li>
                            <li><b>Who Can Delete Roles:</b> Only users with the appropriate permissions (typically Owners or Super Admins) can delete roles.</li>
                        </ul>
                    </li>
                    <li>
                        <h5>Important Considerations</h5>
                        <ul class="list">
                            <li><b>Non-Deletable Roles:</b> Super Admin, Owner, and Agent roles are fundamental to the system’s structure and cannot be deleted.</li>
                            <li><b>Immutable Permissions for Super Admin:</b> The permissions for the Super Admin role are fixed and cannot be modified to ensure the integrity and security of the system.</li>
                        </ul>
                    </li>
                </ul>
                <h4>User Interface</h4>
                <h5>Roles Management Section</h5>
                <p>The Roles Management section includes:</p>
                <ul class="list">
                    <li><b>Role List:</b> Displays all existing roles, both core and custom, along with their number of users assigned to each role.</li>
                    <li><b>Create Role Button:</b> Initiates the creation of a new role.</li>
                    <li><b>Edit and Delete Options:</b> Available for custom roles to modify or remove them as needed.</li>
                </ul>
                <p>By following these guidelines, the Roles System Module ensures a structured and secure approach to managing user access and permissions within the system.</p>',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'users',
                'title' => 'User Management Module Guide',
                'slug' => 'user-management-module-guide',
                'is_deletable' => false,
                'content' => '<h4>Overview</h4>
                <p>The User Management Module allows you to view, create, update, and delete users. Depending on your role and permissions, you can perform different actions within this module.</p>
                <h5>Navigating to User Management</h5>
                <ul class="mb-2">
                    <li><b>Login to the system:</b> Ensure you are logged in with the necessary permissions to access the User Management Module.</li>
                    <li><b>Access User Management:</b> From the main dashboard, navigate to the "Users" section using the sidebar or menu options.</li>
                </ul>
                <h5>User List</h5>
                <p>The User List displays all users in the system. You can see details such as name, email, phone numbers, roles, status, comments, and more.</p>
                <b>Features</b>
                <ul class="list my-1">
                    <li><b>Search and Filter:</b> Use the search bar to find specific users.</li>
                    <li><b>Sort Columns:</b> Click on column headers to sort the list by that column.</li>
                    <li><b>Pagination:</b> Navigate through pages of users using the pagination controls at the bottom.</li>
                </ul>
                <b>Actions</b>
                <ul class="list mt-1 mb-2">
                    <li><b>View User:</b> Click on a user’s name to view their details.</li>
                    <li><b>Edit User:</b> Click the "Edit" button next to a user to modify their information.</li>
                    <li><b>Delete User:</b> Click the "Delete" button to remove a user from the system.</li>
                </ul>
                <h5>Adding a New User</h5>
                <ul class="list mt-1 mb-2">
                    <li><b>Navigate to Add User:</b> Click the "Invite New User" button in the User Management section.</li>
                    <li><b>Fill in User Details:</b>
                        <ul>
                            <li><b>Name:</b> Enter the user’s name.</li>
                            <li><b>Email:</b> Enter the user’s email address.</li>
                            <li><b>Role:</b> Select the user’s role from the dropdown menu.</li>
                            <li><b>Phone Numbers:</b> (Optional) Enter the user’s phone and alternate phone numbers.</li>
                        </ul>
                    </li>
                    <li><b>Send Invitation:</b> Click "Invite" to send an invitation email to the new user. They will receive an email with a link to set up their password and complete their registration.</li>
                </ul>
                <h5>Editing a User</h5>
                <ul class="list mt-1 mb-2">
                    <li><b>Select User to Edit:</b> In the User List, click the "Edit" button next to the user you want to modify.</li>
                    <li><b>Modify User Details:</b>
                        <ul>
                            <li><b>Status:</b> Select the user’s status (Active, Suspended, etc.).</li>
                            <li><b>Role:</b> (For super admins) Change the user’s role.</li>
                            <li><b>Comments:</b> Add any administrative comments, especially if suspending the user.</li>
                        </ul>
                    </li>
                    <li><b>Save Changes:</b> Click "Update" to save the changes.</li>
                </ul>
                <h5>Viewing User Comments</h5>
                <ul class="list mt-1 mb-2">
                    <li><b>Select User to View Comments:</b> In the User List, click the "Comments" button next to the user you want to view.</li>
                    <li><b>View Comments:</b> A modal will display the administrative comments related to the user.</li>
                </ul>
                <h5>Deleting a User</h5>
                <ul class="list mt-1 mb-2">
                    <li><b>Select User to Delete:</b> In the User List, click the "Delete" button next to the user you want to remove.</li>
                    <li><b>Confirm Deletion:</b> A confirmation message will appear. Confirm to delete the user from the system.</li>
                </ul>
                <h5>Notes</h5>
                <p class="mb-2"><b>Restrictions:</b> You cannot delete users with the "super_admin" role. For "owner" roles, ensure they do not have any associated agents before deleting.</p>
                <h5>Summary</h5>
                <p>The User Management Module is designed to provide a comprehensive and easy-to-use interface for managing users in the system. With intuitive controls and clear actions, you can efficiently handle all user-related tasks. Enjoy managing your users with ease!</p>',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'terms_conditions',
                'title' => 'Terms & Conditions Management User Guide',
                'slug' => 'terms-conditions-management-user-guide',
                'is_deletable' => false,
                'content' => '<h4>Overview</h4>
                <p>This guide will walk you through using the Terms & Conditions Management system, including how to create, view, update, and delete terms and conditions pages.</p>

                <h5>Accessing the Terms & Conditions Management</h5>
                <ul class="list">
                    <li><b>Login to the system:</b> Ensure you are logged in with appropriate permissions.</li>
                    <li><b>Navigate to the Terms & Conditions section:</b> Find this section in the main menu.</li>
                </ul>

                <h5 class="mt-2">Viewing Terms & Conditions</h5>
                <p><b>Go to the Terms & Conditions Management page:</b> This page lists all the terms and conditions.</p>
                <p><b>Table Columns:</b> Position, Title, Content, Status, Created, Updated, Actions</p>

                <h5 class="mt-2">Editing Existing Terms & Conditions</h5>
                <p><b>Find the term to edit:</b> Locate the term in the table.</p>
                <p><b>Click the "Update" action:</b> This opens the edit form in a modal.</p>
                <p><b>Modify the necessary fields:</b></p>
                <ul class="list">
                    <li>Update the Title and/or Content as needed.</li>
                </ul>

                <p><b>Save Changes:</b> Click the "Save" button to update the term.</p>

                <h5 class="mt-2">Deleting Terms & Conditions</h5>
                <p><b>Find the term to delete:</b> Locate the term in the table.</p>
                <p><b>Click the "Delete" action:</b> A confirmation dialog will appear.</p>
                <p><b>Confirm Deletion:</b> Confirm to permanently delete the term.</p>

                <h5 class="mt-2">Viewing Terms & Conditions Page</h5>
                <p><b>Click on the term’s title:</b> This will take you to a page displaying the full content of the terms and conditions.</p>

                <h5 class="mt-2">Tips</h5>
                <p><b>Search and Filter:</b> Use the search bar and filters to quickly find specific terms.</p>
                <p><b>Permissions:</b> Ensure you have the correct permissions to add, edit, or delete terms.</p>
                <p><b>Status Indicators:</b> Look for the status badges (Draft or Published) to understand the visibility of each term.</p>

                <p class="mt-2">By following this guide, you can efficiently manage the terms and conditions for your application, ensuring they are up-to-date and accurately reflect your policies.</p>',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'activity_logs',
                'title' => 'Activity Log Feature Documentation',
                'slug' => 'activity-log-feature-documentation',
                'is_deletable' => false,
                'content' => '<h4>Overview</h4>
                <p>The Activity Log feature provides a comprehensive view of user activities within the system. This feature allows users to filter activities by date, user, and activity type, offering an efficient way to monitor and review actions.</p>

                <h5>Accessing the Activity Log</h5>
                <p><b>Navigate to the Activity Log Page:</b></p>
                <ul class="list">
                    <li>Open the application and log in.</li>
                    <li>Go to the <b>Activity Log</b> section from the main menu.</li>
                </ul>

                <h4 class="mt-2">Interface Components</h4>
                <p><b>Page Header</b></p>
                <ul class="list">
                    <li><b>Title:</b> "Activity Log"</li>
                    <li><b>Toggle Button:</b> A button labeled "Show User Agent" that toggles the visibility of the User Agent column in the activity log table.</li>
                </ul>

                <p class="mt-2"><b>Filters</b></p>
                <ul>
                    <li>
                        <b>Date Range Picker:</b>
                        <ul class="list">
                            <li>Located in the page tools section.</li>
                            <li>Allows users to select a start and end date to filter activities.</li>
                        </ul>
                    </li>
                    <li class="mt-2">
                        <b>User Filter:</b>
                        <ul class="list">
                            <li>Dropdown to select a specific user or view activities for all users.</li>
                            <li>Populated based on activities within the selected date range.</li>
                        </ul>
                    </li>
                    <li class="mt-2">
                        <b>Activity Filter:</b>
                        <ul class="list">
                            <li>Dropdown to select a specific activity type or view all activities.</li>
                            <li>Populated based on activities within the selected date range and user filter.</li>
                        </ul>
                    </li>
                </ul>

                <p class="mt-2"><b>Activity Log Table</b></p>
                <ul>
                    <li>
                        <b>Columns:</b> User, Subject User (Owner), Role, Activity, IP, User Agent, Description, Activity Performed At
                    </li>
                </ul>
                <p><b>Toggle Button:</b> A button labeled "Show User Agent" that toggles the visibility of the User Agent column.</p>

                <h4 class="mt-2">Using the Activity Log</h4>
                <p><b>Select Date Range:</b></p>
                <ul class="list">
                    <li>Click on the date range picker and choose the desired start and end dates.</li>
                    <li>The table will automatically update to show activities within the selected range.</li>
                </ul>

                <p class="mt-2"><b>Filter by User:</b></p>
                <ul class="list">
                    <li>After selecting the date range, the User filter dropdown will be populated.</li>
                    <li>Select a user to filter the activities specific to that user.</li>
                    <li>If "All" is selected, activities for all users within the date range will be displayed.</li>
                </ul>

                <p class="mt-2"><b>Filter by Activity:</b></p>
                <ul class="list">
                    <li>Once a user is selected, the Activity filter dropdown will be populated.</li>
                    <li>Select an activity to filter the logs by the specific activity type.</li>
                    <li>If "All" is selected, all activity types for the selected user and date range will be displayed.</li>
                </ul>

                <p class="mt-2"><b>Toggle User Agent Column:</b></p>
                <ul class="list">
                    <li>Click the "Show User Agent" button to toggle the visibility of the User Agent column.</li>
                    <li>The button text will change to "Hide User Agent" when the column is visible and vice versa.</li>
                </ul>

                <h4 class="mt-2">Example Scenario</h4>
                <p><b>Scenario:</b>  You want to view all activities performed by "John Doe" between "2024-01-01" and "2024-01-31".</p>
                <p><b>Steps:</b></p>
                <ul class="list">
                    <li>Open the Activity Log page.</li>
                    <li>Use the date range picker to select "2024-01-01" as the start date and "2024-01-31" as the end date.</li>
                    <li>Select "John Doe" from the User filter dropdown.</li>
                    <li>Leave the Activity filter as "All" to see all activities performed by John Doe in January 2024.</li>
                </ul>

                <p><b>Result:</b></p>
                <ul class="list">
                    <li>The table will display all activities performed by John Doe within the specified date range.</li>
                </ul>

                <h4 class="mt-2">Additional Features</h4>
                <ul class="list">
                    <li><b>Dynamic Table Updates:</b> The table updates automatically based on the selected filters without needing to reload the page.</li>
                    <li><b>Customizable View:</b> Toggle the visibility of specific columns for a more tailored view.</li>
                </ul>

                <p class="mt-2">This documentation covers the essential usage of the Activity Log feature, providing a user-friendly interface for monitoring system activities effectively.</p>',
                'created_at' => $now,
                'updated_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'tickets',
                'title' => 'Ticket System Management',
                'slug' => 'ticket-system-management',
                'is_deletable' => false,
                'content' => '<h4>Overview:</h4>
                <p>This demonstration will guide you through the process of managing support tickets in our ticketing system. You’ll learn how to create, view, reply to, and close tickets using the user interface.</p>

                <h5>Step-by-Step Guide</h5>
                <ul>
                    <li>
                        <b>Logging In</b>
                        <p>1. Open your web browser and navigate to the ticket management system login page.</p>
                        <p>2. Enter your username and password, then click on the "Login" button.</p>
                    </li>
                    <li class="mt-2">
                        <b>Dashboard</b>
                        <p>1. Upon successful login, you will be redirected to the dashboard.</p>
                        <p>2. The dashboard provides an overview of the tickets assigned to you and recent activities.</p>
                    </li>
                    <li class="mt-2">
                        <b>Creating a Ticket</b>
                        <p>1. Navigate to the "Tickets" section in the main menu and click on "Create Ticket."</p>
                        <p>2. Fill in the ticket form:</p>
                        <ul class="list">
                            <li><b>Title:</b> Enter a concise title for the issue.</li>
                            <li><b>Description:</b> Provide a detailed description of the issue.</li>
                            <li><b>Priority:</b> Select the priority level (Low, Medium, High).</li>
                            <li><b>Attachments:</b> Upload any relevant files or screenshots.</li>
                        </ul>
                        <p>3. Click the "Submit" button to create the ticket.</p>
                        <p>4. A confirmation message will appear, and the ticket will be added to the list of open tickets.</p>
                    </li>
                    <li class="mt-2">
                        <b>Viewing Tickets</b>
                        <ul class="list">
                            <li>Go to the "Tickets" section and click on "My Tickets" or "All Tickets" to view tickets.</li>
                            <li>You will see a list of tickets with their titles, statuses, priorities, and creation dates.</li>
                            <li>Click on a ticket title to view its details.</li>
                            <li>The ticket details page displays the ticket information, including all replies and status updates.</li>
                        </ul>
                    </li>
                    <li class="mt-2">
                        <b>Replying to a Ticket</b>
                        <ul class="list">
                            <li>On the ticket details page, scroll down to the "Replies" section.</li>
                            <li>Enter your reply in the provided text area.</li>
                            <li>You can also attach files if necessary.</li>
                            <li>Click the "Submit Reply" button to post your reply.</li>
                            <li>Your reply will be added to the conversation thread.</li>
                        </ul>
                    </li>
                    <li class="mt-2">
                        <b>Closing a Ticket</b>
                        <ul class="list">
                            <li>If the issue has been resolved, you can close the ticket.</li>
                            <li>On the ticket details page, click the "Close Ticket" button.</li>
                            <li>Confirm your action when prompted.</li>
                            <li>The ticket status will change to "Closed," and it will be moved to the closed tickets list.</li>
                        </ul>
                    </li>
                    <li class="mt-2">
                        <b>Notifications</b>
                        <ul class="list">
                            <li>You will receive notifications for important ticket activities, such as new replies or status changes.</li>
                            <li>Notifications will appear in the top-right corner of the interface.</li>
                        </ul>
                    </li>
                    <li class="mt-2">
                        <b>Searching and Filtering Tickets</b>
                        <ul class="list">
                            <li>Use the search bar at the top of the "Tickets" section to find specific tickets by title or description.</li>
                            <li>Apply filters to narrow down the list based on status, priority, or creation date.</li>
                        </ul>
                    </li>
                    <li class="mt-2">
                        <b>Profile and Settings</b>
                        <ul class="list">
                            <li>Access your profile by clicking on your username in the top-right corner.</li>
                            <li>You can update your profile information and change your password.</li>
                            <li>Adjust your notification settings and preferences.</li>
                        </ul>
                    </li>
                </ul>
                <h5 class="mt-2">Conclusion</h5>
                <p>This concludes the demonstration of the ticket management system. You now know how to create, view, reply to, and close tickets. For further assistance or questions, please refer to the help section or contact support.</p>',
                'created_at' => $now,
                'updated_at' => $now,
            ],
        ]);
    }
}
