<?php

namespace Database\Seeders;

use App\Models\Listing;
use App\Models\User;
use App\Models\VehicleFeature;
use App\Models\VehicleSpecification;
use Illuminate\Database\Seeder;

class ListingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all dealers
        $dealers = User::role('dealer')->get();

        if ($dealers->isEmpty()) {
            $this->command->warn('No dealers found. Please run DealerSeeder first.');
            return;
        }

        // Get all features for random attachment
        $allFeatures = VehicleFeature::all();

        // Create 3-5 listings for each dealer
        $dealers->each(function ($dealer) use ($allFeatures) {
            for ($i = 0; $i < rand(3, 5); $i++) {
                // Create the listing
                $listing = Listing::factory()->create([
                    'owner_id' => $dealer->id,
                ]);

                // Create vehicle specification for the listing
                VehicleSpecification::factory()->create([
                    'listing_id' => $listing->id,
                ]);

                // Attach random features (5-15 features)
                $randomFeatures = $allFeatures->random(rand(5, 15));
                $listing->features()->attach($randomFeatures->pluck('id'));
            }
        });
    }
}
