<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        Page::truncate();
        Schema::enableForeignKeyConstraints();

        $now = now();

        $pages = [
            [
                'uuid' => getUuid(),
                'name' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'description' => null,
                'is_deletable' => false,
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'name' => 'Terms & Conditions',
                'slug' => 'term-conditions',
                'description' => null,
                'is_deletable' => false,
                'created_at' => $now,
                'updated_at' => null,
            ]
        ];

        Page::insert($pages);
    }
}
