<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;

class PermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        Permission::truncate();
        Schema::enableForeignKeyConstraints();

        $now = now();

        $permissions = [];

        $permissions = array_merge($permissions, [
            // Dashboard permissions
            ['name' => 'dashboard.view', 'group' => 'dashboard', 'guard_name' => 'web', 'created_at' => $now],

            // Setting permissions
            ['name' => 'setting.view', 'group' => 'setting', 'guard_name' => 'web', 'created_at' => $now],

            // Role permissions
            ['name' => 'role.add', 'group' => 'role', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'role.view', 'group' => 'role', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'role.update', 'group' => 'role', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'role.delete', 'group' => 'role', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'role.restore', 'group' => 'role', 'guard_name' => 'web', 'created_at' => $now],

            // Customer permissions
            ['name' => 'user.add', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.view', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.update', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.delete', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.restore', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.invite', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.verify_email', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.approve', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'user.resend_invitation', 'group' => 'user', 'guard_name' => 'web', 'created_at' => $now],

            // Dealers permissions
            ['name' => 'dealers.add', 'group' => 'dealer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.view', 'group' => 'dealer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.update', 'group' => 'dealer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.delete', 'group' => 'dealer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.restore', 'group' => 'dealer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.verify_email', 'group' => 'dealer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.approve', 'group' => 'dealer', 'guard_name' => 'web', 'created_at' => $now],

            // Term permissions
            ['name' => 'term.view', 'group' => 'terms', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'term.update', 'group' => 'terms', 'guard_name' => 'web', 'created_at' => $now],

            // System setting permissions
            ['name' => 'mail_setting.view', 'group' => 'mail_setting', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'mail_setting.update', 'group' => 'mail_setting', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'overdue_threshold_setting.view', 'group' => 'overdue_threshold_setting', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'overdue_threshold_setting.update', 'group' => 'overdue_threshold_setting', 'guard_name' => 'web', 'created_at' => $now],

            // Activity log permissions
            ['name' => 'activity_log.view', 'group' => 'activity_log', 'guard_name' => 'web', 'created_at' => $now],

            // Page permissions
            ['name' => 'page.add', 'group' => 'page', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'page.view', 'group' => 'page', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'page.update', 'group' => 'page', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'page.delete', 'group' => 'page', 'guard_name' => 'web', 'created_at' => $now],

            // Tax permissions
            ['name' => 'tax.add', 'group' => 'tax', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'tax.view', 'group' => 'tax', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'tax.update', 'group' => 'tax', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'tax.delete', 'group' => 'tax', 'guard_name' => 'web', 'created_at' => $now],

            // DexUsers permissions
            ['name' => 'dex-user.add', 'group' => 'dex-user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dex-user.view', 'group' => 'dex-user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dex-user.update', 'group' => 'dex-user', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dex-user.delete', 'group' => 'dex-user', 'guard_name' => 'web', 'created_at' => $now],

            // Dx Customer permissions
            ['name' => 'dx-customer.add', 'group' => 'dx-customer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dx-customer.view', 'group' => 'dx-customer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dx-customer.update', 'group' => 'dx-customer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dx-customer.delete', 'group' => 'dx-customer', 'guard_name' => 'web', 'created_at' => $now],

            // Admin.Buyer permissions
            ['name' => 'admin.buyer.add', 'group' => 'admin.buyer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'admin.buyer.view', 'group' => 'admin.buyer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'admin.buyer.update', 'group' => 'admin.buyer', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'admin.buyer.delete', 'group' => 'admin.buyer', 'guard_name' => 'web', 'created_at' => $now],

            // Documentation permissions
            ['name' => 'documentation.add', 'group' => 'documentation', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'documentation.view', 'group' => 'documentation', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'documentation.update', 'group' => 'documentation', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'documentation.delete', 'group' => 'documentation', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'documentation.restore', 'group' => 'documentation', 'guard_name' => 'web', 'created_at' => $now],

            // Listing permissions
            ['name' => 'listing.add', 'group' => 'listing', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'listing.view', 'group' => 'listing', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'listing.update', 'group' => 'listing', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'listing.delete', 'group' => 'listing', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'listing.approve', 'group' => 'listing', 'guard_name' => 'web', 'created_at' => $now],

            //Dealers
            // Dashboard permissions
            ['name' => 'dealers.dashboard.view', 'group' => 'dashboard', 'guard_name' => 'web', 'created_at' => $now],

            // Operation permissions
            ['name' => 'dealers.operation.add', 'group' => 'operation', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.operation.view', 'group' => 'operation', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.operation.update', 'group' => 'operation', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.operation.delete', 'group' => 'operation', 'guard_name' => 'web', 'created_at' => $now],

            // Branch permissins
            ['name' => 'dealers.branch.add', 'group' => 'branch', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.branch.view', 'group' => 'branch', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.branch.update', 'group' => 'branch', 'guard_name' => 'web', 'created_at' => $now],
            ['name' => 'dealers.branch.delete', 'group' => 'branch', 'guard_name' => 'web', 'created_at' => $now],

            // Buyers
            //Dashboard permission
            ['name' => 'buyers.dashboard.view', 'group' => 'dashboard', 'guard_name' => 'web', 'created_at' => $now],
        ]);

        Permission::insert($permissions);
    }
}
