<?php

namespace Database\Seeders;

use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        Role::truncate();
        Schema::enableForeignKeyConstraints();

        Role::create(['name' => Role::SUPER_ADMIN, 'guard_name' => 'web', 'is_deletable' => false])
            ->givePermissionTo(Permission::all());

        Role::create(['name' => Role::ADMIN, 'guard_name' => 'web', 'is_deletable' => true]);

        Role::create(['name' => Role::DEALER, 'guard_name' => 'web', 'is_deletable' => false])
            ->givePermissionTo(
                Permission::query()
                    ->where('name', 'like', 'dealers.%')
                    ->whereRaw("LENGTH(name) - LENGTH(REPLACE(name, '.', '')) >= 2")
                    ->get()
            );

        Role::create(['name' => Role::BUYER, 'guard_name' => 'web', 'is_deletable' => false])
            ->givePermissionTo(
                Permission::query()
                    ->where('name', 'like', 'buyers.%')
                    ->whereRaw("LENGTH(name) - LENGTH(REPLACE(name, '.', '')) >= 2")
                    ->get()
            );

        Role::create(['name' => Role::USER, 'guard_name' => 'web', 'is_deletable' => false])
            ->givePermissionTo(
                Permission::query()
                    ->where('name', 'like', 'buyers.%')
                    ->whereRaw("LENGTH(name) - LENGTH(REPLACE(name, '.', '')) >= 2")
                    ->get()
            );
    }
}
