<?php

namespace Database\Seeders;

use App\Models\State;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class StateSeeder extends Seeder
{


    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        State::truncate();
        Schema::enableForeignKeyConstraints();

        $statusInactive = State::STATUS_INACTIVE;
        $statusActive = State::STATUS_ACTIVE;
        $now = now();

        $states  = [

            // andorra
            array('uuid' => getUuid(), 'country_id' => 1, 'name' => 'Andorra la Vella', 'iso' => 'alv', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 1, 'name' => 'Escaldes-Engordany', 'iso' => 'ese', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 1, 'name' => 'Encamp', 'iso' => 'enc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 1, 'name' => 'Sant Julià de Lòria', 'iso' => 'sjl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 1, 'name' => 'La Massana', 'iso' => 'lma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 1, 'name' => 'Ordino', 'iso' => 'ord', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 1, 'name' => 'Canillo', 'iso' => 'can', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //united arab emirates
            array('uuid' => getUuid(), 'country_id' => 2, 'name' => 'Abu Dhabi', 'iso' => 'auh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 2, 'name' => 'Dubai', 'iso' => 'dxb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 2, 'name' => 'Sharjah', 'iso' => 'shj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 2, 'name' => 'Ajman', 'iso' => 'ajm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 2, 'name' => 'Umm Al-Quwain', 'iso' => 'uaq', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 2, 'name' => 'Fujairah', 'iso' => 'fuj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 2, 'name' => 'Ras Al Khaimah', 'iso' => 'rak', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //afganistan
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Badakhshan', 'iso' => 'bdk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Badghis', 'iso' => 'bdg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Baghlan', 'iso' => 'bgl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Balkh', 'iso' => 'blh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Bamyan', 'iso' => 'bam', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Daykundi', 'iso' => 'day', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Farah', 'iso' => 'far', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Faryab', 'iso' => 'fry', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Ghazni', 'iso' => 'ghz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Ghor', 'iso' => 'ghr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Helmand', 'iso' => 'hel', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Herat', 'iso' => 'her', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Jowzjan', 'iso' => 'jow', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Kabul', 'iso' => 'kab', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Kandahar', 'iso' => 'kan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Kapisa', 'iso' => 'kap', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Khost', 'iso' => 'kho', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Kunar', 'iso' => 'kun', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Kunduz', 'iso' => 'kdz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Laghman', 'iso' => 'lag', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Logar', 'iso' => 'log', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Nangarhar', 'iso' => 'nan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Nimroz', 'iso' => 'nim', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Nuristan', 'iso' => 'nur', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Paktia', 'iso' => 'pta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Paktika', 'iso' => 'ptk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Panjshir', 'iso' => 'pan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Parwan', 'iso' => 'par', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Samangan', 'iso' => 'sam', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Sar-e Pol', 'iso' => 'sar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Takhar', 'iso' => 'tak', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Urozgan', 'iso' => 'uro', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 3, 'name' => 'Zabul', 'iso' => 'zab', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // antigua and barbuda
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Barbuda', 'iso' => 'brb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Redonda', 'iso' => 'rda', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Saint George', 'iso' => 'sgg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Saint John', 'iso' => 'sjn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Saint Mary', 'iso' => 'smy', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Saint Paul', 'iso' => 'spl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Saint Peter', 'iso' => 'spn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 4, 'name' => 'Saint Philip', 'iso' => 'sph', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //anguilla
            array('uuid' => getUuid(), 'country_id' => 5, 'name' => 'Anguilla', 'iso' => 'axa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //albania
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Berat', 'iso' => 'ber', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Bulqizë', 'iso' => 'bul', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Dibër', 'iso' => 'dib', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Durres', 'iso' => 'dur', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Elbasan', 'iso' => 'elb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Fier', 'iso' => 'fie', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Gjirokastër', 'iso' => 'gji', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Shkodër', 'iso' => 'shk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Korçë', 'iso' => 'kor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Kukës', 'iso' => 'kuk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Tirana', 'iso' => 'tir', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 6, 'name' => 'Vlorë', 'iso' => 'vlo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // armenia
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Ararat', 'iso' => 'ara', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Armavir', 'iso' => 'arm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Gegharkunik', 'iso' => 'geh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Kotayk', 'iso' => 'kot', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Lori', 'iso' => 'lor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Shirak', 'iso' => 'shi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Syunik', 'iso' => 'syn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Tavush', 'iso' => 'tav', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Vayots Dzor', 'iso' => 'vay', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 7, 'name' => 'Yerevan', 'iso' => 'yer', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //netherlands antilles
            array('uuid' => getUuid(), 'country_id' => 8, 'name' => 'Aruba', 'iso' => 'abw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 8, 'name' => 'Curacao', 'iso' => 'cur', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 8, 'name' => 'Bonaire', 'iso' => 'bon', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 8, 'name' => 'Sint Eustatius', 'iso' => 'sey', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 8, 'name' => 'Saba', 'iso' => 'sab', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 8, 'name' => 'Sint Maarten', 'iso' => 'sxm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //angola
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Bengo', 'iso' => 'ben', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Benguela', 'iso' => 'bgu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Bié', 'iso' => 'bie', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Cabinda', 'iso' => 'cab', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Cuando Cubango', 'iso' => 'cun', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Cuanza Norte', 'iso' => 'cun', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Cuanza Sul', 'iso' => 'cus', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Huambo', 'iso' => 'hua', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Huíla', 'iso' => 'hui', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Kwanza Norte', 'iso' => 'kn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Kwanza Sul', 'iso' => 'ks', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Luanda', 'iso' => 'lu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Lunda Norte', 'iso' => 'ldn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Lunda Sul', 'iso' => 'lds', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Malanje', 'iso' => 'mal', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Moxico', 'iso' => 'mox', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Namibe', 'iso' => 'nam', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 9, 'name' => 'Uíge', 'iso' => 'uig', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //Antarctica
            array('uuid' => getUuid(), 'country_id' => 10, 'name' => 'Antarctica', 'iso' => 'ata', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //argentina
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Buenos Aires', 'iso' => 'bue', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Catamarca', 'iso' => 'cat', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Chaco', 'iso' => 'cha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Chubut', 'iso' => 'chu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Córdoba', 'iso' => 'cor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Corrientes', 'iso' => 'cor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Entre Ríos', 'iso' => 'er', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Formosa', 'iso' => 'for', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Jujuy', 'iso' => 'juy', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'La Pampa', 'iso' => 'lap', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'La Rioja', 'iso' => 'lir', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Mendoza', 'iso' => 'men', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Misiones', 'iso' => 'mis', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Neuquén', 'iso' => 'neu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Río Negro', 'iso' => 'rin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Salta', 'iso' => 'sal', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'San Juan', 'iso' => 'sj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'San Luis', 'iso' => 'slu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Santa Cruz', 'iso' => 'sc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Santa Fe', 'iso' => 'sf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Santiago del Estero', 'iso' => 'sde', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Tierra del Fuego', 'iso' => 'tdf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 11, 'name' => 'Tucumán', 'iso' => 'tuc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // american samoa
            array('uuid' => getUuid(), 'country_id' => 12, 'name' => 'Eastern District', 'iso' => 'ed', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 12, 'name' => 'Manu\'a District', 'iso' => 'md', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 12, 'name' => 'Rose Atoll', 'iso' => 'ra', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 12, 'name' => 'Western District', 'iso' => 'wd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 12, 'name' => 'Swains Island', 'iso' => 'si', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //austria
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Burgenland', 'iso' => 'bgl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Carinthia', 'iso' => 'car', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Lower Austria', 'iso' => 'low', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Upper Austria', 'iso' => 'upa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Salzburg', 'iso' => 'slz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Styria', 'iso' => 'sty', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Tyrol', 'iso' => 'tyr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Vienna', 'iso' => 'vnn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 13, 'name' => 'Vorarlberg', 'iso' => 'vor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //australia
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'New South Wales', 'iso' => 'nsw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'Queensland', 'iso' => 'qld', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'South Australia', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'Tasmania', 'iso' => 'tas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'Victoria', 'iso' => 'vic', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'Western Australia', 'iso' => 'wa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'Australian Capital Territory', 'iso' => 'act', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 14, 'name' => 'Northern Territory', 'iso' => 'nt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // aruba
            array('uuid' => getUuid(), 'country_id' => 15, 'name' => 'Aruba', 'iso' => 'aw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //azerbaijan
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Abseron', 'iso' => 'abs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Ganja-Gazakh', 'iso' => 'ggz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Guba-Khachmaz', 'iso' => 'gbk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Lankaran', 'iso' => 'lnk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Mingachevir', 'iso' => 'mng', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Sheki-Zagatala', 'iso' => 'szg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Shirvan-Salyan', 'iso' => 'ssy', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Central Aran', 'iso' => 'car', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 16, 'name' => 'Nakhchivan Autonomous Republic', 'iso' => 'nkr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bosnia and herzegovina
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Federation of Bosnia and Herzegovina', 'iso' => 'fbh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Republika Srpska', 'iso' => 'rs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Una-Sana Canton', 'iso' => 'usc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Posavina Canton', 'iso' => 'pc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Tuzla Canton', 'iso' => 'tc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Zenica-Doboj Canton', 'iso' => 'zdc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Bosna-Podrinje Canton', 'iso' => 'bpc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Central Bosnia Canton', 'iso' => 'cbc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Herzegovina-Neretva Canton', 'iso' => 'hnc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Sarajevo Canton', 'iso' => 'sc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'West Herzegovina Canton', 'iso' => 'whc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 17, 'name' => 'Republic of Srpska', 'iso' => 'rs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //barbados
            array('uuid' => getUuid(), 'country_id' => 18, 'name' => 'Barbados', 'iso' => 'bb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bangladesh
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Dhaka', 'iso' => 'dhk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Chittagong', 'iso' => 'ctg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Rajshahi', 'iso' => 'raj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Khulna', 'iso' => 'khu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Barisal', 'iso' => 'bar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Sylhet', 'iso' => 'syl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Rangpur', 'iso' => 'rang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 19, 'name' => 'Mymensingh', 'iso' => 'mym', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // belgium
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Flanders', 'iso' => 'fl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Wallonia', 'iso' => 'wa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Brussels-Capital', 'iso' => 'bc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Antwerp', 'iso' => 'an', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'East Flanders', 'iso' => 'ovl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Flemish Brabant', 'iso' => 'vbr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'West Flanders', 'iso' => 'wfl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Hainaut', 'iso' => 'ha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Liège', 'iso' => 'li', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Luxembourg', 'iso' => 'lux', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 20, 'name' => 'Namur', 'iso' => 'nam', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // burkina faso
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Boucle du Mouhoun', 'iso' => 'bm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Cascades', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Centre', 'iso' => 'ce', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Centre-Est', 'iso' => 'ceh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Centre-Nord', 'iso' => 'cen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Centre-Ouest', 'iso' => 'cos', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Centre-Sud', 'iso' => 'ces', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Est', 'iso' => 'es', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Hauts-Bassins', 'iso' => 'hb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Nord', 'iso' => 'no', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Plateau-Central', 'iso' => 'pc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Sahel', 'iso' => 'sh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 21, 'name' => 'Sud-Ouest', 'iso' => 'swo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bulgaria
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Blagoevgrad', 'iso' => 'bl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Burgas', 'iso' => 'bu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Dobrich', 'iso' => 'do', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Gabrovo', 'iso' => 'ga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Haskovo', 'iso' => 'ha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Kardzhali', 'iso' => 'ka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Kyustendil', 'iso' => 'ky', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Lovech', 'iso' => 'lo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Montana', 'iso' => 'mo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Pazardzhik', 'iso' => 'pa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Pernik', 'iso' => 'pe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Pleven', 'iso' => 'pl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Plovdiv', 'iso' => 'pld', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Ruse', 'iso' => 'ru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Shumen', 'iso' => 'sh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Silistra', 'iso' => 'si', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Sliven', 'iso' => 'slv', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Sofia', 'iso' => 'sof', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Sofia City', 'iso' => 'sofcity', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Stara Zagora', 'iso' => 'stz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Targovishte', 'iso' => 'tg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Varna', 'iso' => 'va', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Veliko Tarnovo', 'iso' => 'vt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Vidin', 'iso' => 'vi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 22, 'name' => 'Yambol', 'iso' => 'ya', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bahrain
            array('uuid' => getUuid(), 'country_id' => 23, 'name' => 'Capital Governorate', 'iso' => 'cap', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 23, 'name' => 'Muharraq Governorate', 'iso' => 'muh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 23, 'name' => 'Northern Governorate', 'iso' => 'nor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 23, 'name' => 'Southern Governorate', 'iso' => 'sou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 23, 'name' => 'Isa Town', 'iso' => 'isa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // burundi
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Bujumbura Mairie', 'iso' => 'bm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Bubanza', 'iso' => 'bu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Bururi', 'iso' => 'bu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Cankuzo', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Cibitoke', 'iso' => 'ci', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Gitega', 'iso' => 'gi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Karuzi', 'iso' => 'ka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Kayanza', 'iso' => 'ka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Kirundo', 'iso' => 'ki', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Makamba', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Muramvya', 'iso' => 'mu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Mwaro', 'iso' => 'mw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Ngozi', 'iso' => 'ng', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Ruyigi', 'iso' => 'ru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Rumonge', 'iso' => 'ru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Bujumbura Rural', 'iso' => 'bu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Bubanza', 'iso' => 'bu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 24, 'name' => 'Rutana', 'iso' => 'ru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // benin
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Alibori', 'iso' => 'al', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Atakora', 'iso' => 'at', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Atlantique', 'iso' => 'at', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Borgou', 'iso' => 'bo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Collines', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Donga', 'iso' => 'do', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Kouffo', 'iso' => 'ko', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Littoral', 'iso' => 'li', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Mono', 'iso' => 'mo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Ouémé', 'iso' => 'ou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Plateau', 'iso' => 'pl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 25, 'name' => 'Zou', 'iso' => 'zo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // saint barthelemy
            array('uuid' => getUuid(), 'country_id' => 26, 'name' => 'Saint Barthélemy', 'iso' => 'sb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bermuda
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Saint George', 'iso' => 'sg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Hamilton', 'iso' => 'ha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Smith\'s', 'iso' => 'sm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Pembroke', 'iso' => 'pe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Devonshire', 'iso' => 'de', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Paget', 'iso' => 'pa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Warwick', 'iso' => 'wa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Sandys', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 27, 'name' => 'Hamilton City', 'iso' => 'hc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // brunei darussalam
            array('uuid' => getUuid(), 'country_id' => 28, 'name' => 'Brunei-Muara', 'iso' => 'bm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 28, 'name' => 'Belait', 'iso' => 'be', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 28, 'name' => 'Tutong', 'iso' => 'tu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 28, 'name' => 'Temburong', 'iso' => 'te', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bolivia
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Chuquisaca', 'iso' => 'ch', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'La Paz', 'iso' => 'lp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Cochabamba', 'iso' => 'cb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Oruro', 'iso' => 'or', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Potosí', 'iso' => 'po', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Tarija', 'iso' => 'ta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Santa Cruz', 'iso' => 'sc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Beni', 'iso' => 'be', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 29, 'name' => 'Pando', 'iso' => 'pa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // brazil
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Acre', 'iso' => 'ac', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Alagoas', 'iso' => 'al', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Amapá', 'iso' => 'ap', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Amazonas', 'iso' => 'am', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Bahia', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Ceará', 'iso' => 'ce', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Distrito Federal', 'iso' => 'df', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Espírito Santo', 'iso' => 'es', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Goiás', 'iso' => 'go', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Maranhão', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Mato Grosso', 'iso' => 'mt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Mato Grosso do Sul', 'iso' => 'ms', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Minas Gerais', 'iso' => 'mg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Pará', 'iso' => 'pa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Paraíba', 'iso' => 'pb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Paraná', 'iso' => 'pr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Pernambuco', 'iso' => 'pe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Piauí', 'iso' => 'pi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Rio de Janeiro', 'iso' => 'rj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Rio Grande do Norte', 'iso' => 'rn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Rio Grande do Sul', 'iso' => 'rs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Rondônia', 'iso' => 'ro', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Roraima', 'iso' => 'rr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Santa Catarina', 'iso' => 'sc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'São Paulo', 'iso' => 'sp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Sergipe', 'iso' => 'se', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 30, 'name' => 'Tocantins', 'iso' => 'to', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bahamas
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Acklins and Crooked Islands', 'iso' => 'acklins-crooked', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'The Exumas', 'iso' => 'exumas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Grand Bahama', 'iso' => 'grand-bahama', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Harbour Island', 'iso' => 'harbour-island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Andros', 'iso' => 'andros', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Bimini', 'iso' => 'bimini', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Cat Island', 'iso' => 'cat-island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Inagua', 'iso' => 'inagua', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Long Island', 'iso' => 'long-island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Mayaguana', 'iso' => 'mayaguana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'New Providence', 'iso' => 'new-providence', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Ragged Island', 'iso' => 'ragged-island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'San Salvador and Rum Cay', 'iso' => 'san-salvador-rum-cay', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 31, 'name' => 'Turks and Caicos Islands', 'iso' => 'turks-caicos', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // bhutan
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Bumthang', 'iso' => 'bumthang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Chukha', 'iso' => 'chukha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Dagana', 'iso' => 'dagana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Gasa', 'iso' => 'gasa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Haa', 'iso' => 'haa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Lhuentse', 'iso' => 'lhuentse', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Mongar', 'iso' => 'mongar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Paro', 'iso' => 'paro', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Punakha', 'iso' => 'punakha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Samdrup Jongkhar', 'iso' => 'samdrup-jongkhar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Samtse', 'iso' => 'samtse', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Sarpang', 'iso' => 'sarpang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Thimphu', 'iso' => 'thimphu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Trashigang', 'iso' => 'trashigang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Trashiyangtse', 'iso' => 'trashiyangtse', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Wangdue Phodrang', 'iso' => 'wangdue-phodrang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 32, 'name' => 'Zhemgang', 'iso' => 'zhemgang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // botswana
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'Central', 'iso' => 'central', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'Ghanzi', 'iso' => 'ghanzi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'Kgalagadi', 'iso' => 'kgalagadi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'Kgatleng', 'iso' => 'kgatleng', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'Kweneng', 'iso' => 'kweneng', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'Ngamiland', 'iso' => 'ngamiland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'North East', 'iso' => 'north-east', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'South East', 'iso' => 'south-east', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 33, 'name' => 'Southern', 'iso' => 'southern', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // belarus
            array('uuid' => getUuid(), 'country_id' => 34, 'name' => 'Brest', 'iso' => 'brest', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 34, 'name' => 'Gomel', 'iso' => 'gomel', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 34, 'name' => 'Grodno', 'iso' => 'grodno', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 34, 'name' => 'Minsk', 'iso' => 'minsk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 34, 'name' => 'Mogilev', 'iso' => 'mogilev', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 34, 'name' => 'Vitebsk', 'iso' => 'vitebsk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 34, 'name' => 'Minsk City', 'iso' => 'minsk-city', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // belize
            array('uuid' => getUuid(), 'country_id' => 35, 'name' => 'Belize', 'iso' => 'belize', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 35, 'name' => 'Cayo', 'iso' => 'cayo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 35, 'name' => 'Corozal', 'iso' => 'corozal', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 35, 'name' => 'Orange Walk', 'iso' => 'orange-walk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 35, 'name' => 'Stann Creek', 'iso' => 'stann-creek', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 35, 'name' => 'Toledo', 'iso' => 'toledo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // canada
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Alberta', 'iso' => 'alberta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'British Columbia', 'iso' => 'british-columbia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Manitoba', 'iso' => 'manitoba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'New Brunswick', 'iso' => 'new-brunswick', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Newfoundland and Labrador', 'iso' => 'newfoundland-and-labrador', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Northwest Territories', 'iso' => 'northwest-territories', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Nova Scotia', 'iso' => 'nova-scotia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Ontario', 'iso' => 'ontario', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Prince Edward Island', 'iso' => 'prince-edward-island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Quebec', 'iso' => 'quebec', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Saskatchewan', 'iso' => 'saskatchewan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Yukon', 'iso' => 'yukon', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 36, 'name' => 'Nunavut', 'iso' => 'nunavut', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cocos (keeling) islands
            array('uuid' => getUuid(), 'country_id' => 37, 'name' => 'West Island', 'iso' => 'west-island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 37, 'name' => 'Home Island', 'iso' => 'home-island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // congo, the democratic republic of the
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Bas-Uele', 'iso' => 'bas-uele', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Haut-Uele', 'iso' => 'haut-uele', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Ituri', 'iso' => 'ituri', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Nord-Kivu', 'iso' => 'nord-kivu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Sud-Kivu', 'iso' => 'sud-kivu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Maniema', 'iso' => 'maniema', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Tanganyika', 'iso' => 'tanganyika', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Haut-Lomami', 'iso' => 'haut-lomami', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Lualaba', 'iso' => 'lualaba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Kasai', 'iso' => 'kasai', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Kasai-Central', 'iso' => 'kasai-central', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Kasai-Oriental', 'iso' => 'kasai-oriental', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Kinshasa', 'iso' => 'kinshasa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Kwanza', 'iso' => 'kwanza', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Kwilu', 'iso' => 'kwilu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Mai-Ndombe', 'iso' => 'mai-ndombe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Mongala', 'iso' => 'mongala', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Nord-Ubangi', 'iso' => 'nord-ubangi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'South-Ubangi', 'iso' => 'south-ubangi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Sankuru', 'iso' => 'sankuru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Tshuapa', 'iso' => 'tshuapa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Bandundu', 'iso' => 'bandundu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Equateur', 'iso' => 'equateur', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 38, 'name' => 'Orientale', 'iso' => 'orientale', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // central africa republic
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Bamingui-Bangoran', 'iso' => 'bamingui-bangoran', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Bangui', 'iso' => 'bangui', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Basse-Kotto', 'iso' => 'basse-kotto', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Haute-Kotto', 'iso' => 'haute-kotto', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Haut-Mbomou', 'iso' => 'haut-mbomou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Kemo', 'iso' => 'kemo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Lobaye', 'iso' => 'lobaye', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Mambere-Kadei', 'iso' => 'mambere-kadei', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Mbomou', 'iso' => 'mbomou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Nana-Mambere', 'iso' => 'nana-mambere', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Nana-Gribizi', 'iso' => 'nana-gribizi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Ombella-Mpoko', 'iso' => 'ombella-mpoko', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Sangha-Mbaere', 'iso' => 'sangha-mbaere', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Vakaga', 'iso' => 'vakaga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Ouaka', 'iso' => 'ouaka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 39, 'name' => 'Bokoro', 'iso' => 'bokoro', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // congo
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Bouenza', 'iso' => 'bouenza', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Brazzaville', 'iso' => 'brazzaville', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Cuvette', 'iso' => 'cuvette', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Cuvette-Ouest', 'iso' => 'cuvette-ouest', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Kouilou', 'iso' => 'kouilou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Lekoumou', 'iso' => 'lekoumou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Likouala', 'iso' => 'likouala', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Mayombe', 'iso' => 'mayombe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Niari', 'iso' => 'niari', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Plateaux', 'iso' => 'plateaux', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Pool', 'iso' => 'pool', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 40, 'name' => 'Sangha', 'iso' => 'sangha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // switzerland
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Aargau', 'iso' => 'aargau', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Appenzell Ausserrhoden', 'iso' => 'appenzell-ausserrhoden', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Appenzell Innerrhoden', 'iso' => 'appenzell-innerrhoden', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Basel-Landschaft', 'iso' => 'basel-landschaft', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Basel-Stadt', 'iso' => 'basel-stadt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Bern', 'iso' => 'bern', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Fribourg', 'iso' => 'fribourg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Geneva', 'iso' => 'geneva', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Glarus', 'iso' => 'glarus', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Graubünden', 'iso' => 'graubunden', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Jura', 'iso' => 'jura', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Lucerne', 'iso' => 'lucerne', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Neuchâtel', 'iso' => 'neuchatel', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Nidwalden', 'iso' => 'nidwalden', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Obwalden', 'iso' => 'obwalden', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Schaffhausen', 'iso' => 'schaffhausen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Solothurn', 'iso' => 'solothurn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'St. Gallen', 'iso' => 'st-gallen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Ticino', 'iso' => 'ticino', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Thurgau', 'iso' => 'thurgau', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Uri', 'iso' => 'uri', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Valais', 'iso' => 'valais', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Vaud', 'iso' => 'vaud', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Zug', 'iso' => 'zug', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 41, 'name' => 'Zurich', 'iso' => 'zurich', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cote d ivoire
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Abidjan', 'iso' => 'abidjan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Agnéby-Tiassa', 'iso' => 'agneby-tiassa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Bafing', 'iso' => 'bafing', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Bas-Sassandra', 'iso' => 'bas-sassandra', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Denguélé', 'iso' => 'denguele', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Gôh', 'iso' => 'goh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Lacs', 'iso' => 'lacs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Lagunes', 'iso' => 'lagunes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Marahoué', 'iso' => 'marahoue', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Moyen-Cavally', 'iso' => 'moyen-cavally', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Savanes', 'iso' => 'savanes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Vallee du Bandama', 'iso' => 'vallee-du-bandama', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Woroba', 'iso' => 'woroba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 42, 'name' => 'Zanzan', 'iso' => 'zanzan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cook islands
            array('uuid' => getUuid(), 'country_id' => 43, 'name' => 'Cook Islands', 'iso' => 'ck', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // chile
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Arica y Parinacota', 'iso' => 'arica-y-parinacota', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Tarapacá', 'iso' => 'tarapaca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Antofagasta', 'iso' => 'antofagasta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Atacama', 'iso' => 'atacama', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Coquimbo', 'iso' => 'coquimbo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Valparaíso', 'iso' => 'valparaiso', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'O’Higgins', 'iso' => 'ohiggins', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Maule', 'iso' => 'maule', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Ñuble', 'iso' => 'nuble', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Biobío', 'iso' => 'biobio', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'La Araucanía', 'iso' => 'araucania', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Los Ríos', 'iso' => 'los-rios', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Los Lagos', 'iso' => 'los-lagos', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Aysén del General Carlos Ibáñez del Campo', 'iso' => 'aysen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 44, 'name' => 'Magallanes y de la Antártica Chilena', 'iso' => 'magallanes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cameroon
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'Adamawa', 'iso' => 'adamawa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'Centre', 'iso' => 'centre', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'East', 'iso' => 'east', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'Littoral', 'iso' => 'littoral', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'North', 'iso' => 'north', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'Northwest', 'iso' => 'northwest', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'West', 'iso' => 'west', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'South', 'iso' => 'south', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'Southwest', 'iso' => 'southwest', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 45, 'name' => 'Far North', 'iso' => 'far-north', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // china
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Anhui', 'iso' => 'anhui', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Beijing', 'iso' => 'beijing', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Chongqing', 'iso' => 'chongqing', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Fujian', 'iso' => 'fujian', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Gansu', 'iso' => 'gansu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Guangdong', 'iso' => 'guangdong', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Guangxi', 'iso' => 'guangxi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Guizhou', 'iso' => 'guizhou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Hainan', 'iso' => 'hainan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Hebei', 'iso' => 'hebei', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Heilongjiang', 'iso' => 'heilongjiang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Henan', 'iso' => 'henan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Hubei', 'iso' => 'hubei', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Hunan', 'iso' => 'hunan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Jiangsu', 'iso' => 'jiangsu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Jiangxi', 'iso' => 'jiangxi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Jilin', 'iso' => 'jilin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Liaoning', 'iso' => 'liaoning', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Macau', 'iso' => 'macau', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Ningxia', 'iso' => 'ningxia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Qinghai', 'iso' => 'qinghai', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Shaanxi', 'iso' => 'shaaxi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Shandong', 'iso' => 'shandong', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Shanghai', 'iso' => 'shanghai', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Shanxi', 'iso' => 'shanxi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Sichuan', 'iso' => 'sichuan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Tianjin', 'iso' => 'tianjin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Tibet', 'iso' => 'tibet', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Xinjiang', 'iso' => 'xinjiang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Yunnan', 'iso' => 'yunnan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 46, 'name' => 'Zhejiang', 'iso' => 'zhejiang', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // colombia
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Amazonas', 'iso' => 'amazonas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Antioquia', 'iso' => 'antioquia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Arauca', 'iso' => 'arauca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Atlántico', 'iso' => 'atlantico', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Bolívar', 'iso' => 'bolivar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Boyacá', 'iso' => 'boyaca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Caldas', 'iso' => 'caldas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Caquetá', 'iso' => 'caqueta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Casanare', 'iso' => 'casanare', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Cauca', 'iso' => 'cauca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Cesar', 'iso' => 'cesar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Chocó', 'iso' => 'choco', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Córdoba', 'iso' => 'cordoba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Cundinamarca', 'iso' => 'cundinamarca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Guainía', 'iso' => 'guainia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Guaviare', 'iso' => 'guaviare', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Huila', 'iso' => 'huila', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'La Guajira', 'iso' => 'laguajira', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Magdalena', 'iso' => 'magdalena', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Meta', 'iso' => 'meta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Nariño', 'iso' => 'narino', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Norte de Santander', 'iso' => 'norte_santander', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Putumayo', 'iso' => 'putumayo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Quindío', 'iso' => 'quindio', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Risaralda', 'iso' => 'risaralda', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'San Andrés y Providencia', 'iso' => 'sanandres', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Santander', 'iso' => 'santander', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Sucre', 'iso' => 'sucre', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Tolima', 'iso' => 'tolima', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Valle del Cauca', 'iso' => 'valle', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Vaupés', 'iso' => 'vaupes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 47, 'name' => 'Vichada', 'iso' => 'vichada', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // costa rica
            array('uuid' => getUuid(), 'country_id' => 48, 'name' => 'Alajuela', 'iso' => 'alajuela', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 48, 'name' => 'Cartago', 'iso' => 'cartago', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 48, 'name' => 'Guanacaste', 'iso' => 'guanacaste', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 48, 'name' => 'Heredia', 'iso' => 'heredia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 48, 'name' => 'Limón', 'iso' => 'limon', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 48, 'name' => 'Puntarenas', 'iso' => 'puntarenas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 48, 'name' => 'San José', 'iso' => 'san_jose', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cuba
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Pinar del Río', 'iso' => 'pinar_del_rio', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'La Habana', 'iso' => 'la_habana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Matanzas', 'iso' => 'matanzas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Cienfuegos', 'iso' => 'cienfuegos', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Villa Clara', 'iso' => 'villa_clara', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Sancti Spíritus', 'iso' => 'sancti_spiritus', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Ciego de Ávila', 'iso' => 'ciego_de_avila', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Camagüey', 'iso' => 'camaguey', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Las Tunas', 'iso' => 'las_tunas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Holguín', 'iso' => 'holguin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Granma', 'iso' => 'granma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Santiago de Cuba', 'iso' => 'santiago_de_cuba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Guantánamo', 'iso' => 'guantanamo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Isla de la Juventud', 'iso' => 'isla_de_la_juventud', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 49, 'name' => 'Ciego de Ávila', 'iso' => 'ciego_de_avila', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cape verde
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'Santiago', 'iso' => 'santiago', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'São Vicente', 'iso' => 'sao_vicente', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'Santa Catarina', 'iso' => 'santa_catarina', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'Fogo', 'iso' => 'fogo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'Brava', 'iso' => 'brava', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'Sal', 'iso' => 'sal', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'Boa Vista', 'iso' => 'boa_vista', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 50, 'name' => 'Maio', 'iso' => 'maio', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // christmas island
            array('uuid' => getUuid(), 'country_id' => 51, 'name' => 'Christmas Island', 'iso' => 'christmas_island', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cyprus
            array('uuid' => getUuid(), 'country_id' => 52, 'name' => 'Nicosia', 'iso' => 'nicosia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 52, 'name' => 'Limassol', 'iso' => 'limassol', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 52, 'name' => 'Larnaca', 'iso' => 'larnaca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 52, 'name' => 'Famagusta', 'iso' => 'famagusta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 52, 'name' => 'Paphos', 'iso' => 'paphos', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 52, 'name' => 'Kyrenia', 'iso' => 'kyrenia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // czech republic
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Prague', 'iso' => 'prague', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'South Bohemian', 'iso' => 'south_bohemian', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'South Moravian', 'iso' => 'south_moravian', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Plzen', 'iso' => 'plzen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Karlovy Vary', 'iso' => 'karlovy_vary', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Ústí nad Labem', 'iso' => 'usti_nad_labem', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Liberec', 'iso' => 'liberec', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Hradec Králové', 'iso' => 'hradec_kralove', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Pardubice', 'iso' => 'pardubice', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Vysočina', 'iso' => 'vysocina', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Olomouc', 'iso' => 'olomouc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Zlín', 'iso' => 'zlin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 53, 'name' => 'Moravian-Silesian', 'iso' => 'moravian_silesian', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // germany
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Baden-Württemberg', 'iso' => 'baden_wurttemberg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Bavaria', 'iso' => 'bavaria', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Berlin', 'iso' => 'berlin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Brandenburg', 'iso' => 'brandenburg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Bremen', 'iso' => 'bremen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Hamburg', 'iso' => 'hamburg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Hesse', 'iso' => 'hesse', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Lower Saxony', 'iso' => 'lower_saxony', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Mecklenburg-Vorpommern', 'iso' => 'mecklenburg_vorpommern', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'North Rhine-Westphalia', 'iso' => 'north_rhine_westphalia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Rhineland-Palatinate', 'iso' => 'rhineland_palatinate', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Saarland', 'iso' => 'saarland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Saxony', 'iso' => 'saxony', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Saxony-Anhalt', 'iso' => 'saxony_anhalt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Schleswig-Holstein', 'iso' => 'schleswig_holstein', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 54, 'name' => 'Thuringia', 'iso' => 'thuringia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // djibouti
            array('uuid' => getUuid(), 'country_id' => 55, 'name' => 'Ali Sabieh', 'iso' => 'ali_sabieh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 55, 'name' => 'Arta', 'iso' => 'arta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 55, 'name' => 'Dikhil', 'iso' => 'dikhil', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 55, 'name' => 'Obock', 'iso' => 'obock', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 55, 'name' => 'Tadjourah', 'iso' => 'tadjourah', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // denmark
            array('uuid' => getUuid(), 'country_id' => 56, 'name' => 'Capital Region of Denmark', 'iso' => 'capital_region', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 56, 'name' => 'Central Denmark Region', 'iso' => 'central_denmark', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 56, 'name' => 'North Denmark Region', 'iso' => 'north_denmark', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 56, 'name' => 'Region of Southern Denmark', 'iso' => 'southern_denmark', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 56, 'name' => 'Region Zealand', 'iso' => 'zealand', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // dominica
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint Andrew', 'iso' => 'saint_andrew', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint David', 'iso' => 'saint_david', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint George', 'iso' => 'saint_george', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint John', 'iso' => 'saint_john', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint Joseph', 'iso' => 'saint_joseph', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint Luke', 'iso' => 'saint_luke', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint Mark', 'iso' => 'saint_mark', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint Patrick', 'iso' => 'saint_patrick', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint Paul', 'iso' => 'saint_paul', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 57, 'name' => 'Saint Peter', 'iso' => 'saint_peter', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // dominican
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Azua', 'iso' => 'azua', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Baoruco', 'iso' => 'baoruco', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Barahona', 'iso' => 'barahona', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Dajabón', 'iso' => 'dajabon', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Distrito Nacional', 'iso' => 'distrito_nacional', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Duarte', 'iso' => 'duarte', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Elías Piña', 'iso' => 'elias_pina', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'El Seibo', 'iso' => 'el_seibo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Espaillat', 'iso' => 'espaillat', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Hato Mayor', 'iso' => 'hato_mayor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Hermanas Mirabal', 'iso' => 'hermanas_mirabal', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Independencia', 'iso' => 'independencia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'La Altagracia', 'iso' => 'la_altagracia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'La Romana', 'iso' => 'la_romana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'La Vega', 'iso' => 'la_vega', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'María Trinidad Sánchez', 'iso' => 'maria_trinidad_sanchez', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Monseñor Nouel', 'iso' => 'monsenor_nouel', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Monte Cristi', 'iso' => 'monte_cristi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Monte Plata', 'iso' => 'monte_plata', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Pedernales', 'iso' => 'pedernales', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Peravia', 'iso' => 'peravia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Puerto Plata', 'iso' => 'puerto_plata', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Samaná', 'iso' => 'samana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'San Cristóbal', 'iso' => 'san_cristobal', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'San José de Ocoa', 'iso' => 'san_jose_de_ocoa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'San Juan', 'iso' => 'san_juan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'San Pedro de Macorís', 'iso' => 'san_pedro_de_macoris', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Sánchez Ramírez', 'iso' => 'sanchez_ramirez', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Santiago', 'iso' => 'santiago', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Santiago Rodríguez', 'iso' => 'santiago_rodriguez', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Santo Domingo', 'iso' => 'santo_domingo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 58, 'name' => 'Valverde', 'iso' => 'valverde', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // algeria
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Adrar', 'iso' => 'adrar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Chlef', 'iso' => 'chlef', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Laghouat', 'iso' => 'laghouat', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Oum El Bouaghi', 'iso' => 'oum_el_bouaghi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Batna', 'iso' => 'batna', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Béjaïa', 'iso' => 'bejaia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Biskra', 'iso' => 'biskra', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Béchar', 'iso' => 'bechar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Blida', 'iso' => 'blida', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Bouira', 'iso' => 'bouira', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tamanrasset', 'iso' => 'tamanrasset', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tébessa', 'iso' => 'tebessa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tlemcen', 'iso' => 'tlemcen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tiaret', 'iso' => 'tiaret', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tizi Ouzou', 'iso' => 'tizi_ouzou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Algiers', 'iso' => 'algiers', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Djelfa', 'iso' => 'djelfa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Jijel', 'iso' => 'jijel', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Sétif', 'iso' => 'setif', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Saïda', 'iso' => 'saida', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Skikda', 'iso' => 'skikda', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Sidi Bel Abbès', 'iso' => 'sidi_bel_abbes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Annaba', 'iso' => 'annaba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Guelma', 'iso' => 'guelma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Constantine', 'iso' => 'constantine', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Médéa', 'iso' => 'medea', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Mostaganem', 'iso' => 'mostaganem', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'M\'Sila', 'iso' => 'msila', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Mascara', 'iso' => 'mascara', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Ouargla', 'iso' => 'ouargla', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Oran', 'iso' => 'oran', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'El Bayadh', 'iso' => 'el_bayadh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Illizi', 'iso' => 'illizi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Bordj Bou Arréridj', 'iso' => 'bordj_bou_arreridj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Boumerdès', 'iso' => 'boumerdes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'El Tarf', 'iso' => 'el_tarf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tindouf', 'iso' => 'tindouf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tissemsilt', 'iso' => 'tissemsilt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'El Oued', 'iso' => 'el_oued', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Khenchela', 'iso' => 'khenchela', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Souk Ahras', 'iso' => 'souk_ahras', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Tipaza', 'iso' => 'tipaza', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Mila', 'iso' => 'mila', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Aïn Defla', 'iso' => 'ain_defla', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Naâma', 'iso' => 'naama', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Aïn Témouchent', 'iso' => 'ain_temouchent', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Ghardaïa', 'iso' => 'ghardaia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 59, 'name' => 'Relizane', 'iso' => 'relizane', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // ecuador
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Azuay', 'iso' => 'azuay', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Bolívar', 'iso' => 'bolivar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Cañar', 'iso' => 'canar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Carchi', 'iso' => 'carchi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Chimborazo', 'iso' => 'chimborazo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Cotopaxi', 'iso' => 'cotopaxi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'El Oro', 'iso' => 'el_oro', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Esmeraldas', 'iso' => 'esmeraldas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Galápagos', 'iso' => 'galapagos', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Guayas', 'iso' => 'guayas', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Imbabura', 'iso' => 'imbabura', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Loja', 'iso' => 'loja', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Los Ríos', 'iso' => 'los_rios', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Manabí', 'iso' => 'manabi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Morona-Santiago', 'iso' => 'morona_santiago', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Napo', 'iso' => 'napo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Orellana', 'iso' => 'orellana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Pastaza', 'iso' => 'pastaza', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Pichincha', 'iso' => 'pichincha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Santa Elena', 'iso' => 'santa_elena', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Santo Domingo de los Tsáchilas', 'iso' => 'santo_domingo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Sucumbíos', 'iso' => 'sucumbios', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Tungurahua', 'iso' => 'tungurahua', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 60, 'name' => 'Zamora-Chinchipe', 'iso' => 'zamora_chinchipe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // estonia
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Harju', 'iso' => 'harju', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Hiiu', 'iso' => 'hiiu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Ida-Viru', 'iso' => 'ida_viru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Järva', 'iso' => 'jarva', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Jõgeva', 'iso' => 'jogeva', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Lääne', 'iso' => 'laane', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Lääne-Viru', 'iso' => 'laane_viru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Põlva', 'iso' => 'polva', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Pärnu', 'iso' => 'parnu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Rapla', 'iso' => 'rapla', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Saare', 'iso' => 'saare', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Tartu', 'iso' => 'tartu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Valga', 'iso' => 'valga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Viljandi', 'iso' => 'viljandi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 61, 'name' => 'Võru', 'iso' => 'voru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // egypt
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Alexandria', 'iso' => 'alexandria', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Aswan', 'iso' => 'aswan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Asyut', 'iso' => 'asyut', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Beheira', 'iso' => 'beheira', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Beni Suef', 'iso' => 'beni_suef', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Cairo', 'iso' => 'cairo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Dakahlia', 'iso' => 'dakahlia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Damietta', 'iso' => 'damietta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Faiyum', 'iso' => 'faiyum', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Gharbia', 'iso' => 'gharbia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Giza', 'iso' => 'giza', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Ismailia', 'iso' => 'ismailia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Kafr el-Sheikh', 'iso' => 'kafr_el_sheikh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Luxor', 'iso' => 'luxor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Matrouh', 'iso' => 'matrouh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Minya', 'iso' => 'minya', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Monufia', 'iso' => 'monufia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'New Valley', 'iso' => 'new_valley', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'North Sinai', 'iso' => 'north_sinai', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Port Said', 'iso' => 'port_said', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Qalyubia', 'iso' => 'qalyubia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Qena', 'iso' => 'qena', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Red Sea', 'iso' => 'red_sea', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Sharqia', 'iso' => 'sharqia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Sohag', 'iso' => 'sohag', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'South Sinai', 'iso' => 'south_sinai', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 62, 'name' => 'Suez', 'iso' => 'suez', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // eritrea
            array('uuid' => getUuid(), 'country_id' => 63, 'name' => 'Anseba', 'iso' => 'anseba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 63, 'name' => 'Debub', 'iso' => 'debub', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 63, 'name' => 'Gash-Barka', 'iso' => 'gash_barka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 63, 'name' => 'Maekel', 'iso' => 'maekel', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 63, 'name' => 'Northern Red Sea', 'iso' => 'northern_red_sea', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 63, 'name' => 'Southern Red Sea', 'iso' => 'southern_red_sea', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // spain
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Andalusia', 'iso' => 'andalusia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Aragon', 'iso' => 'aragon', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Asturias', 'iso' => 'asturias', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Balearic Islands', 'iso' => 'balearic_islands', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Basque Country', 'iso' => 'basque_country', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Canary Islands', 'iso' => 'canary_islands', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Cantabria', 'iso' => 'cantabria', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Castilla-La Mancha', 'iso' => 'castilla_la_mancha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Castilla y Leon', 'iso' => 'castilla_y_leon', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Catalonia', 'iso' => 'catalonia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Extremadura', 'iso' => 'extremadura', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Galicia', 'iso' => 'galicia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Madrid', 'iso' => 'madrid', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Murcia', 'iso' => 'murcia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Navarre', 'iso' => 'navarre', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'La Rioja', 'iso' => 'la_rioja', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Ceuta', 'iso' => 'ceuta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 64, 'name' => 'Melilla', 'iso' => 'melilla', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // ethiopia
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Addis Ababa', 'iso' => 'addis_ababa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Afar', 'iso' => 'afar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Amhara', 'iso' => 'amhara', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Benishangul-Gumuz', 'iso' => 'benishangul_gumuz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Dire Dawa', 'iso' => 'dire_dawa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Gambela', 'iso' => 'gambela', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Harari', 'iso' => 'harari', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Oromia', 'iso' => 'oromia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Sidama', 'iso' => 'sidama', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Southern Nations, Nationalities, and Peoples\' Region', 'iso' => 'snnpr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 65, 'name' => 'Tigray', 'iso' => 'tigray', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // finland
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Åland Islands', 'iso' => 'aland_islands', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Central Finland', 'iso' => 'central_finland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Eastern Finland', 'iso' => 'eastern_finland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Lapland', 'iso' => 'lapland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Länsi-Suomi', 'iso' => 'lansi_suomi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Ostrobothnia', 'iso' => 'ostrobothnia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Pirkanmaa', 'iso' => 'pirkanmaa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Pohjois-Karjala', 'iso' => 'pohjois_karjala', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Pohjois-Pohjanmaa', 'iso' => 'pohjois_pohjanmaa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'South Karelia', 'iso' => 'south_karelia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'South Ostrobothnia', 'iso' => 'south_ostrobothnia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Southern Finland', 'iso' => 'southern_finland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Southern Ostrobothnia', 'iso' => 'southern_ostrobothnia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Uusimaa', 'iso' => 'uusimaa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 66, 'name' => 'Western Finland', 'iso' => 'western_finland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // fiji
            array('uuid' => getUuid(), 'country_id' => 67, 'name' => 'Central Division', 'iso' => 'central_division', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 67, 'name' => 'Eastern Division', 'iso' => 'eastern_division', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 67, 'name' => 'Northern Division', 'iso' => 'northern_division', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 67, 'name' => 'Western Division', 'iso' => 'western_division', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // falkland islands (malvinas)
            array('uuid' => getUuid(), 'country_id' => 68, 'name' => 'Falkland Islands', 'iso' => 'falkland_islands', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // faroe islands
            array('uuid' => getUuid(), 'country_id' => 69, 'name' => 'Faroe Islands', 'iso' => 'faroe_islands', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // france
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Île-de-France', 'iso' => 'ile_de_france', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Auvergne-Rhône-Alpes', 'iso' => 'auvergne_rhone_alpes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Bourgogne-Franche-Comté', 'iso' => 'bourgogne_franche_comte', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Brittany', 'iso' => 'brittany', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Centre-Val de Loire', 'iso' => 'centre_val_de_loire', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Corsica', 'iso' => 'corsica', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Grand Est', 'iso' => 'grand_est', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Hauts-de-France', 'iso' => 'hauts_de_france', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Normandy', 'iso' => 'normandy', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Nouvelle-Aquitaine', 'iso' => 'nouvelle_aquitaine', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Occitanie', 'iso' => 'occitanie', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Pays de la Loire', 'iso' => 'pays_de_la_loire', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 70, 'name' => 'Provence-Alpes-Côte d\'Azur', 'iso' => 'provence_alpes_cote_d_azur', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // gabon
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Estuaire', 'iso' => 'estuaire', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Haut-Ogooué', 'iso' => 'haut_ogoue', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Moyen-Ogooué', 'iso' => 'moyen_ogoue', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Ngounié', 'iso' => 'ngounie', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Nyanga', 'iso' => 'nyanga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Ogooué-Ivindo', 'iso' => 'ogoue_ivindo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Ogooué-Lolo', 'iso' => 'ogoue_lolo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 71, 'name' => 'Woleu-Ntem', 'iso' => 'woleu_ntem', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // united kingdom
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'England', 'iso' => 'england', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'Scotland', 'iso' => 'scotland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'Wales', 'iso' => 'wales', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'Northern Ireland', 'iso' => 'northern_ireland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'Greater London', 'iso' => 'greater_london', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'Yorkshire and the Humber', 'iso' => 'yorkshire_and_the_humber', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'East Midlands', 'iso' => 'east_midlands', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'West Midlands', 'iso' => 'west_midlands', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'North West', 'iso' => 'north_west', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'North East', 'iso' => 'north_east', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'South East', 'iso' => 'south_east', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'South West', 'iso' => 'south_west', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 72, 'name' => 'East of England', 'iso' => 'east_of_england', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // grenada
            array('uuid' => getUuid(), 'country_id' => 73, 'name' => 'Saint George', 'iso' => 'saint_george', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 73, 'name' => 'Saint David', 'iso' => 'saint_david', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 73, 'name' => 'Saint Andrew', 'iso' => 'saint_andrew', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 73, 'name' => 'Saint Patrick', 'iso' => 'saint_patrick', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 73, 'name' => 'Carriacou and Petite Martinique', 'iso' => 'carriacou_petite_martinique', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // georgia
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Abkhazia', 'iso' => 'abkhazia', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Adjara', 'iso' => 'adjara', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Guria', 'iso' => 'guria', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Imereti', 'iso' => 'imereti', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Kakheti', 'iso' => 'kakheti', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Kvemo Kartli', 'iso' => 'kvemo_kartli', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Mtskheta-Mtianeti', 'iso' => 'mtskhheta_mtianeti', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Racha-Lechkhumi and Kvemo Svaneti', 'iso' => 'racha_lechkhumi_kvemo_svaneti', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Samegrelo-Zemo Svaneti', 'iso' => 'samegrelo_zemo_svaneti', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Samtskhe-Javakheti', 'iso' => 'samtskhe_javakheti', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 74, 'name' => 'Shida Kartli', 'iso' => 'shida_kartli', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // ghana
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Greater Accra Region', 'iso' => 'gar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Ashanti Region', 'iso' => 'ash', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Western Region', 'iso' => 'wer', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Eastern Region', 'iso' => 'ear', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Central Region', 'iso' => 'cen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Volta Region', 'iso' => 'vol', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Northern Region', 'iso' => 'nor', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Upper East Region', 'iso' => 'ues', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Upper West Region', 'iso' => 'uwe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Brong-Ahafo Region', 'iso' => 'bah', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 75, 'name' => 'Western North Region', 'iso' => 'wno', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // gibraltar
            array('uuid' => getUuid(), 'country_id' => 76, 'name' => 'Gibraltar', 'iso' => 'gib', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // greenland
            array('uuid' => getUuid(), 'country_id' => 77, 'name' => 'Greenland', 'iso' => 'grl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // gambia
            array('uuid' => getUuid(), 'country_id' => 78, 'name' => 'Banjul', 'iso' => 'ban', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 78, 'name' => 'Western Region', 'iso' => 'wes', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 78, 'name' => 'Central River Region', 'iso' => 'cen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 78, 'name' => 'Lower River Region', 'iso' => 'low', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 78, 'name' => 'Upper River Region', 'iso' => 'upp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // guinea
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'Conakry', 'iso' => 'con', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'Boke', 'iso' => 'bok', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'Faranah', 'iso' => 'far', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'Kankan', 'iso' => 'kan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'Kindia', 'iso' => 'kin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'Labe', 'iso' => 'lab', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'Mamou', 'iso' => 'mam', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 79, 'name' => 'N’zerekore', 'iso' => 'nze', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // equatorial guinea
            array('uuid' => getUuid(), 'country_id' => 80, 'name' => 'Bioko Norte', 'iso' => 'bno', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 80, 'name' => 'Bioko Sur', 'iso' => 'bso', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 80, 'name' => 'Centro Sur', 'iso' => 'csu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 80, 'name' => 'Kie-Ntem', 'iso' => 'knt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 80, 'name' => 'Litoral', 'iso' => 'lit', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 80, 'name' => 'Wele-Nzas', 'iso' => 'wnz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // greece
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Attica', 'iso' => 'att', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Central Greece', 'iso' => 'cen', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Central Macedonia', 'iso' => 'mac', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Crete', 'iso' => 'cre', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'East Macedonia and Thrace', 'iso' => 'emt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Epirus', 'iso' => 'epi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Ionian Islands', 'iso' => 'ion', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'North Aegean', 'iso' => 'nae', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Peloponnese', 'iso' => 'pel', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'South Aegean', 'iso' => 'sae', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Thessaly', 'iso' => 'the', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'West Macedonia', 'iso' => 'wma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 81, 'name' => 'Western Greece', 'iso' => 'wgr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // guatemala
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Alta Verapaz', 'iso' => 'av', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Baja Verapaz', 'iso' => 'bv', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Chimaltenango', 'iso' => 'ch', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Chiquimula', 'iso' => 'ci', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Escuintla', 'iso' => 'es', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Guatemala', 'iso' => 'gu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Huehuetenango', 'iso' => 'hu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Izabal', 'iso' => 'iz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Jalapa', 'iso' => 'ja', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Jutiapa', 'iso' => 'ju', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Petén', 'iso' => 'pe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Quetzaltenango', 'iso' => 'qe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Quiché', 'iso' => 'qi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Retalhuleu', 'iso' => 're', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Sacatepéquez', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'San Marcos', 'iso' => 'sm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Santa Rosa', 'iso' => 'sr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Sololá', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Suchitepéquez', 'iso' => 'su', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Totonicapán', 'iso' => 'to', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 82, 'name' => 'Zacapa', 'iso' => 'za', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // guam
            array('uuid' => getUuid(), 'country_id' => 83, 'name' => 'Guam', 'iso' => 'gu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // guinea-bissau
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Bafatá', 'iso' => 'bf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Cacheu', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Gabu', 'iso' => 'ga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Oio', 'iso' => 'oi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Biombo', 'iso' => 'bi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Tombali', 'iso' => 'to', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Bolama', 'iso' => 'bo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 84, 'name' => 'Bissau', 'iso' => 'bs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // guyana
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'Barima-Waini', 'iso' => 'bw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'Demerara-Mahaica', 'iso' => 'dm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'Essequibo Islands-West Demerara', 'iso' => 'ew', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'Mahaica-Berbice', 'iso' => 'mb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'Pomeroon-Supenaam', 'iso' => 'ps', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'Upper Demerara-Berbice', 'iso' => 'ud', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'East Berbice-Corentyne', 'iso' => 'eb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 85, 'name' => 'Cayenne', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // hong kong
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Central and Western', 'iso' => 'cw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Eastern', 'iso' => 'es', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Southern', 'iso' => 'sn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Wan Chai', 'iso' => 'wc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Kowloon City', 'iso' => 'kc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Kwun Tong', 'iso' => 'kt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Sham Shui Po', 'iso' => 'ss', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Wong Tai Sin', 'iso' => 'ws', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Yau Tsim Mong', 'iso' => 'ytm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Islands', 'iso' => 'is', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'North District', 'iso' => 'nd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Sai Kung', 'iso' => 'sk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Tai Po', 'iso' => 'tp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Tuen Mun', 'iso' => 'tm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 86, 'name' => 'Yuen Long', 'iso' => 'yl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // honduras
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Atlantida', 'iso' => 'at', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Choluteca', 'iso' => 'ch', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Colón', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Comayagua', 'iso' => 'cm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Cortes', 'iso' => 'cr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Intibucá', 'iso' => 'in', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'La Paz', 'iso' => 'lp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Lempira', 'iso' => 'le', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Ocotepeque', 'iso' => 'oc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Gracias a Dios', 'iso' => 'gd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Islas de la Bahía', 'iso' => 'ib', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Santa Bárbara', 'iso' => 'sb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Valle', 'iso' => 'va', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 87, 'name' => 'Yoro', 'iso' => 'yo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // croatia
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Zagreb', 'iso' => 'zg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Split-Dalmatia', 'iso' => 'sd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Osijek-Baranja', 'iso' => 'os', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Primorje-Gorski Kotar', 'iso' => 'pg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Vukovar-Srijem', 'iso' => 'vs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Koprivnica-Križevci', 'iso' => 'kk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Krapina-Zagorje', 'iso' => 'kz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Istria', 'iso' => 'is', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Bjelovar-Bilogora', 'iso' => 'bb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Šibenik-Knin', 'iso' => 'sk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Zadar', 'iso' => 'za', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Međimurje', 'iso' => 'mj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Varaždin', 'iso' => 'vr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Sisak-Moslavina', 'iso' => 'sm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Lika-Senj', 'iso' => 'ls', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 88, 'name' => 'Dubrovnik-Neretva', 'iso' => 'dn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // haiti
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Ouest', 'iso' => 'ou', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Nord', 'iso' => 'nd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Nord-Est', 'iso' => 'ne', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Artibonite', 'iso' => 'ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Sud', 'iso' => 'sd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Sud-Est', 'iso' => 'se', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Centre', 'iso' => 'ce', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Nippes', 'iso' => 'ni', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Grand’Anse', 'iso' => 'ga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 89, 'name' => 'Nord-Ouest', 'iso' => 'no', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // hungry
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Budapest', 'iso' => 'bu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Baranya', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Békés', 'iso' => 'be', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Borsod-Abaúj-Zemplén', 'iso' => 'bo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Csongrád', 'iso' => 'cs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Fejér', 'iso' => 'fe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Győr-Moson-Sopron', 'iso' => 'gy', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Hajdú-Bihar', 'iso' => 'ha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Heves', 'iso' => 'he', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Jász-Nagykun-Szolnok', 'iso' => 'ja', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Komárom-Esztergom', 'iso' => 'ko', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Nógrád', 'iso' => 'no', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Pest', 'iso' => 'pe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Somogy', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Szabolcs-Szatmár-Bereg', 'iso' => 'sz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Tolna', 'iso' => 'to', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Vas', 'iso' => 'va', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Veszprém', 'iso' => 've', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 90, 'name' => 'Zala', 'iso' => 'za', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // // indonesia
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Aceh', 'iso' => 'ac', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Bali', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Banten', 'iso' => 'bt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Bengkulu', 'iso' => 'be', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Gorontalo', 'iso' => 'go', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Jakarta', 'iso' => 'jk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Jambi', 'iso' => 'ja', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'West Java', 'iso' => 'jb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Central Java', 'iso' => 'jt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'East Java', 'iso' => 'ji', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'North Kalimantan', 'iso' => 'ku', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'South Kalimantan', 'iso' => 'ks', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'East Kalimantan', 'iso' => 'ki', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'West Kalimantan', 'iso' => 'kb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'North Sumatra', 'iso' => 'su', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'South Sumatra', 'iso' => 'ss', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'West Sumatra', 'iso' => 'sm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Yogyakarta', 'iso' => 'yo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Lampung', 'iso' => 'la', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Maluku', 'iso' => 'mu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'North Maluku', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Nusa Tenggara Barat', 'iso' => 'nb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Nusa Tenggara Timur', 'iso' => 'nt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Papua', 'iso' => 'pa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'West Papua', 'iso' => 'pb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Riau', 'iso' => 'ri', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Southeast Sulawesi', 'iso' => 'se', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'South Sulawesi', 'iso' => 'sl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'West Sulawesi', 'iso' => 'sw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'Sumatra', 'iso' => 'su', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // array('uuid' => getUuid(), 'country_id' => 91, 'name' => 'West Nusa Tenggara', 'iso' => 'wn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // ireland
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Carlow', 'iso' => 'cw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Cavan', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Clare', 'iso' => 'cl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Cork', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Derry', 'iso' => 'der', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Donegal', 'iso' => 'do', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Down', 'iso' => 'dn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Dublin', 'iso' => 'du', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Fermanagh', 'iso' => 'fe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Galway', 'iso' => 'ga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Kerry', 'iso' => 'ke', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Kildare', 'iso' => 'ki', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Kilkenny', 'iso' => 'kk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Laois', 'iso' => 'la', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Leitrim', 'iso' => 'le', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Limerick', 'iso' => 'lm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Longford', 'iso' => 'lf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Louth', 'iso' => 'lu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Mayo', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Meath', 'iso' => 'mh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Monaghan', 'iso' => 'mo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Offaly', 'iso' => 'of', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Roscommon', 'iso' => 'ro', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Sligo', 'iso' => 'sl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Tipperary', 'iso' => 'ti', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Tyrone', 'iso' => 'ty', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Waterford', 'iso' => 'wa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Westmeath', 'iso' => 'wm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Wexford', 'iso' => 'wx', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 92, 'name' => 'Wicklow', 'iso' => 'wi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // isle of man
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Douglas', 'iso' => 'do', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Ramsey', 'iso' => 'ra', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Castletown', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Peel', 'iso' => 'pe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Port Erin', 'iso' => 'po', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Onchan', 'iso' => 'on', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Laxey', 'iso' => 'la', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 93, 'name' => 'Baldrine', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // india
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Andhra Pradesh', 'iso' => 'ap', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Arunachal Pradesh', 'iso' => 'ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Assam', 'iso' => 'as', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Bihar', 'iso' => 'br', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Chhattisgarh', 'iso' => 'cg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Goa', 'iso' => 'ga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Gujarat', 'iso' => 'gj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Haryana', 'iso' => 'hr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Himachal Pradesh', 'iso' => 'hp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Jharkhand', 'iso' => 'jh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Karnataka', 'iso' => 'ka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Kerala', 'iso' => 'kl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Madhya Pradesh', 'iso' => 'mp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Maharashtra', 'iso' => 'mh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Manipur', 'iso' => 'mn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Meghalaya', 'iso' => 'ml', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Mizoram', 'iso' => 'mz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Nagaland', 'iso' => 'nl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Odisha', 'iso' => 'or', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Punjab', 'iso' => 'pb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Rajasthan', 'iso' => 'rj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Sikkim', 'iso' => 'sk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Tamil Nadu', 'iso' => 'tn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Telangana', 'iso' => 'ts', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Tripura', 'iso' => 'tr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Uttarakhand', 'iso' => 'ut', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Uttar Pradesh', 'iso' => 'up', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'West Bengal', 'iso' => 'wb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Andaman and Nicobar Islands', 'iso' => 'an', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Chandigarh', 'iso' => 'ch', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Dadra and Nagar Haveli and Daman and Diu', 'iso' => 'dn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Lakshadweep', 'iso' => 'ld', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Delhi', 'iso' => 'dl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 94, 'name' => 'Puducherry', 'iso' => 'py', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // iraq
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Al Anbar', 'iso' => 'an', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Al Qadisiyyah', 'iso' => 'qa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'An-Najaf', 'iso' => 'na', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Babil', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Baghdad', 'iso' => 'bg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Basra', 'iso' => 'bs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Dhi Qar', 'iso' => 'dq', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Diyala', 'iso' => 'dy', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Erbil', 'iso' => 'er', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Karbala', 'iso' => 'ka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Kirkuk', 'iso' => 'ki', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Maysan', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Najaf', 'iso' => 'nj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Nineveh', 'iso' => 'ni', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Salah ad Din', 'iso' => 'sd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Sulaymaniyah', 'iso' => 'su', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 95, 'name' => 'Wasit', 'iso' => 'wa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // iran
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Alborz', 'iso' => 'al', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Ardabil', 'iso' => 'ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Bushehr', 'iso' => 'bu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Chaharmahal and Bakhtiari', 'iso' => 'ch', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'East Azerbaijan', 'iso' => 'ea', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Esfahan', 'iso' => 'es', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Fars', 'iso' => 'fa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Gilan', 'iso' => 'gi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Golestan', 'iso' => 'go', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Hamadan', 'iso' => 'ha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Hormozgan', 'iso' => 'ho', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Ilam', 'iso' => 'il', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Kerman', 'iso' => 'ke', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Kermanshah', 'iso' => 'kr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Khuzestan', 'iso' => 'kh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Kohgiluyeh and Boyer-Ahmad', 'iso' => 'ko', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Kurdistan', 'iso' => 'ku', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Lorestan', 'iso' => 'lo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Markazi', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Mazandaran', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Ostān-e Qazvīn', 'iso' => 'qa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Qom', 'iso' => 'qo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Razavi Khorasan', 'iso' => 'ra', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Semnan', 'iso' => 'se', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Sistan and Baluchestan', 'iso' => 'si', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Tehran', 'iso' => 'te', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Yazd', 'iso' => 'ya', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 96, 'name' => 'Zanjan', 'iso' => 'za', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // iceland
            array('uuid' => getUuid(), 'country_id' => 97, 'name' => 'Capital Region', 'iso' => '00', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 97, 'name' => 'Southern Peninsula', 'iso' => '01', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 97, 'name' => 'West Iceland', 'iso' => '02', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 97, 'name' => 'Westfjords', 'iso' => '03', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 97, 'name' => 'North Iceland', 'iso' => '04', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 97, 'name' => 'East Iceland', 'iso' => '05', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 97, 'name' => 'South Iceland', 'iso' => '06', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // italy
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Abruzzo', 'iso' => 'ABR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Aosta Valley', 'iso' => 'VDA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Apulia', 'iso' => 'PUG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Basilicata', 'iso' => 'BAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Calabria', 'iso' => 'CAL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Campania', 'iso' => 'CAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Emilia-Romagna', 'iso' => 'EMR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Friuli Venezia Giulia', 'iso' => 'FVG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Lazio', 'iso' => 'LAZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Liguria', 'iso' => 'LIG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Lombardy', 'iso' => 'LOM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Marche', 'iso' => 'MAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Molise', 'iso' => 'MOL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Piedmont', 'iso' => 'PIE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Sardinia', 'iso' => 'SAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Sicily', 'iso' => 'SIC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Trentino-Alto Adige/Südtirol', 'iso' => 'TAA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Tuscany', 'iso' => 'TOS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Umbria', 'iso' => 'UMB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 98, 'name' => 'Veneto', 'iso' => 'VEN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // jamaica
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'Clarendon', 'iso' => 'CL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'Hanover', 'iso' => 'HA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'Kingston', 'iso' => 'KI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'Manchester', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'Portland', 'iso' => 'PO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'St. Andrew', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'St. Ann', 'iso' => 'AN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'St. Catherine', 'iso' => 'CA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'St. Elizabeth', 'iso' => 'ES', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'St. James', 'iso' => 'JA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'St. Mary', 'iso' => 'MY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'St. Thomas', 'iso' => 'TH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'Trelawny', 'iso' => 'TR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 99, 'name' => 'Westmoreland', 'iso' => 'WE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // jordan
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Ajloun', 'iso' => 'AJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Amman', 'iso' => 'AM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Arqa', 'iso' => 'AR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Balqa', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Irbid', 'iso' => 'IR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Jerash', 'iso' => 'JE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Karak', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Ma\'an', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Mafraq', 'iso' => 'MF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Tafila', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 100, 'name' => 'Zarqa', 'iso' => 'ZA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // japan
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Aichi', 'iso' => 'AI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Akita', 'iso' => 'AK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Aomori', 'iso' => 'AM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Chiba', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Ehime', 'iso' => 'EH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Fukui', 'iso' => 'FU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Fukuoka', 'iso' => 'FO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Gifu', 'iso' => 'GI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Gunma', 'iso' => 'GU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Hiroshima', 'iso' => 'HI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Hokkaido', 'iso' => 'HO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Hyogo', 'iso' => 'HY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Ibaraki', 'iso' => 'IB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Ishikawa', 'iso' => 'IS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Iwate', 'iso' => 'IW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Kagawa', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Kagoshima', 'iso' => 'KG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Kanagawa', 'iso' => 'KN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Kochi', 'iso' => 'KO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Kumamoto', 'iso' => 'KU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Kyoto', 'iso' => 'KY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Mie', 'iso' => 'MI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Miyagi', 'iso' => 'MY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Miyazaki', 'iso' => 'MZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Nagano', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Nagasaki', 'iso' => 'NG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Nara', 'iso' => 'NR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Niigata', 'iso' => 'NI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Oita', 'iso' => 'OI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Okayama', 'iso' => 'OK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Okinawa', 'iso' => 'ON', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Osaka', 'iso' => 'OS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Saga', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Saitama', 'iso' => 'ST', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Shiga', 'iso' => 'SH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Shimane', 'iso' => 'SI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Shizuoka', 'iso' => 'SZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Tochigi', 'iso' => 'TO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Tokushima', 'iso' => 'TK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Tokyo', 'iso' => 'TY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Tottori', 'iso' => 'TR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Toyama', 'iso' => 'TY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Wakayama', 'iso' => 'WK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Yamagata', 'iso' => 'YA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Yamaguchi', 'iso' => 'YG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 101, 'name' => 'Yokohama', 'iso' => 'YO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // kenya
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Bomet', 'iso' => 'BO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Bungoma', 'iso' => 'BU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Busia', 'iso' => 'BS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Embu', 'iso' => 'EM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Garissa', 'iso' => 'GA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Homa Bay', 'iso' => 'HB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Isiolo', 'iso' => 'IS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kajiado', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kakamega', 'iso' => 'KK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kericho', 'iso' => 'KE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kiambu', 'iso' => 'KI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kilifi', 'iso' => 'KL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kirinyaga', 'iso' => 'KY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kisii', 'iso' => 'KS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kisumu', 'iso' => 'KM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kitui', 'iso' => 'KT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Kwale', 'iso' => 'KW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Laikipia', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Lamu', 'iso' => 'LM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Makueni', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Mandera', 'iso' => 'MD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Marsabit', 'iso' => 'MR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Meru', 'iso' => 'ME', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Migori', 'iso' => 'MG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Mombasa', 'iso' => 'MO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Murang\'a', 'iso' => 'MU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Nairobi', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Nakuru', 'iso' => 'NK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Nandi', 'iso' => 'ND', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Narok', 'iso' => 'NR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Niue', 'iso' => 'NU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Nyamira', 'iso' => 'NY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Nyeri', 'iso' => 'NY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Samburu', 'iso' => 'SB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Siaya', 'iso' => 'SY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Taita Taveta', 'iso' => 'TT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Tana River', 'iso' => 'TR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Tharaka Nithi', 'iso' => 'TN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Trans Nzoia', 'iso' => 'TN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Uasin Gishu', 'iso' => 'UG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Vihiga', 'iso' => 'VI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'Wajir', 'iso' => 'WA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 102, 'name' => 'West Pokot', 'iso' => 'WP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // kyrgyzstan
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Bishkek', 'iso' => 'BI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Batken', 'iso' => 'BT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Chuy', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Jalal-Abad', 'iso' => 'JA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Naryn', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Osh', 'iso' => 'OS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Talas', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Issyk-Kul', 'iso' => 'IK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 103, 'name' => 'Shyy', 'iso' => 'SH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cambodia
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Banteay Meanchey', 'iso' => 'BM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Battambang', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Kampong Cham', 'iso' => 'KC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Kampong Chhnang', 'iso' => 'KCH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Kampong Speu', 'iso' => 'KS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Kandal', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Koh Kong', 'iso' => 'KK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Kratie', 'iso' => 'KR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Mondulkiri', 'iso' => 'MO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Phnom Penh', 'iso' => 'PP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Preah Vihear', 'iso' => 'PV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Prey Veng', 'iso' => 'PV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Pursat', 'iso' => 'PS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Ratanakiri', 'iso' => 'RA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Siem Reap', 'iso' => 'SR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Sihanoukville', 'iso' => 'SH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Stung Treng', 'iso' => 'ST', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Svay Rieng', 'iso' => 'SR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 104, 'name' => 'Takeo', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // kiribati
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Bairiki', 'iso' => 'BRK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Betio', 'iso' => 'BET', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Eita', 'iso' => 'EIT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Fanning', 'iso' => 'FAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Kuria', 'iso' => 'KUR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Maiana', 'iso' => 'MAI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Makin', 'iso' => 'MAK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Nikunau', 'iso' => 'NIK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Nonouti', 'iso' => 'NON', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Tabiteuea', 'iso' => 'TAB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Tamana', 'iso' => 'TAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Tarawa', 'iso' => 'TAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Tabuaeran', 'iso' => 'TAB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 105, 'name' => 'Banaba', 'iso' => 'BAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // comoros
            array('uuid' => getUuid(), 'country_id' => 106, 'name' => 'Anjouan', 'iso' => 'ANJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 106, 'name' => 'Grande Comore', 'iso' => 'GRC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 106, 'name' => 'Mohéli', 'iso' => 'MOH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // saint kitts and nevis
            array('uuid' => getUuid(), 'country_id' => 107, 'name' => 'Saint Kitts', 'iso' => 'SKN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 107, 'name' => 'Nevis', 'iso' => 'NEV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // korea democratic peoples republic of
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'Pyongyang', 'iso' => 'PY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'Chagang', 'iso' => 'CHG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'North Hamgyong', 'iso' => 'NHG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'South Hamgyong', 'iso' => 'SHG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'North Hwanghae', 'iso' => 'NHH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'South Hwanghae', 'iso' => 'SHH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'Kangwon', 'iso' => 'KWN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'Ryanggang', 'iso' => 'RYG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'Nampo', 'iso' => 'NAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 108, 'name' => 'Kaesong', 'iso' => 'KAE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // korea republic of
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Seoul', 'iso' => 'SEO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Busan', 'iso' => 'BSN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Incheon', 'iso' => 'INC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Daegu', 'iso' => 'DAE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Daejeon', 'iso' => 'DEJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Gwangju', 'iso' => 'GWJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Ulsan', 'iso' => 'ULS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Gyeonggi', 'iso' => 'GGI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Gangwon', 'iso' => 'GWN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'North Chungcheong', 'iso' => 'NCC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'South Chungcheong', 'iso' => 'SCC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'North Gyeongsang', 'iso' => 'NGS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'South Gyeongsang', 'iso' => 'SGS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Jeolla', 'iso' => 'JLL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 109, 'name' => 'Jeju', 'iso' => 'JEJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // kuwait
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Al Asimah', 'iso' => 'AS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Hawalli', 'iso' => 'HA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Mishref', 'iso' => 'MI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Ahmadi', 'iso' => 'AH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Farwaniya', 'iso' => 'FA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Jahra', 'iso' => 'JA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Al Fintas', 'iso' => 'AF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 110, 'name' => 'Sabah Al Ahmad', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // cayman islands
            array('uuid' => getUuid(), 'country_id' => 111, 'name' => 'Grand Cayman', 'iso' => 'GC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 111, 'name' => 'Cayman Brac', 'iso' => 'CB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 111, 'name' => 'Little Cayman', 'iso' => 'LC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // kazakstan
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Almaty', 'iso' => 'ALM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Atyrau', 'iso' => 'ATY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Aktobe', 'iso' => 'AKT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Shymkent', 'iso' => 'SHY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Karaganda', 'iso' => 'KAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Pavlodar', 'iso' => 'PAV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'North Kazakhstan', 'iso' => 'NSK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'East Kazakhstan', 'iso' => 'EK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'West Kazakhstan', 'iso' => 'WKA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Zhambyl', 'iso' => 'ZHA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Kyzylorda', 'iso' => 'KYZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 112, 'name' => 'Mangystau', 'iso' => 'MAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            //lao peoples democratic republic
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Vientiane', 'iso' => 'VTE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Luang Prabang', 'iso' => 'LPR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Champasak', 'iso' => 'CPS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Savannakhet', 'iso' => 'SVK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Xieng Khouang', 'iso' => 'XKH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Houaphanh', 'iso' => 'HUA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Bokeo', 'iso' => 'BOK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Phongsali', 'iso' => 'PHO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Oudomxay', 'iso' => 'OUX', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Saravan', 'iso' => 'SAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Vientiane Prefecture', 'iso' => 'VNP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 113, 'name' => 'Attapeu', 'iso' => 'ATT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // lebanon
            array('uuid' => getUuid(), 'country_id' => 114, 'name' => 'Beirut', 'iso' => 'BEY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 114, 'name' => 'Mount Lebanon', 'iso' => 'MTL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 114, 'name' => 'South Governorate', 'iso' => 'SOU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 114, 'name' => 'North Governorate', 'iso' => 'NOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 114, 'name' => 'Bekaa', 'iso' => 'BEK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 114, 'name' => 'Nabatieh', 'iso' => 'NAB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // saint lucia
            array('uuid' => getUuid(), 'country_id' => 115, 'name' => 'Castries', 'iso' => 'CAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 115, 'name' => 'Soufrière', 'iso' => 'SOU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 115, 'name' => 'Vieux Fort', 'iso' => 'VIE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 115, 'name' => 'Anse la Raye', 'iso' => 'ANR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 115, 'name' => 'Canaries', 'iso' => 'CAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 115, 'name' => 'Dennery', 'iso' => 'DEN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 115, 'name' => 'Gros Islet', 'iso' => 'GRO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // liechtenstein
            array('uuid' => getUuid(), 'country_id' => 116, 'name' => 'Vaduz', 'iso' => 'VAD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 116, 'name' => 'Balzers', 'iso' => 'BAL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 116, 'name' => 'Eschen', 'iso' => 'ESC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 116, 'name' => 'Schaan', 'iso' => 'SCH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 116, 'name' => 'Schellenberg', 'iso' => 'SCH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 116, 'name' => 'Mauren', 'iso' => 'MAU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 116, 'name' => 'Ruggell', 'iso' => 'RUG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // sri lanka
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'Central Province', 'iso' => 'CP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'Eastern Province', 'iso' => 'EP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'Northern Province', 'iso' => 'NP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'North Western Province', 'iso' => 'NWP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'Sabaragamuwa Province', 'iso' => 'SP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'Southern Province', 'iso' => 'SP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'Uva Province', 'iso' => 'UP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 117, 'name' => 'Western Province', 'iso' => 'WP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // liberia
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Bong', 'iso' => 'BON', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Gbarpolu', 'iso' => 'GBP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Grand Bassa', 'iso' => 'GBS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Grand Cape Mount', 'iso' => 'GCM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Grand Gedeh', 'iso' => 'GGD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Grand Kru', 'iso' => 'GK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Lofa', 'iso' => 'LOF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Margibi', 'iso' => 'MAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Maryland', 'iso' => 'MYR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Montserrado', 'iso' => 'MTS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Nimba', 'iso' => 'NIM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'River Cess', 'iso' => 'RVC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'River Gee', 'iso' => 'RGE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 118, 'name' => 'Sinoe', 'iso' => 'SIO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // lesotho
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Berea', 'iso' => 'B', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Butha-Buthe', 'iso' => 'BB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Leribe', 'iso' => 'L', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Mafeteng', 'iso' => 'M', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Maseru', 'iso' => 'MS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Mohale’s Hoek', 'iso' => 'MH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Mokhotlong', 'iso' => 'MK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Qacha’s Nek', 'iso' => 'QN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Quthing', 'iso' => 'Q', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 119, 'name' => 'Thaba-Tseka', 'iso' => 'TT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // lithuania
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Alytus', 'iso' => 'AL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Kaunas', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Klaipėda', 'iso' => 'KL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Marijampolė', 'iso' => 'MR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Panevėžys', 'iso' => 'PN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Šiauliai', 'iso' => 'SI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Tauragė', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Telšiai', 'iso' => 'TE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Utena', 'iso' => 'UT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 120, 'name' => 'Vilnius', 'iso' => 'VL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // luxembourg
            array('uuid' => getUuid(), 'country_id' => 121, 'name' => 'Diekirch', 'iso' => 'DI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 121, 'name' => 'Grevenmacher', 'iso' => 'GR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 121, 'name' => 'Luxembourg', 'iso' => 'LU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // latvia
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Aizkraukle', 'iso' => 'AI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Jelgava', 'iso' => 'JE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Jurmala', 'iso' => 'JU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Kraslava', 'iso' => 'KR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Liepaja', 'iso' => 'LI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Jurmala', 'iso' => 'JU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Riga', 'iso' => 'RI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Ventspils', 'iso' => 'VE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Daugavpils', 'iso' => 'DA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 122, 'name' => 'Rezekne', 'iso' => 'RE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // libyan arab jamahiriya
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Al Awbari', 'iso' => 'AW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Al Bayda', 'iso' => 'BY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Al Jufra', 'iso' => 'JU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Al Khums', 'iso' => 'KH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Al Marj', 'iso' => 'MJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Benghazi', 'iso' => 'BG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Derna', 'iso' => 'DE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Gharyan', 'iso' => 'GH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Misrata', 'iso' => 'MI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 123, 'name' => 'Tripoli', 'iso' => 'TR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // morocco
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Agadir-Ida-Ou-Tanane', 'iso' => 'AI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Al Haouz', 'iso' => 'AH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Casablanca-Settat', 'iso' => 'CS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Chaouia-Ouardigha', 'iso' => 'CO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Draa-Tafilalet', 'iso' => 'DT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Fès-Meknès', 'iso' => 'FM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Guelmim-Es Semara', 'iso' => 'GE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Laâyoune-Sakia El Hamra', 'iso' => 'LH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Marrakech-Safi', 'iso' => 'MS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Meknès-Tafilalet', 'iso' => 'MT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Oriental', 'iso' => 'OR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Rabat-Salé-Kénitra', 'iso' => 'RS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Souss-Massa', 'iso' => 'SM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 124, 'name' => 'Tanger-Tétouan-Al Hoceïma', 'iso' => 'TT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // monaco
            array('uuid' => getUuid(), 'country_id' => 125, 'name' => 'La Condamine', 'iso' => 'LC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 125, 'name' => 'Monaco', 'iso' => 'MC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 125, 'name' => 'Moneghetti', 'iso' => 'MG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // moldova, republic of
            array('uuid' => getUuid(), 'country_id' => 126, 'name' => 'Bălți', 'iso' => 'BL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 126, 'name' => 'Bender', 'iso' => 'BD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 126, 'name' => 'Chișinău', 'iso' => 'CS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 126, 'name' => 'Tiraspol', 'iso' => 'TR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 126, 'name' => 'Cahul', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 126, 'name' => 'Comrat', 'iso' => 'CM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // montenegro
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Andrijevica', 'iso' => 'AN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Bar', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Berane', 'iso' => 'BE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Bijelo Polje', 'iso' => 'BP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Danilovgrad', 'iso' => 'DA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Herceg Novi', 'iso' => 'HN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Kolašin', 'iso' => 'KO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Kotor', 'iso' => 'KT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Nikšić', 'iso' => 'NI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Plav', 'iso' => 'PL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Pljevlja', 'iso' => 'PJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Podgorica', 'iso' => 'PG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Rožaje', 'iso' => 'RO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Tivat', 'iso' => 'TI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 127, 'name' => 'Ulcinj', 'iso' => 'UL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // saint martin
            array('uuid' => getUuid(), 'country_id' => 128, 'name' => 'Saint Martin (French part)', 'iso' => 'SM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // madagascar
            array('uuid' => getUuid(), 'country_id' => 129, 'name' => 'Antananarivo', 'iso' => 'Tana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 129, 'name' => 'Fianarantsoa', 'iso' => 'Fianar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 129, 'name' => 'Toamasina', 'iso' => 'Tana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 129, 'name' => 'Mahajanga', 'iso' => 'Mahajanga', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 129, 'name' => 'Toliara', 'iso' => 'Toliara', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 129, 'name' => 'Antsiranana', 'iso' => 'Antsiranana', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // marshall islands
            array('uuid' => getUuid(), 'country_id' => 130, 'name' => 'Majuro', 'iso' => 'Majuro', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 130, 'name' => 'Kwajalein', 'iso' => 'Kwajalein', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 130, 'name' => 'Ebeye', 'iso' => 'Ebeye', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 130, 'name' => 'Ailuk', 'iso' => 'Ailuk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 130, 'name' => 'Arno', 'iso' => 'Arno', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 130, 'name' => 'Bikini', 'iso' => 'Bikini', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // macedonia
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Skopje', 'iso' => 'Skopje', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Bitola', 'iso' => 'Bitola', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Kumanovo', 'iso' => 'Kumanovo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Prilep', 'iso' => 'Prilep', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Tetovo', 'iso' => 'Tetovo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Veles', 'iso' => 'Veles', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Ohrid', 'iso' => 'Ohrid', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Strumica', 'iso' => 'Strumica', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 131, 'name' => 'Kavadarci', 'iso' => 'Kavadarci', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // mali
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Bamako', 'iso' => 'BKO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Kayes', 'iso' => 'BKO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Segou', 'iso' => 'SGO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Koulikoro', 'iso' => 'KOU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Sikasso', 'iso' => 'SKA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Mopti', 'iso' => 'MPT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Tombouctou', 'iso' => 'TMP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Gao', 'iso' => 'GAO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 132, 'name' => 'Kidal', 'iso' => 'KID', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // myanmar
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Yangon', 'iso' => 'RGN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Mandalay', 'iso' => 'MDL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Nay Pyi Taw', 'iso' => 'NPT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Bago', 'iso' => 'BGO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Magway', 'iso' => 'MGY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Ayeyarwady', 'iso' => 'AYR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Shan', 'iso' => 'SHN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Kachin', 'iso' => 'KAC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Kayah', 'iso' => 'KYH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Kayin', 'iso' => 'KYN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Chin', 'iso' => 'CHN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Rakhine', 'iso' => 'RAK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 133, 'name' => 'Tanintharyi', 'iso' => 'TAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // mongolia
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Ulaanbaatar', 'iso' => 'ULA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Arkhangai', 'iso' => 'ARK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Bayan-Ölgii', 'iso' => 'BAY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Bayankhongor', 'iso' => 'BAYK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Bulgan', 'iso' => 'BUL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Darkhan-Uul', 'iso' => 'DHA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Dornod', 'iso' => 'DOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Dornogovi', 'iso' => 'DGV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Govisümber', 'iso' => 'GOV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Hentiy', 'iso' => 'HEN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Khentii', 'iso' => 'KHE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Khovd', 'iso' => 'KHO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Khövsgöl', 'iso' => 'KGV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Ömnögovi', 'iso' => 'OMN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Orkhon', 'iso' => 'ORK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Sükhbaatar', 'iso' => 'SUK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Töv', 'iso' => 'TOV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Uvs', 'iso' => 'UVS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 134, 'name' => 'Zavkhan', 'iso' => 'ZAV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // macau
            array('uuid' => getUuid(), 'country_id' => 135, 'name' => 'Macau', 'iso' => 'MAC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // northern mariana islands
            array('uuid' => getUuid(), 'country_id' => 136, 'name' => 'Saipan', 'iso' => 'SPN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 136, 'name' => 'Tinian', 'iso' => 'TIN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 136, 'name' => 'Rota', 'iso' => 'ROTA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // mauritania
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Adrar', 'iso' => 'ADR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Assaba', 'iso' => 'ASS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Brakna', 'iso' => 'BRA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Gorgol', 'iso' => 'GOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Guidimaka', 'iso' => 'GUI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Hodh Ech Chargui', 'iso' => 'HOC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Hodh El Gharbi', 'iso' => 'HOG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Inchiri', 'iso' => 'INC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Nouakchott', 'iso' => 'NKT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Nouadhibou', 'iso' => 'NDB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Tagant', 'iso' => 'TAG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Tiris Zemmour', 'iso' => 'TIZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 137, 'name' => 'Wilaya de l’Inchiri', 'iso' => 'WDI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // montserrat
            array('uuid' => getUuid(), 'country_id' => 138, 'name' => 'Saint Anthony', 'iso' => 'ANT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 138, 'name' => 'Saint Georges', 'iso' => 'GEA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 138, 'name' => 'Saint Peter', 'iso' => 'PET', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // malta
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Attard', 'iso' => 'ATT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Balzan', 'iso' => 'BAL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Birkirkara', 'iso' => 'BIR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Birżebbuġa', 'iso' => 'BIR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Cospicua', 'iso' => 'COS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Floriana', 'iso' => 'FLO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Gudja', 'iso' => 'GUD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Gżira', 'iso' => 'GZR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Ħamrun', 'iso' => 'HAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Mosta', 'iso' => 'MOS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Mellieħa', 'iso' => 'MEL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Mdina', 'iso' => 'MDI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Marsaskala', 'iso' => 'MAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Marsaxlokk', 'iso' => 'MAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Mġarr', 'iso' => 'MGI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Naxxar', 'iso' => 'NAX', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Paola', 'iso' => 'PAO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Pembroke', 'iso' => 'PEM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Pietà', 'iso' => 'PIE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Qormi', 'iso' => 'QOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Rabat', 'iso' => 'RAB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Safi', 'iso' => 'SAF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'San Ġwann', 'iso' => 'SGW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'San Ġiljan', 'iso' => 'SGI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'San Lawrenz', 'iso' => 'SLZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'San Martin', 'iso' => 'SMT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Senglea', 'iso' => 'SEN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Siġġiewi', 'iso' => 'SIG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Sliema', 'iso' => 'SLI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Swieqi', 'iso' => 'SWE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Ta’ Xbiex', 'iso' => 'TXB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Tarxien', 'iso' => 'TAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Victoria', 'iso' => 'VIC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Zabbar', 'iso' => 'ZAB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 139, 'name' => 'Zejtun', 'iso' => 'ZEJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // mauritius
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Black River', 'iso' => 'BR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Flacq', 'iso' => 'FL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Grand Port', 'iso' => 'GP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Moka', 'iso' => 'MO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Pamplemousses', 'iso' => 'PM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Plaines Wilhems', 'iso' => 'PW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Port Louis', 'iso' => 'PL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Rivière du Rempart', 'iso' => 'RR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 140, 'name' => 'Savanne', 'iso' => 'SV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // maldives
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Alifu Ali fu Atoll', 'iso' => 'AA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Alifu Dhaalu Atoll', 'iso' => 'AD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Baa Atoll', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Dhaalu Atoll', 'iso' => 'DA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Faafu Atoll', 'iso' => 'FA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Gnaviyani Atoll', 'iso' => 'GA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Haa Alifu Atoll', 'iso' => 'HA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Haa Dhaalu Atoll', 'iso' => 'HD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Kaafu Atoll', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Laamu Atoll', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Lhaviyani Atoll', 'iso' => 'LH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Meemu Atoll', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Noonu Atoll', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Raa Atoll', 'iso' => 'RA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Seenu Atoll', 'iso' => 'SE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Shaviyani Atoll', 'iso' => 'SH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Thaa Atoll', 'iso' => 'TH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 141, 'name' => 'Velidhoo', 'iso' => 'VE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // malawi
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Balaka', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Blantyre', 'iso' => 'BL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Chikwawa', 'iso' => 'CK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Chiradzulu', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Machinga', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Mangochi', 'iso' => 'MG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Mchinji', 'iso' => 'MC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Mulanje', 'iso' => 'MU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Mwanza', 'iso' => 'MW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Mzimba', 'iso' => 'MZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Neno', 'iso' => 'NE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Nkhotakota', 'iso' => 'NK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Nsanje', 'iso' => 'NS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Ntcheu', 'iso' => 'NT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Nkhata Bay', 'iso' => 'NB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Ntchisi', 'iso' => 'NC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Phalombe', 'iso' => 'PH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Rumphi', 'iso' => 'RU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Salima', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 142, 'name' => 'Zomba', 'iso' => 'ZO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // maxico
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Aguascalientes', 'iso' => 'AG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Baja California', 'iso' => 'BC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Baja California Sur', 'iso' => 'BS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Campeche', 'iso' => 'CM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Chiapas', 'iso' => 'CS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Chihuahua', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Coahuila', 'iso' => 'CO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Colima', 'iso' => 'CL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Durango', 'iso' => 'DG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Guanajuato', 'iso' => 'GT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Guerrero', 'iso' => 'GR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Hidalgo', 'iso' => 'HG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Jalisco', 'iso' => 'JA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Mexico City', 'iso' => 'CDMX', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Mexico State', 'iso' => 'EM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Michoacán', 'iso' => 'MC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Morelos', 'iso' => 'MO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Nayarit', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Nuevo León', 'iso' => 'NL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Oaxaca', 'iso' => 'OA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Puebla', 'iso' => 'PU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Querétaro', 'iso' => 'QA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Quintana Roo', 'iso' => 'QR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'San Luis Potosí', 'iso' => 'SLP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Sinaloa', 'iso' => 'SI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Sonora', 'iso' => 'SO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Tabasco', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Tamaulipas', 'iso' => 'TM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Tlaxcala', 'iso' => 'TL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Veracruz', 'iso' => 'VE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Yucatán', 'iso' => 'YU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 143, 'name' => 'Zacatecas', 'iso' => 'ZA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // malaysia
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Johor', 'iso' => 'JHR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Kedah', 'iso' => 'KDH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Kelantan', 'iso' => 'KTN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Melaka', 'iso' => 'MLK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Negeri Sembilan', 'iso' => 'NSN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Pahang', 'iso' => 'PHG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Perak', 'iso' => 'PRK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Perlis', 'iso' => 'PLS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Penang', 'iso' => 'PNG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Sabah', 'iso' => 'SBH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Sarawak', 'iso' => 'SWK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Selangor', 'iso' => 'SGR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Terengganu', 'iso' => 'TRG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Kuala Lumpur', 'iso' => 'KUL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 144, 'name' => 'Putrajaya', 'iso' => 'PJY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // mozambique
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Maputo', 'iso' => 'MAP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Gaza', 'iso' => 'GZA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Inhambane', 'iso' => 'INH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Manica', 'iso' => 'MNA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Nampula', 'iso' => 'NAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Niassa', 'iso' => 'NIA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Sofala', 'iso' => 'SOF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Tete', 'iso' => 'TET', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Zambezia', 'iso' => 'ZAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'Cabo Delgado', 'iso' => 'CDG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 146, 'name' => 'City of Maputo', 'iso' => 'MAP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // namibia
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Erongo', 'iso' => 'ERO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Hardap', 'iso' => 'HAD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Karas', 'iso' => 'KAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Kavango East', 'iso' => 'KAE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Kavango West', 'iso' => 'KAW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Khomas', 'iso' => 'KHO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Kunene', 'iso' => 'KUN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Ohangwena', 'iso' => 'OHA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Omusati', 'iso' => 'OMU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Oshana', 'iso' => 'OSH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Oshikoto', 'iso' => 'OSK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 147, 'name' => 'Zambezi', 'iso' => 'ZAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // new caledonia|
            array('uuid' => getUuid(), 'country_id' => 148, 'name' => 'South Province', 'iso' => 'SP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 148, 'name' => 'North Province', 'iso' => 'NP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 148, 'name' => 'Loyauté Islands', 'iso' => 'LI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // niger
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Agadez', 'iso' => 'AG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Diffa', 'iso' => 'DF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Dosso', 'iso' => 'DS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Maradi', 'iso' => 'MR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Tahoua', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Tillabéri', 'iso' => 'TI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Zinder', 'iso' => 'ZD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 149, 'name' => 'Niamey', 'iso' => 'NI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // nigeria
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Abia', 'iso' => 'AB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Adamawa', 'iso' => 'AD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Akwa Ibom', 'iso' => 'AI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Anambra', 'iso' => 'AN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Bauchi', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Bayelsa', 'iso' => 'BY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Benue', 'iso' => 'BE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Borno', 'iso' => 'BO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Cross River', 'iso' => 'CR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Delta', 'iso' => 'DE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Ebonyi', 'iso' => 'EB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Edo', 'iso' => 'ED', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Ekiti', 'iso' => 'EK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Enugu', 'iso' => 'EN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Gombe', 'iso' => 'GO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Imo', 'iso' => 'IM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Jigawa', 'iso' => 'JI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Kaduna', 'iso' => 'KD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Kano', 'iso' => 'KN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Katsina', 'iso' => 'KT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Kebbi', 'iso' => 'KE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Kogi', 'iso' => 'KO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Kwara', 'iso' => 'KW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Lagos', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Nasarawa', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Niger', 'iso' => 'NI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Ogun', 'iso' => 'OG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Ondo', 'iso' => 'ON', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Osun', 'iso' => 'OS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Oyo', 'iso' => 'OY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Plateau', 'iso' => 'PL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Rivers', 'iso' => 'RI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Sokoto', 'iso' => 'SO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Taraba', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Yobe', 'iso' => 'YO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 150, 'name' => 'Zamfara', 'iso' => 'ZA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // nicaragua
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Atlántico Norte', 'iso' => 'AN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Atlántico Sur', 'iso' => 'AS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Boaco', 'iso' => 'BO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Carazo', 'iso' => 'CA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Chinandega', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Chontales', 'iso' => 'CO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Estelí', 'iso' => 'ES', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Granada', 'iso' => 'GR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Jinotega', 'iso' => 'JI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'León', 'iso' => 'LE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Madriz', 'iso' => 'MD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Managua', 'iso' => 'MN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Masaya', 'iso' => 'MS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Mayo Ya', 'iso' => 'MY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Nueva Segovia', 'iso' => 'NS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 151, 'name' => 'Rivas', 'iso' => 'RI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // netherlands
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Drenthe', 'iso' => 'DR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Flevoland', 'iso' => 'FL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Friesland', 'iso' => 'FR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Gelderland', 'iso' => 'GE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Groningen', 'iso' => 'GR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Limburg', 'iso' => 'LI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'North Brabant', 'iso' => 'NB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'North Holland', 'iso' => 'NH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Overijssel', 'iso' => 'OV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'South Holland', 'iso' => 'ZH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Utrecht', 'iso' => 'UT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Zeeland', 'iso' => 'ZE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 152, 'name' => 'Zuid-Holland', 'iso' => 'ZH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // norway
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Agder', 'iso' => 'AG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Innlandet', 'iso' => 'IN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Møre og Romsdal', 'iso' => 'MR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Nordland', 'iso' => 'NO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Oslo', 'iso' => 'OS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Rogaland', 'iso' => 'RO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Troms og Finnmark', 'iso' => 'TF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Trøndelag', 'iso' => 'TR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Vestfold og Telemark', 'iso' => 'VT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 153, 'name' => 'Viken', 'iso' => 'VI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // nepal
            array('uuid' => getUuid(), 'country_id' => 154, 'name' => 'Bagmati', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 154, 'name' => 'Gandaki', 'iso' => 'GA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 154, 'name' => 'Lumbini', 'iso' => 'LU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 154, 'name' => 'Malang', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 154, 'name' => 'Karnali', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 154, 'name' => 'Sudurpashchim', 'iso' => 'SU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // nauru
            array('uuid' => getUuid(), 'country_id' => 155, 'name' => 'Yaren', 'iso' => 'YA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // niue
            array('uuid' => getUuid(), 'country_id' => 156, 'name' => 'Alofi', 'iso' => 'ALF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // new zealand
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Auckland', 'iso' => 'AUK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Bay of Plenty', 'iso' => 'BOP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Canterbury', 'iso' => 'CAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Chatham Islands', 'iso' => 'CIT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Gisborne', 'iso' => 'GIS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Hawke\'s Bay', 'iso' => 'HKB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Manawatu-Wanganui', 'iso' => 'MWT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Marlborough', 'iso' => 'MBH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Nelson', 'iso' => 'NSN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Northland', 'iso' => 'NTL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Otago', 'iso' => 'OTA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Southland', 'iso' => 'STL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Taranaki', 'iso' => 'TAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'Wellington', 'iso' => 'WGN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 157, 'name' => 'West Coast', 'iso' => 'WTC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // oman
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Ad Dakhiliyah', 'iso' => 'DAK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Al Batinah North', 'iso' => 'BHN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Al Batinah South', 'iso' => 'BHS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Al Dhahirah', 'iso' => 'DAH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Al Jouf', 'iso' => 'JOF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Al Wusta', 'iso' => 'WUS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Ash Sharqiyah North', 'iso' => 'SHN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Ash Sharqiyah South', 'iso' => 'SHS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Musandam', 'iso' => 'MSM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Muscat', 'iso' => 'MCT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Dhofar', 'iso' => 'DHF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 158, 'name' => 'Zufar', 'iso' => 'ZUF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // panama
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Bocas del Toro', 'iso' => 'BOC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Coclé', 'iso' => 'COL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Colón', 'iso' => 'CLN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Chiriquí', 'iso' => 'CHR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Darién', 'iso' => 'DAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Herrera', 'iso' => 'HER', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Los Santos', 'iso' => 'SAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Panamá', 'iso' => 'PAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Veraguas', 'iso' => 'VER', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Guna Yala', 'iso' => 'GYA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 159, 'name' => 'Panamá Oeste', 'iso' => 'PAO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // peru
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Amazonas', 'iso' => 'AMA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Áncash', 'iso' => 'ANC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Apurímac', 'iso' => 'APU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Arequipa', 'iso' => 'ARE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Ayacucho', 'iso' => 'AYC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Cajamarca', 'iso' => 'CAJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Callao', 'iso' => 'CAL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Cusco', 'iso' => 'CUS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Huancavelica', 'iso' => 'HUC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Huánuco', 'iso' => 'HUA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Ica', 'iso' => 'ICA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Junín', 'iso' => 'JUN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'La Libertad', 'iso' => 'LAL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Lambayeque', 'iso' => 'LAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Lima', 'iso' => 'LIM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Loreto', 'iso' => 'LOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Madre de Dios', 'iso' => 'MDD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Moquegua', 'iso' => 'MOQ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Pasco', 'iso' => 'PAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Piura', 'iso' => 'PIU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Puno', 'iso' => 'PUN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'San Martín', 'iso' => 'SAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Tacna', 'iso' => 'TAC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Tumbes', 'iso' => 'TUM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 160, 'name' => 'Ucayali', 'iso' => 'UCA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // french polynesia
            array('uuid' => getUuid(), 'country_id' => 161, 'name' => 'Îles Australes', 'iso' => 'AUT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 161, 'name' => 'Îles du Vent', 'iso' => 'DUV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 161, 'name' => 'Îles Marquises', 'iso' => 'MAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 161, 'name' => 'Îles Tuamotu-Gambier', 'iso' => 'TUAG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // papua new guinea
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Central', 'iso' => 'CEN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Chimbu', 'iso' => 'CHM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Eastern Highlands', 'iso' => 'EHI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'East New Britain', 'iso' => 'ENB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'East Sepik', 'iso' => 'ESP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Enga', 'iso' => 'ENG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Gulf', 'iso' => 'GUL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Madang', 'iso' => 'MAD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Manus', 'iso' => 'MAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Milne Bay', 'iso' => 'MBY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Morobe', 'iso' => 'MOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'National Capital District', 'iso' => 'NCD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'New Ireland', 'iso' => 'NIR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Northern', 'iso' => 'NOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Southern Highlands', 'iso' => 'SHI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Western Highlands', 'iso' => 'WHI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'West New Britain', 'iso' => 'WNB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'West Sepik', 'iso' => 'WSP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 162, 'name' => 'Western', 'iso' => 'WES', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // philippines
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Abra', 'iso' => 'ABR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Agusan del Norte', 'iso' => 'AGN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Agusan del Sur', 'iso' => 'AGS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Aklan', 'iso' => 'AKL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Albay', 'iso' => 'ALB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Antique', 'iso' => 'ANT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Apayao', 'iso' => 'APA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Aurora', 'iso' => 'AUR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Basilan', 'iso' => 'BAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Bataan', 'iso' => 'BAT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Batanes', 'iso' => 'BAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Batangas', 'iso' => 'BAG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Benguet', 'iso' => 'BEN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Biliran', 'iso' => 'BIL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Bohol', 'iso' => 'BOH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Bukidnon', 'iso' => 'BUK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Bulacan', 'iso' => 'BUL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Cagayan', 'iso' => 'CAG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Camarines Norte', 'iso' => 'CAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Camarines Sur', 'iso' => 'CAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Camiguin', 'iso' => 'CAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Capiz', 'iso' => 'CAP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Catanduanes', 'iso' => 'CAT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Cavite', 'iso' => 'CAV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Cebu', 'iso' => 'CEB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Compostela Valley', 'iso' => 'COM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Cotabato', 'iso' => 'COT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Davao del Norte', 'iso' => 'DAV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Davao del Sur', 'iso' => 'DAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Davao Occidental', 'iso' => 'DAV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Davao Oriental', 'iso' => 'DVO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Dinagat Islands', 'iso' => 'DIN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Eastern Samar', 'iso' => 'EAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Guimaras', 'iso' => 'GUI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Ifugao', 'iso' => 'IFU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Ilocos Norte', 'iso' => 'ILN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Ilocos Sur', 'iso' => 'ILS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Iloilo', 'iso' => 'ILO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Isabela', 'iso' => 'ISA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Kalinga', 'iso' => 'KAL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Kataragama', 'iso' => 'KAT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'La Union', 'iso' => 'LU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Laguna', 'iso' => 'LAG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Lanao del Norte', 'iso' => 'LAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Lanao del Sur', 'iso' => 'LAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Leyte', 'iso' => 'LEY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Maguindanao', 'iso' => 'MAG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Marinduque', 'iso' => 'MAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Masbate', 'iso' => 'MAS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Metro Manila', 'iso' => 'MM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Misamis Occidental', 'iso' => 'MOS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Misamis Oriental', 'iso' => 'MOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Mountain Province', 'iso' => 'MTP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Negros Occidental', 'iso' => 'NEC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Negros Oriental', 'iso' => 'NEO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Northern Samar', 'iso' => 'NSM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'North Cotabato', 'iso' => 'NCO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Nueva Ecija', 'iso' => 'NEC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Nueva Vizcaya', 'iso' => 'NUV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Palawan', 'iso' => 'PLW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Pampanga', 'iso' => 'PAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Pangasinan', 'iso' => 'PAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Quezon', 'iso' => 'QUE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Quirino', 'iso' => 'QUI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Rizal', 'iso' => 'RIZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Romblon', 'iso' => 'ROM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Samar', 'iso' => 'SAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Sarangani', 'iso' => 'SAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Siquijor', 'iso' => 'SIQ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Sorsogon', 'iso' => 'SOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Southern Leyte', 'iso' => 'SLE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Sultan Kudarat', 'iso' => 'SUK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Sulu', 'iso' => 'SUL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Surigao del Norte', 'iso' => 'SUR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Surigao del Sur', 'iso' => 'SDS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Tarlac', 'iso' => 'TAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Tawi-Tawi', 'iso' => 'TAW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Zambales', 'iso' => 'ZAM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Zamboanga del Norte', 'iso' => 'ZDN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Zamboanga del Sur', 'iso' => 'ZDS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 163, 'name' => 'Zamboanga Sibugay', 'iso' => 'ZSI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // pakistan
            array('uuid' => getUuid(), 'country_id' => 165, 'name' => 'Azad Jammu and Kashmir', 'iso' => 'AJK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 165, 'name' => 'Balochistan', 'iso' => 'BLN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 165, 'name' => 'Federally Administered Tribal Areas (FATA)', 'iso' => 'FATA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 165, 'name' => 'Gilgit-Baltistan', 'iso' => 'GB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 165, 'name' => 'Khyber Pakhtunkhwa (KPK)', 'iso' => 'KPK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 165, 'name' => 'Punjab', 'iso' => 'PB', 'status' => $statusActive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 165, 'name' => 'Sindh', 'iso' => 'SD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // saint pierre and miquelon
            array('uuid' => getUuid(), 'country_id' => 166, 'name' => 'Saint Pierre', 'iso' => 'sp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 166, 'name' => 'Miquelon', 'iso' => 'mi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // pitcairn
            array('uuid' => getUuid(), 'country_id' => 167, 'name' => 'Adamstown', 'iso' => 'ad', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // puerto rico
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Aguas Buenas', 'iso' => 'ag', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Aibonito', 'iso' => 'ai', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Anasco', 'iso' => 'an', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Aranjuez', 'iso' => 'ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Arroyo', 'iso' => 'ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Barceloneta', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Barranquitas', 'iso' => 'baq', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Bayamon', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Cabo Rojo', 'iso' => 'cr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Caguas', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Camuy', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Canovanas', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Carolina', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Cataño', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Ceiba', 'iso' => 'ce', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Ciales', 'iso' => 'ci', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Cidra', 'iso' => 'ci', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Coamo', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 168, 'name' => 'Comerio', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // Continue adding more municipalities for Puerto Rico here...

            // portugal
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Aveiro', 'iso' => 'av', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Beja', 'iso' => 'bj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Braga', 'iso' => 'br', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Bragança', 'iso' => 'bg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Castelo Branco', 'iso' => 'cb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Coimbra', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Évora', 'iso' => 'ev', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Faro', 'iso' => 'fa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Guarda', 'iso' => 'gu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Leiria', 'iso' => 'le', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Lisboa', 'iso' => 'li', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Madeira', 'iso' => 'md', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Marinha Grande', 'iso' => 'mg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Portalegre', 'iso' => 'po', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Porto', 'iso' => 'po', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Santarém', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Setúbal', 'iso' => 'se', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Viana do Castelo', 'iso' => 'vc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Vila Real', 'iso' => 'vr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 169, 'name' => 'Viseu', 'iso' => 'vi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // palau
            array('uuid' => getUuid(), 'country_id' => 170, 'name' => 'Babeldaob', 'iso' => 'bb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 170, 'name' => 'Koror', 'iso' => 'ko', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 170, 'name' => 'Peleliu', 'iso' => 'pe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 170, 'name' => 'Angaur', 'iso' => 'an', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 170, 'name' => 'Sonsorol', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // paraguay
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Alto Paraná', 'iso' => 'ap', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Amambay', 'iso' => 'am', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Boquerón', 'iso' => 'bo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Caaguazú', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Caazapá', 'iso' => 'cz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Central', 'iso' => 'ce', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Concepción', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Cordillera', 'iso' => 'cd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Guairá', 'iso' => 'gu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Itapúa', 'iso' => 'it', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Misiones', 'iso' => 'mi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Ñeembucú', 'iso' => 'ne', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Paraguarí', 'iso' => 'pa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'Presidente Hayes', 'iso' => 'ph', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 171, 'name' => 'San Pedro', 'iso' => 'sp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // qatar
            array('uuid' => getUuid(), 'country_id' => 172, 'name' => 'Ad Dawhah', 'iso' => 'da', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 172, 'name' => 'Al Daayen', 'iso' => 'dd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 172, 'name' => 'Al Khor', 'iso' => 'kh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 172, 'name' => 'Al Shahaniya', 'iso' => 'sh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 172, 'name' => 'Al Wakrah', 'iso' => 'aw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 172, 'name' => 'Ar Rayyan', 'iso' => 'ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 172, 'name' => 'Umm Salal', 'iso' => 'us', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // romania
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Alba', 'iso' => 'ab', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Arad', 'iso' => 'ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Arges', 'iso' => 'ag', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Bacau', 'iso' => 'bc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Bihor', 'iso' => 'bh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Bistrita-Nasaud', 'iso' => 'bn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Botosani', 'iso' => 'bs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Braila', 'iso' => 'br', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Brasov', 'iso' => 'bv', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Bucuresti', 'iso' => 'b', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Buzau', 'iso' => 'bz', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Caras-Severin', 'iso' => 'cs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Calarasi', 'iso' => 'cl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Cluj', 'iso' => 'cj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Constanta', 'iso' => 'cs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Covasna', 'iso' => 'cv', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Dambovita', 'iso' => 'db', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Dolj', 'iso' => 'dj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Galati', 'iso' => 'gl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Giurgiu', 'iso' => 'gr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Gorj', 'iso' => 'gj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Harghita', 'iso' => 'hr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Hunedoara', 'iso' => 'hd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Ialomita', 'iso' => 'il', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Iasi', 'iso' => 'is', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Ilfov', 'iso' => 'if', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Maramures', 'iso' => 'mm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Mehedinti', 'iso' => 'mh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Mures', 'iso' => 'ms', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Neamt', 'iso' => 'nt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Olt', 'iso' => 'ot', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Prahova', 'iso' => 'ph', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Satu Mare', 'iso' => 'sm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Salaj', 'iso' => 'sj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Sibiu', 'iso' => 'sb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Suceava', 'iso' => 'sv', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Teleorman', 'iso' => 'tr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Timis', 'iso' => 'tm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Tulcea', 'iso' => 'tl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Vaslui', 'iso' => 'vs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Valcea', 'iso' => 'vl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 173, 'name' => 'Vrancea', 'iso' => 'vr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // serbia
            array('uuid' => getUuid(), 'country_id' => 174, 'name' => 'Vojvodina', 'iso' => 'vo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 174, 'name' => 'Belgrade', 'iso' => 'bg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 174, 'name' => 'Central Serbia', 'iso' => 'cs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // russian federation
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Central Federal District', 'iso' => 'cf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Far Eastern Federal District', 'iso' => 'fe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Kuban', 'iso' => 'ku', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'North Caucasian Federal District', 'iso' => 'nc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Northwestern Federal District', 'iso' => 'nw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Siberian Federal District', 'iso' => 'si', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Southern Federal District', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Ural Federal District', 'iso' => 'ur', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Volga Federal District', 'iso' => 'vo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 175, 'name' => 'Vostok Federal District', 'iso' => 'vs', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // rwanda
            array('uuid' => getUuid(), 'country_id' => 176, 'name' => 'Eastern Province', 'iso' => 'ep', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 176, 'name' => 'Kigali City', 'iso' => 'kc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 176, 'name' => 'Northern Province', 'iso' => 'np', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 176, 'name' => 'Western Province', 'iso' => 'wp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 176, 'name' => 'Southern Province', 'iso' => 'sp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // solomon islands
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Riyadh', 'iso' => 'riyadh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Makkah', 'iso' => 'makkah', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Eastern Province', 'iso' => 'ep', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Madinah', 'iso' => 'madinah', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Asir', 'iso' => 'asir', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Qassim', 'iso' => 'qassim', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Tabuk', 'iso' => 'tabuk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Hail', 'iso' => 'hail', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Northern Borders', 'iso' => 'northern_borders', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Jizan', 'iso' => 'jizan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Najran', 'iso' => 'najran', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Al-Bahah', 'iso' => 'al_bahah', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 177, 'name' => 'Al-Jouf', 'iso' => 'al_jouf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // seychelles
            array('uuid' => getUuid(), 'country_id' => 178, 'name' => 'Mahé', 'iso' => 'mahe', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 178, 'name' => 'Praslin', 'iso' => 'praslin', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 178, 'name' => 'La Digue', 'iso' => 'la_digue', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 178, 'name' => 'Silhouette', 'iso' => 'silhouette', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // sudan
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'Khartoum', 'iso' => 'khartoum', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'Blue Nile', 'iso' => 'blue_nile', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'White Nile', 'iso' => 'white_nile', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'Darfur', 'iso' => 'darfur', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'Kordofan', 'iso' => 'kordofan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'Northern', 'iso' => 'northern', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'Eastern', 'iso' => 'eastern', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'Sennar', 'iso' => 'sennar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 179, 'name' => 'South Kordofan', 'iso' => 'south_kordofan', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // sweden
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Stockholm', 'iso' => 'stockholm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Västra Götaland', 'iso' => 'vastra_gotaland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Skåne', 'iso' => 'skane', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Östergötland', 'iso' => 'ostergotland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Jönköping', 'iso' => 'jonkoping', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Halland', 'iso' => 'halland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Uppsala', 'iso' => 'uppsala', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Värmland', 'iso' => 'varmland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Dalarna', 'iso' => 'dalarna', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Gävleborg', 'iso' => 'gavleborg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Västernorrland', 'iso' => 'vasternorrland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Jämtland', 'iso' => 'jamtland', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Västerbotten', 'iso' => 'vasterbotten', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 180, 'name' => 'Norrbotten', 'iso' => 'norrbotten', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // singapore
            array('uuid' => getUuid(), 'country_id' => 181, 'name' => 'Central Region', 'iso' => 'central_region', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 181, 'name' => 'North Region', 'iso' => 'north_region', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 181, 'name' => 'North-East Region', 'iso' => 'north_east_region', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 181, 'name' => 'West Region', 'iso' => 'west_region', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 181, 'name' => 'East Region', 'iso' => 'east_region', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // saint helena
            array('uuid' => getUuid(), 'country_id' => 182, 'name' => 'Saint Helena', 'iso' => 'sh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 182, 'name' => 'Ascension Island', 'iso' => 'ai', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 182, 'name' => 'Tristan da Cunha', 'iso' => 'tdc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // slovenia
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Slovenia', 'iso' => 'si', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Pomurska', 'iso' => 'pom', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Podravska', 'iso' => 'pod', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Osrednjeslovenska', 'iso' => 'os', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Osrednjeslovenska', 'iso' => 'os', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Jugovzhodna Slovenija', 'iso' => 'jug', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Jugovzhodna Slovenija', 'iso' => 'jug', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Osrednjeslovenska', 'iso' => 'os', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 183, 'name' => 'Pomurska', 'iso' => 'pom', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // slovakia
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Slovakia', 'iso' => 'sk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Bratislavský kraj', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Trnavský kraj', 'iso' => 'tc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Trenčiansky kraj', 'iso' => 'tn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Nitriansky kraj', 'iso' => 'ni', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Žilinský kraj', 'iso' => 'zi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Prešovský kraj', 'iso' => 'po', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 184, 'name' => 'Košický kraj', 'iso' => 'ke', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // sierra leone
            array('uuid' => getUuid(), 'country_id' => 185, 'name' => 'Sierra Leone', 'iso' => 'sl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 185, 'name' => 'Western Area', 'iso' => 'we', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 185, 'name' => 'Northern Province', 'iso' => 'np', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 185, 'name' => 'Southern Province', 'iso' => 'sp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 185, 'name' => 'Eastern Province', 'iso' => 'ep', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // san marino
            array('uuid' => getUuid(), 'country_id' => 186, 'name' => 'San Marino', 'iso' => 'sm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 186, 'name' => 'San Marino City', 'iso' => 'smc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // senegal
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Senegal', 'iso' => 'sn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Dakar', 'iso' => 'dk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Thies', 'iso' => 'th', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Saint-Louis', 'iso' => 'sl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Kaolack', 'iso' => 'kl', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Fatick', 'iso' => 'ft', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Ziguinchor', 'iso' => 'zg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Kolda', 'iso' => 'kd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Tambacounda', 'iso' => 'tc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Diourbel', 'iso' => 'db', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Kedougou', 'iso' => 'kd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 187, 'name' => 'Matam', 'iso' => 'mt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // somalia
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Somalia', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Awdal', 'iso' => 'aw', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Bakool', 'iso' => 'bk', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Banadir', 'iso' => 'bn', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Bari', 'iso' => 'ba', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Bay', 'iso' => 'by', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Galguduud', 'iso' => 'gg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Gedo', 'iso' => 'ge', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Hiiraan', 'iso' => 'hi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Jubbada Dhexe', 'iso' => 'jd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Jubbada Hoose', 'iso' => 'jh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Mudug', 'iso' => 'mu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Nugaal', 'iso' => 'nu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Sool', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Sanag', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Shabeellaha Dhexe', 'iso' => 'sd', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Shabeellaha Hoose', 'iso' => 'sh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Sool', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 188, 'name' => 'Woqooyi Galbeed', 'iso' => 'wg', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // suriname
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Suriname', 'iso' => 'sr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Brokopondo', 'iso' => 'br', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Commewijne', 'iso' => 'cm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Coronie', 'iso' => 'co', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Marowijne', 'iso' => 'mr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Nickerie', 'iso' => 'ni', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Para', 'iso' => 'pa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Paramaribo', 'iso' => 'pm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Saramacca', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Sipaliwini', 'iso' => 'si', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 189, 'name' => 'Wanica', 'iso' => 'wa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // sao tome and principe
            array('uuid' => getUuid(), 'country_id' => 190, 'name' => 'São Tomé', 'iso' => 'st', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 190, 'name' => 'Príncipe', 'iso' => 'pr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // el salvador
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'Ahuachapán', 'iso' => 'ah', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'Cabañas', 'iso' => 'ca', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'Chalatenango', 'iso' => 'ch', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'Cuscatlán', 'iso' => 'cu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'La Libertad', 'iso' => 'll', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'La Paz', 'iso' => 'lp', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'San Miguel', 'iso' => 'sm', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'San Salvador', 'iso' => 'ss', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'Santa Ana', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'San Vicente', 'iso' => 'sv', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'Sonsonate', 'iso' => 'so', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'La Unión', 'iso' => 'lu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 191, 'name' => 'Morazán', 'iso' => 'mo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // syrian arab republic
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Aleppo', 'iso' => 'al', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Damascus', 'iso' => 'da', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Hama', 'iso' => 'ha', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Homs', 'iso' => 'ho', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Latakia', 'iso' => 'la', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Tartus', 'iso' => 'ta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Daraa', 'iso' => 'da', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Deir ez-Zor', 'iso' => 'de', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Raqqa', 'iso' => 'ra', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Idlib', 'iso' => 'id', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Quneitra', 'iso' => 'qu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 192, 'name' => 'Rural Damascus', 'iso' => 'ru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // swaziland
            array('uuid' => getUuid(), 'country_id' => 193, 'name' => 'Hhohho', 'iso' => 'hh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 193, 'name' => 'Lubombo', 'iso' => 'lu', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 193, 'name' => 'Manzini', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 193, 'name' => 'Shiselweni', 'iso' => 'sh', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // turks and caicos islands
            array('uuid' => getUuid(), 'country_id' => 194, 'name' => 'Grand Turk', 'iso' => 'gt', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 194, 'name' => 'Providenciales', 'iso' => 'pr', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 194, 'name' => 'South Caicos', 'iso' => 'sc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 194, 'name' => 'North Caicos', 'iso' => 'nc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 194, 'name' => 'Middle Caicos', 'iso' => 'mc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 194, 'name' => 'East Caicos', 'iso' => 'ec', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 194, 'name' => 'West Caicos', 'iso' => 'wc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // chad
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Chari-Baguirmi', 'iso' => 'cb', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Guéra', 'iso' => 'ge', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Kanem', 'iso' => 'ka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Lac', 'iso' => 'lc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Logone Occidental', 'iso' => 'lo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Logone Oriental', 'iso' => 'lo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Mandoul', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Mayo-Kebbi Est', 'iso' => 'ke', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Mayo-Kebbi Ouest', 'iso' => 'ko', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Moungar', 'iso' => 'mo', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Salamat', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Sila', 'iso' => 'si', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Tandjilé', 'iso' => 'ta', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Tchad', 'iso' => 'tc', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 195, 'name' => 'Wadi Fira', 'iso' => 'wf', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // togo
            array('uuid' => getUuid(), 'country_id' => 196, 'name' => 'Centrale', 'iso' => 'ce', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 196, 'name' => 'Kara', 'iso' => 'ka', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 196, 'name' => 'Maritime', 'iso' => 'ma', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 196, 'name' => 'Savanes', 'iso' => 'sa', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 196, 'name' => 'Togo', 'iso' => 'to', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // thailand
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Bangkok', 'iso' => '10', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Chiang Mai', 'iso' => '53', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Chonburi', 'iso' => '20', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Khon Kaen', 'iso' => '40', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Nakhon Ratchasima', 'iso' => '30', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Nakhon Si Thammarat', 'iso' => '80', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Nonthaburi', 'iso' => '12', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Phuket', 'iso' => '83', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Samut Prakan', 'iso' => '11', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 197, 'name' => 'Songkhla', 'iso' => '90', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // tajikistan
            array('uuid' => getUuid(), 'country_id' => 198, 'name' => 'Dushanbe', 'iso' => 'DUS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 198, 'name' => 'Khatlon', 'iso' => 'KT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 198, 'name' => 'Sogd', 'iso' => 'SO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 198, 'name' => 'Gorno-Badakhshan', 'iso' => 'GB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 198, 'name' => 'Rogun', 'iso' => 'RO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 198, 'name' => 'Sughd', 'iso' => 'SU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // tokelau
            array('uuid' => getUuid(), 'country_id' => 199, 'name' => 'Atafu', 'iso' => 'AT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 199, 'name' => 'Nukunonu', 'iso' => 'NU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 199, 'name' => 'Fakaofo', 'iso' => 'FA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // timor-leste
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Aileu', 'iso' => 'AL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Baucau', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Bobonaro', 'iso' => 'BO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Covalima', 'iso' => 'CO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Dili', 'iso' => 'DI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Ermera', 'iso' => 'ER', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Lautém', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Liquiça', 'iso' => 'LI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Manatuto', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Manufahi', 'iso' => 'MF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 200, 'name' => 'Oecussi', 'iso' => 'OE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // turkmenistan
            array('uuid' => getUuid(), 'country_id' => 201, 'name' => 'Ahal', 'iso' => 'A', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 201, 'name' => 'Balkan', 'iso' => 'B', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 201, 'name' => 'Dashoguz', 'iso' => 'D', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 201, 'name' => 'Lebap', 'iso' => 'L', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 201, 'name' => 'Mary', 'iso' => 'M', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // tunisia
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Ariana', 'iso' => 'A', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Beja', 'iso' => 'B', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Ben Arous', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Bizerte', 'iso' => 'BZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Gabes', 'iso' => 'G', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Gafsa', 'iso' => 'GF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Jendouba', 'iso' => 'J', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Kairouan', 'iso' => 'K', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Kasserine', 'iso' => 'KS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Kebili', 'iso' => 'KB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Kef', 'iso' => 'KF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Mahdia', 'iso' => 'M', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Manouba', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Medenine', 'iso' => 'ME', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Monastir', 'iso' => 'MO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Nabeul', 'iso' => 'N', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Sfax', 'iso' => 'SF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Sidi Bouzid', 'iso' => 'SB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Siliana', 'iso' => 'SI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Sousse', 'iso' => 'SO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Tataouine', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Tozeur', 'iso' => 'TO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 202, 'name' => 'Tunis', 'iso' => 'TN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // tonga
            array('uuid' => getUuid(), 'country_id' => 203, 'name' => 'Tongatapu', 'iso' => 'TP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 203, 'name' => 'Ha’apai', 'iso' => 'HP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 203, 'name' => 'Vava’u', 'iso' => 'VV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 203, 'name' => 'Eua', 'iso' => 'EA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 203, 'name' => 'Niuas', 'iso' => 'NU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // turkey
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Adana', 'iso' => '01', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Adıyaman', 'iso' => '02', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Afyonkarahisar', 'iso' => '03', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Ağrı', 'iso' => '04', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Amasya', 'iso' => '05', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Ankara', 'iso' => '06', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Antalya', 'iso' => '07', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Artvin', 'iso' => '08', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Aydın', 'iso' => '09', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Balıkesir', 'iso' => '10', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Bilecik', 'iso' => '11', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Bingöl', 'iso' => '12', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Bitlis', 'iso' => '13', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Bolu', 'iso' => '14', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Burdur', 'iso' => '15', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Bursa', 'iso' => '16', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Çanakkale', 'iso' => '17', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Çorum', 'iso' => '18', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Denizli', 'iso' => '19', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Diyarbakır', 'iso' => '20', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Edirne', 'iso' => '21', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Elazığ', 'iso' => '22', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Erzincan', 'iso' => '23', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Erzurum', 'iso' => '24', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Eskişehir', 'iso' => '26', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Gaziantep', 'iso' => '27', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Giresun', 'iso' => '28', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Gümüşhane', 'iso' => '29', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Hakkari', 'iso' => '30', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Hatay', 'iso' => '31', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Isparta', 'iso' => '32', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'İstanbul', 'iso' => '34', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'İzmir', 'iso' => '35', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Kahramanmaraş', 'iso' => '46', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Karabük', 'iso' => '78', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Karaman', 'iso' => '70', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Kastamonu', 'iso' => '37', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Kayseri', 'iso' => '38', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Kırıkkale', 'iso' => '71', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Kırklareli', 'iso' => '39', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Kocaeli', 'iso' => '41', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Konya', 'iso' => '42', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Kütahya', 'iso' => '43', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Malatya', 'iso' => '44', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Manisa', 'iso' => '45', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Mardin', 'iso' => '47', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Mersin', 'iso' => '33', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Muğla', 'iso' => '48', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Muş', 'iso' => '49', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Nevşehir', 'iso' => '50', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Niğde', 'iso' => '51', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Ordu', 'iso' => '52', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Osmaniye', 'iso' => '80', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Rize', 'iso' => '53', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Sakarya', 'iso' => '54', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Samsun', 'iso' => '55', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Şanlıurfa', 'iso' => '63', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Siirt', 'iso' => '56', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Sinop', 'iso' => '57', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Sivas', 'iso' => '58', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Tekirdağ', 'iso' => '59', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Tokat', 'iso' => '60', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Trabzon', 'iso' => '61', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Tunceli', 'iso' => '62', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Uşak', 'iso' => '64', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Van', 'iso' => '65', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Yalova', 'iso' => '77', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Yozgat', 'iso' => '66', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 204, 'name' => 'Zonguldak', 'iso' => '67', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // trinidad and tobago
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Port of Spain', 'iso' => '01', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'San Fernando', 'iso' => '02', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Scarborough', 'iso' => '03', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Chaguanas', 'iso' => '04', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Arima', 'iso' => '05', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Point Fortin', 'iso' => '06', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Tunapuna', 'iso' => '07', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Diego Martin', 'iso' => '08', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Siparia', 'iso' => '09', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Mayaro', 'iso' => '10', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Couva', 'iso' => '11', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Laventille', 'iso' => '12', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Moriah', 'iso' => '13', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 205, 'name' => 'Pointe-à-Pierre', 'iso' => '14', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // tuvalu
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Funafuti', 'iso' => '01', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Nanumea', 'iso' => '02', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Niutao', 'iso' => '03', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Nui', 'iso' => '04', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Vaitupu', 'iso' => '05', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Nanumaga', 'iso' => '06', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Motufoua', 'iso' => '07', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 206, 'name' => 'Fongafale', 'iso' => '08', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // taiwan
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Taipei City', 'iso' => 'TPE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Kaohsiung City', 'iso' => 'KHH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Taichung City', 'iso' => 'TXG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Tainan City', 'iso' => 'TNN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'New Taipei City', 'iso' => 'NWT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Keelung City', 'iso' => 'KEE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Hsinchu City', 'iso' => 'HSC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Chiayi City', 'iso' => 'CYI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Hualien County', 'iso' => 'HLQ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Miaoli County', 'iso' => 'MIA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Changhua County', 'iso' => 'CHA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Pingtung County', 'iso' => 'PTG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Yilan County', 'iso' => 'YIL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Chiayi County', 'iso' => 'CHY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Nantou County', 'iso' => 'NAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Taitung County', 'iso' => 'TTT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Penghu County', 'iso' => 'PEN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Kinmen County', 'iso' => 'KIN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 207, 'name' => 'Lienchiang County', 'iso' => 'LIE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // tanzania, united republic of
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Dar es Salaam', 'iso' => 'DAR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Dodoma', 'iso' => 'DOD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Arusha', 'iso' => 'ARU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Mbeya', 'iso' => 'MBE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Mwanza', 'iso' => 'MWZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Zanzibar', 'iso' => 'ZAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Shinyanga', 'iso' => 'SHY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Kilimanjaro', 'iso' => 'KIL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Tanga', 'iso' => 'TAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Rukwa', 'iso' => 'RUK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Kagera', 'iso' => 'KAG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Manyara', 'iso' => 'MAN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Morogoro', 'iso' => 'MOR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Simiyu', 'iso' => 'SIM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Mtwara', 'iso' => 'MTW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Lindi', 'iso' => 'LIN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Katavi', 'iso' => 'KAT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Ruvuma', 'iso' => 'RUV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Geita', 'iso' => 'GEI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 208, 'name' => 'Njombe', 'iso' => 'NJO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // ukrain
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Cherkasy', 'iso' => 'CK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Chernihiv', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Chernivtsi', 'iso' => 'CV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Crimea', 'iso' => 'CR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Dnipropetrovsk', 'iso' => 'DP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Donetsk', 'iso' => 'DO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Ivano-Frankivsk', 'iso' => 'IF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Kharkiv', 'iso' => 'KH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Kherson', 'iso' => 'KS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Kiev', 'iso' => 'KV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Kirovohrad', 'iso' => 'KI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Luhansk', 'iso' => 'LU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Lviv', 'iso' => 'LV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Mykolaiv', 'iso' => 'MK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Odessa', 'iso' => 'OD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Poltava', 'iso' => 'PL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Rivne', 'iso' => 'RV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Sumy', 'iso' => 'SU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Ternopil', 'iso' => 'TE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Vinnytsia', 'iso' => 'VN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Volyn', 'iso' => 'VO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Zakarpattia', 'iso' => 'ZA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Zaporizhzhia', 'iso' => 'ZA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 209, 'name' => 'Zhytomyr', 'iso' => 'ZH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // uganda
            array('uuid' => getUuid(), 'country_id' => 210, 'name' => 'Central', 'iso' => 'CE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 210, 'name' => 'Eastern', 'iso' => 'EA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 210, 'name' => 'Kampala', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 210, 'name' => 'Western', 'iso' => 'WE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 210, 'name' => 'Northern', 'iso' => 'NO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // united states
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Alabama', 'iso' => 'AL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Alaska', 'iso' => 'AK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Arizona', 'iso' => 'AZ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Arkansas', 'iso' => 'AR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'California', 'iso' => 'CA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Colorado', 'iso' => 'CO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Connecticut', 'iso' => 'CT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Delaware', 'iso' => 'DE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Florida', 'iso' => 'FL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Georgia', 'iso' => 'GA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Hawaii', 'iso' => 'HI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Idaho', 'iso' => 'ID', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Illinois', 'iso' => 'IL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Indiana', 'iso' => 'IN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Iowa', 'iso' => 'IA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Kansas', 'iso' => 'KS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Kentucky', 'iso' => 'KY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Louisiana', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Maine', 'iso' => 'ME', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Maryland', 'iso' => 'MD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Massachusetts', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Michigan', 'iso' => 'MI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Minnesota', 'iso' => 'MN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Mississippi', 'iso' => 'MS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Missouri', 'iso' => 'MO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Montana', 'iso' => 'MT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Nebraska', 'iso' => 'NE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Nevada', 'iso' => 'NV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'New Hampshire', 'iso' => 'NH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'New Jersey', 'iso' => 'NJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'New Mexico', 'iso' => 'NM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'New York', 'iso' => 'NY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'North Carolina', 'iso' => 'NC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'North Dakota', 'iso' => 'ND', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Ohio', 'iso' => 'OH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Oklahoma', 'iso' => 'OK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Oregon', 'iso' => 'OR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Pennsylvania', 'iso' => 'PA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Rhode Island', 'iso' => 'RI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'South Carolina', 'iso' => 'SC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'South Dakota', 'iso' => 'SD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Tennessee', 'iso' => 'TN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Texas', 'iso' => 'TX', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Utah', 'iso' => 'UT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Vermont', 'iso' => 'VT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Virginia', 'iso' => 'VA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Washington', 'iso' => 'WA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'West Virginia', 'iso' => 'WV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Wisconsin', 'iso' => 'WI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 211, 'name' => 'Wyoming', 'iso' => 'WY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // uruguay
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Artigas', 'iso' => 'AR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Canelones', 'iso' => 'CA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Cerro Largo', 'iso' => 'CL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Colonia', 'iso' => 'CO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Durazno', 'iso' => 'DU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Flores', 'iso' => 'FS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Florida', 'iso' => 'FD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Lavalleja', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Maldonado', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Montevideo', 'iso' => 'MO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Paysandú', 'iso' => 'PA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Rio Negro', 'iso' => 'RN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Rivera', 'iso' => 'RV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Rocha', 'iso' => 'RO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Salto', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'San José', 'iso' => 'SJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Soriano', 'iso' => 'SO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Tacuarembó', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 212, 'name' => 'Treinta y Tres', 'iso' => 'TT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // uzbekistan|
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Andijan', 'iso' => 'AN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Bukhara', 'iso' => 'BU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Fergana', 'iso' => 'FE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Jizzakh', 'iso' => 'JI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Kashkadarya', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Khorezm', 'iso' => 'KH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Namangan', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Navoiy', 'iso' => 'NV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Samarkand', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Sirdaryo', 'iso' => 'SI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Surxondaryo', 'iso' => 'SU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Tashkent', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 213, 'name' => 'Tashkent City', 'iso' => 'TC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // holy see (vatican city state)
            array('uuid' => getUuid(), 'country_id' => 214, 'name' => 'Vatican City', 'iso' => 'VA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            // saint vincent and the grenadines
            array('uuid' => getUuid(), 'country_id' => 215, 'name' => 'Saint Vincent and the Grenadines', 'iso' => 'VC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // venezuela
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Amazonas', 'iso' => 'AM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Anzoátegui', 'iso' => 'A', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Apure', 'iso' => 'Ap', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Aragua', 'iso' => 'Ar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Barinas', 'iso' => 'B', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Bolívar', 'iso' => 'BOL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Carabobo', 'iso' => 'C', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Cojedes', 'iso' => 'Coj', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Delta Amacuro', 'iso' => 'D', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Distrito Capital', 'iso' => 'DC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Falcón', 'iso' => 'F', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Guárico', 'iso' => 'G', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Lara', 'iso' => 'L', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Mérida', 'iso' => 'M', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Miranda', 'iso' => 'Mi', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Monagas', 'iso' => 'Mon', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Nueva Esparta', 'iso' => 'NE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Portuguesa', 'iso' => 'P', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Sucre', 'iso' => 'S', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Táchira', 'iso' => 'T', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Trujillo', 'iso' => 'Tru', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Vargas', 'iso' => 'V', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Yaracuy', 'iso' => 'Yar', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 216, 'name' => 'Zulia', 'iso' => 'Z', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // virgin islands
            array('uuid' => getUuid(), 'country_id' => 217, 'name' => 'Saint Croix', 'iso' => 'STX', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 217, 'name' => 'Saint John', 'iso' => 'STJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 217, 'name' => 'Saint Thomas', 'iso' => 'STT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // virgin islands, U.S
            array('uuid' => getUuid(), 'country_id' => 218, 'name' => 'Saint Croix', 'iso' => 'STX', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 218, 'name' => 'Saint John', 'iso' => 'STJ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 218, 'name' => 'Saint Thomas', 'iso' => 'STT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 218, 'name' => 'Water Island', 'iso' => 'WI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // viet nam
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'An Giang', 'iso' => 'AG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Bac Giang', 'iso' => 'BG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Bac Kan', 'iso' => 'BK', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Bac Lieu', 'iso' => 'BL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Bac Ninh', 'iso' => 'BN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ben Tre', 'iso' => 'BT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Binh Duong', 'iso' => 'BD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Binh Dinh', 'iso' => 'BD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Binh Phuoc', 'iso' => 'BP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Binh Thuan', 'iso' => 'BT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Cao Bang', 'iso' => 'CB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Da Nang', 'iso' => 'DN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Dak Lak', 'iso' => 'DL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Dak Nong', 'iso' => 'DN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Dong Nai', 'iso' => 'DN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Dong Thap', 'iso' => 'DT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Gia Lai', 'iso' => 'GL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ha Giang', 'iso' => 'HG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ha Nam', 'iso' => 'HN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ha Noi', 'iso' => 'HN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ha Tinh', 'iso' => 'HT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Hoa Binh', 'iso' => 'HB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Hau Giang', 'iso' => 'HG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ho Chi Minh City', 'iso' => 'HCM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Hòa Bình', 'iso' => 'HB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Khanh Hoa', 'iso' => 'KH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Kien Giang', 'iso' => 'KG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Kon Tum', 'iso' => 'KT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Lai Chau', 'iso' => 'LC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Lao Cai', 'iso' => 'LC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Lang Son', 'iso' => 'LS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Lao Cai', 'iso' => 'LC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Long An', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Nam Dinh', 'iso' => 'ND', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Nghe An', 'iso' => 'NA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ninh Binh', 'iso' => 'NB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Ninh Thuận', 'iso' => 'NT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Phu Tho', 'iso' => 'PT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Phu Yen', 'iso' => 'PY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Quang Binh', 'iso' => 'QB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Quang Nam', 'iso' => 'QN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Quang Ngai', 'iso' => 'QG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Quang Ninh', 'iso' => 'QN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Quảng Trị', 'iso' => 'QT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Soc Trang', 'iso' => 'ST', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Son La', 'iso' => 'SL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Tay Ninh', 'iso' => 'TN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Thai Nguyen', 'iso' => 'TN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Thanh Hoa', 'iso' => 'TH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Tien Giang', 'iso' => 'TG', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Tuyen Quang', 'iso' => 'TQ', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Vinh Long', 'iso' => 'VL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Vinh Phuc', 'iso' => 'VP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 219, 'name' => 'Yen Bai', 'iso' => 'YB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // vanuatu
            array('uuid' => getUuid(), 'country_id' => 220, 'name' => 'Malampa', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 220, 'name' => 'Penama', 'iso' => 'PE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 220, 'name' => 'Sanma', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 220, 'name' => 'Shefa', 'iso' => 'SH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 220, 'name' => 'Tafea', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 220, 'name' => 'Torba', 'iso' => 'TO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // wallis and futuna
            array('uuid' => getUuid(), 'country_id' => 221, 'name' => 'Alo', 'iso' => 'AL', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 221, 'name' => 'Sigave', 'iso' => 'SI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 221, 'name' => 'Wallis', 'iso' => 'WA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // samoa
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Aiga-i-le-Tai', 'iso' => 'AT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Atua', 'iso' => 'AT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Fa\'asaleleaga', 'iso' => 'FS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Gaga\'emauga', 'iso' => 'GE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Gagaifomauga', 'iso' => 'GF', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Palauli', 'iso' => 'PA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Satupa\'itea', 'iso' => 'ST', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 222, 'name' => 'Tuamasaga', 'iso' => 'TU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // kosovo
            array('uuid' => getUuid(), 'country_id' => 223, 'name' => 'District of Pristina', 'iso' => '01', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 223, 'name' => 'District of Peć', 'iso' => '02', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 223, 'name' => 'District of Gjakova', 'iso' => '03', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 223, 'name' => 'District of Mitrovica', 'iso' => '04', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 223, 'name' => 'District of Novi Pazar', 'iso' => '05', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // yemen
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Aden', 'iso' => 'AD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Abyan', 'iso' => 'AB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Al Bayda', 'iso' => 'BA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Al Hudaydah', 'iso' => 'HD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Al Jawf', 'iso' => 'JA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Al Mahrah', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Al-Mahwit', 'iso' => 'MW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Amran', 'iso' => 'AM', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Dhamar', 'iso' => 'DH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Hadramaut', 'iso' => 'HD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Ibb', 'iso' => 'IB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Lahij', 'iso' => 'LA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Marib', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Riyadh', 'iso' => 'RY', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Sa’dah', 'iso' => 'SD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Sana’a', 'iso' => 'SN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Shabwah', 'iso' => 'SH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 224, 'name' => 'Taiz', 'iso' => 'TA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // mayotte
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Bandrele', 'iso' => 'BD', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Chiconi', 'iso' => 'CH', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Dembeni', 'iso' => 'DE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Kani-Keli', 'iso' => 'KA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Mramadoudou', 'iso' => 'MR', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Pamandzi', 'iso' => 'PA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Sada', 'iso' => 'SA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 225, 'name' => 'Tsingoni', 'iso' => 'TS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // south africa
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'Eastern Cape', 'iso' => 'EC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'Free State', 'iso' => 'FS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'Gauteng', 'iso' => 'GT', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'KwaZulu-Natal', 'iso' => 'KZN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'Limpopo', 'iso' => 'LP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'Mpumalanga', 'iso' => 'MP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'Northern Cape', 'iso' => 'NC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'North West', 'iso' => 'NW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 226, 'name' => 'Western Cape', 'iso' => 'WC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // zambia
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Central', 'iso' => 'CE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Copperbelt', 'iso' => 'CB', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Eastern', 'iso' => 'EA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Luapula', 'iso' => 'LP', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Lusaka', 'iso' => 'LS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Muchinga', 'iso' => 'MU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Northern', 'iso' => 'NO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'North-Western', 'iso' => 'NW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Southern', 'iso' => 'SO', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 227, 'name' => 'Western', 'iso' => 'WE', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

            // zimbabwe
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Bulawayo', 'iso' => 'BU', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Harare', 'iso' => 'HA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Manicaland', 'iso' => 'MA', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Mashonaland Central', 'iso' => 'MC', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Mashonaland East', 'iso' => 'ME', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Mashonaland West', 'iso' => 'MW', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Masvingo', 'iso' => 'MV', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Midlands', 'iso' => 'MI', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Matabeleland North', 'iso' => 'MN', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),
            array('uuid' => getUuid(), 'country_id' => 228, 'name' => 'Matabeleland South', 'iso' => 'MS', 'status' => $statusInactive, 'created_at' => $now, 'updated_at' => null),

        ];

        State::insert($states);
    }
}
