<?php

namespace Database\Seeders;

use App\Models\SystemSetting;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class SystemSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        SystemSetting::truncate();
        Schema::enableForeignKeyConstraints();

        $now = now();

        $settings = [
            [
                'uuid' => getUuid(),
                'key' => 'mail_host',
                'value' => 'mail.revdev.it',
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'mail_port',
                'value' => '465',
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'mail_username',
                'value' => 'revelop@revdev.it',
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'mail_password',
                'value' => '1^{{r1b24$6)',
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'mail_encryption',
                'value' => 'TLS',
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'mail_from_email',
                'value' => 'revelop@revdev.it',
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'mail_from_name',
                'value' => 'Easy RSA',
                'created_at' => $now,
                'updated_at' => null,
            ],
            [
                'uuid' => getUuid(),
                'key' => 'booking_overdue_threshold_days',
                'value' => '1',
                'created_at' => $now,
                'updated_at' => null,
            ],
        ];

        SystemSetting::insert($settings);
    }
}
