<?php

namespace Database\Seeders;

use App\Models\Term;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class TermSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        Term::truncate();
        Schema::enableForeignKeyConstraints();

        $dummyText = [
            'long' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam a neque augue. Fusce rhoncus sapien et commodo malesuada. Curabitur laoreet ligula magna, aliquet egestas ipsum aliquet ac. Fusce non ipsum ut odio vehicula lacinia. Integer tempor mauris ut ullamcorper ultrices. Duis dictum purus ac augue pellentesque efficitur. Sed sit amet pretium mi. Nullam gravida sem eget dolor sodales, non ultrices nulla facilisis. Pellentesque non diam tortor.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam a neque augue. Fusce rhoncus sapien et commodo malesuada. Curabitur laoreet ligula magna, aliquet egestas ipsum aliquet ac. Fusce non ipsum ut odio vehicula lacinia. Integer tempor mauris ut ullamcorper ultrices. Duis dictum purus ac augue pellentesque efficitur. Sed sit amet pretium mi. Nullam gravida sem eget dolor sodales, non ultrices nulla facilisis. Pellentesque non diam tortor.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam a neque augue. Fusce rhoncus sapien et commodo malesuada. Curabitur laoreet ligula magna, aliquet egestas ipsum aliquet ac. Fusce non ipsum ut odio vehicula lacinia. Integer tempor mauris ut ullamcorper ultrices. Duis dictum purus ac augue pellentesque efficitur. Sed sit amet pretium mi. Nullam gravida sem eget dolor sodales, non ultrices nulla facilisis. Pellentesque non diam tortor.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam a neque augue. Fusce rhoncus sapien et commodo malesuada. Curabitur laoreet ligula magna, aliquet egestas ipsum aliquet ac. Fusce non ipsum ut odio vehicula lacinia. Integer tempor mauris ut ullamcorper ultrices. Duis dictum purus ac augue pellentesque efficitur. Sed sit amet pretium mi. Nullam gravida sem eget dolor sodales, non ultrices nulla facilisis. Pellentesque non diam tortor.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam a neque augue. Fusce rhoncus sapien et commodo malesuada. Curabitur laoreet ligula magna, aliquet egestas ipsum aliquet ac. Fusce non ipsum ut odio vehicula lacinia. Integer tempor mauris ut ullamcorper ultrices. Duis dictum purus ac augue pellentesque efficitur. Sed sit amet pretium mi. Nullam gravida sem eget dolor sodales, non ultrices nulla facilisis. Pellentesque non diam tortor.</p>',
            'short' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam a neque augue. Fusce rhoncus sapien et commodo malesuada. Curabitur laoreet ligula magna, aliquet egestas ipsum aliquet ac. Fusce non ipsum ut odio vehicula lacinia. Integer tempor mauris ut ullamcorper ultrices. Duis dictum purus ac augue pellentesque efficitur. Sed sit amet pretium mi. Nullam gravida sem eget dolor sodales, non ultrices nulla facilisis. Pellentesque non diam tortor.',
        ];

        $now = now();

        Term::insert([
            [
                'uuid' => getUuid(),
                'position' => 'login_page',
                'content' => 'Carriage quitting securing be appetite it declared. High eyes kept so busy feel call in. Would day nor ask walls known. But preserved advantage are but and certainty earnestly enjoyment. Passage weather as up am exposed. And natural related man subject. Eagerness get situation his was delighted.',
                'is_deletable' => false,
                'created_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'position' => 'register_page',
                'content' => 'Carriage quitting securing be appetite it declared. High eyes kept so busy feel call in. Would day nor ask walls known. But preserved advantage are but and certainty earnestly enjoyment. Passage weather as up am exposed. And natural related man subject. Eagerness get situation his was delighted.',
                'is_deletable' => false,
                'created_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'position' => 'terms_of_services',
                'content' => $dummyText['long'],
                'is_deletable' => false,
                'created_at' => $now,
            ]
        ]);

        Term::insert([
            [
                'uuid' => getUuid(),
                'position' => 'guest_footer_terms_condition',
                'title' => 'Term & Condition',
                'slug' => 'terms-condition',
                'content' => $dummyText['long'],
                'is_deletable' => false,
                'created_at' => $now,
            ],
            [
                'uuid' => getUuid(),
                'position' => 'guest_footer_privacy_policy',
                'title' => 'Privacy Policy',
                'slug' => 'privacy-policy',
                'content' => $dummyText['long'],
                'is_deletable' => false,
                'created_at' => $now,
            ],
        ]);
    }
}
