<?php

namespace Database\Seeders;

use App\Enum\Status;
use App\Models\Role;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        Schema::disableForeignKeyConstraints();
        User::truncate();
        Schema::enableForeignKeyConstraints();

        $superAdmin = User::create([
            'first_name' => 'Super',
            'last_name' => 'Admin',
            'email' => 'superadmin@burdeee.com',
            'password' => '12345678',
            'status' => Status::ACTIVE,
            'email_verified_at' => now(),
        ])->assignRole(Role::SUPER_ADMIN);

        $superAdmin->settings()->create([
            'key' => 'is_dark_mode',
            'value' => false
        ]);

        $superAdmin->settings()->create([
            'key' => 'is_compact_sidebar',
            'value' => false
        ]);

        $admin = User::create([
            'first_name' => 'Admin',
            'last_name' => 'User',
            'email' => 'admin2@burdeee.com',
            'password' => '12345678',
            'status' => Status::ACTIVE,
            'email_verified_at' => now(),
        ])->assignRole(Role::ADMIN);

        $admin->settings()->create([
            'key' => 'is_dark_mode',
            'value' => false
        ]);

        $admin->settings()->create([
            'key' => 'is_compact_sidebar',
            'value' => false
        ]);
    }
}
