<?php

namespace Database\Seeders;

use App\Models\VehicleFeature;
use Illuminate\Database\Seeder;

class VehicleFeatureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $features = [
            // Safety Features
            ['name' => 'Front Airbags', 'category' => 'safety'],
            ['name' => 'Side Airbags', 'category' => 'safety'],
            ['name' => 'Curtain Airbags', 'category' => 'safety'],
            ['name' => 'ABS (Anti-lock Braking System)', 'category' => 'safety'],
            ['name' => 'Traction Control', 'category' => 'safety'],
            ['name' => 'Stability Control', 'category' => 'safety'],
            ['name' => 'Blind Spot Monitor', 'category' => 'safety'],
            ['name' => 'Lane Departure Warning', 'category' => 'safety'],
            ['name' => 'Lane Keep Assist', 'category' => 'safety'],
            ['name' => 'Forward Collision Warning', 'category' => 'safety'],
            ['name' => 'Automatic Emergency Braking', 'category' => 'safety'],
            ['name' => 'Adaptive Cruise Control', 'category' => 'safety'],
            ['name' => 'Parking Sensors', 'category' => 'safety'],
            ['name' => 'Backup Camera', 'category' => 'safety'],
            ['name' => '360-Degree Camera', 'category' => 'safety'],
            ['name' => 'Tire Pressure Monitoring', 'category' => 'safety'],

            // Comfort Features
            ['name' => 'Air Conditioning', 'category' => 'comfort'],
            ['name' => 'Climate Control (Dual Zone)', 'category' => 'comfort'],
            ['name' => 'Climate Control (Tri Zone)', 'category' => 'comfort'],
            ['name' => 'Heated Front Seats', 'category' => 'comfort'],
            ['name' => 'Heated Rear Seats', 'category' => 'comfort'],
            ['name' => 'Ventilated Front Seats', 'category' => 'comfort'],
            ['name' => 'Power Seats (Driver)', 'category' => 'comfort'],
            ['name' => 'Power Seats (Passenger)', 'category' => 'comfort'],
            ['name' => 'Memory Seats', 'category' => 'comfort'],
            ['name' => 'Leather Seats', 'category' => 'comfort'],
            ['name' => 'Sunroof', 'category' => 'comfort'],
            ['name' => 'Panoramic Sunroof', 'category' => 'comfort'],
            ['name' => 'Power Windows', 'category' => 'comfort'],
            ['name' => 'Power Mirrors', 'category' => 'comfort'],
            ['name' => 'Heated Mirrors', 'category' => 'comfort'],
            ['name' => 'Cruise Control', 'category' => 'comfort'],
            ['name' => 'Keyless Entry', 'category' => 'comfort'],
            ['name' => 'Push Button Start', 'category' => 'comfort'],
            ['name' => 'Remote Start', 'category' => 'comfort'],
            ['name' => 'Steering Wheel Controls', 'category' => 'comfort'],
            ['name' => 'Heated Steering Wheel', 'category' => 'comfort'],

            // Entertainment Features
            ['name' => 'AM/FM Radio', 'category' => 'entertainment'],
            ['name' => 'Bluetooth Connectivity', 'category' => 'entertainment'],
            ['name' => 'USB Ports', 'category' => 'entertainment'],
            ['name' => 'Auxiliary Input', 'category' => 'entertainment'],
            ['name' => 'Apple CarPlay', 'category' => 'entertainment'],
            ['name' => 'Android Auto', 'category' => 'entertainment'],
            ['name' => 'Touchscreen Display', 'category' => 'entertainment'],
            ['name' => 'Navigation System', 'category' => 'entertainment'],
            ['name' => 'Premium Sound System', 'category' => 'entertainment'],
            ['name' => 'Satellite Radio', 'category' => 'entertainment'],
            ['name' => 'WiFi Hotspot', 'category' => 'entertainment'],
            ['name' => 'Wireless Charging', 'category' => 'entertainment'],
            ['name' => 'Rear Entertainment System', 'category' => 'entertainment'],
        ];

        foreach ($features as $feature) {
            VehicleFeature::create($feature);
        }
    }
}
