<?php

return [
    'page' => [
        'title' => 'Vehicle Conditions',
        'heading' => 'Vehicle Condition Management',
    ],

    'table' => [
        'header' => [
            'name' => 'Name',
            'slug' => 'Slug',
            'description' => 'Description',
            'status' => 'Status',
            'sort_order' => 'Sort Order',
            'created' => 'Created',
            'updated' => 'Updated',
            'actions' => 'Actions',
        ],
    ],

    'modal' => [
        'header' => [
            'create' => [
                'title' => 'Add Condition',
            ],
            'edit' => [
                'title' => 'Update Condition',
            ],
            'show' => [
                'title' => 'Condition Information',
            ],
        ],
        'show' => [
            'labels' => [
                'name' => 'Name',
                'slug' => 'Slug',
                'description' => 'Description',
                'is_active' => 'Status',
                'sort_order' => 'Sort Order',
                'created' => 'Created',
                'updated' => 'Updated',
            ],
        ],
    ],

    'form' => [
        'name' => [
            'label' => 'Name',
            'placeholder' => 'Enter condition name (e.g., New, Used, Certified Pre-Owned)',
        ],
        'slug' => [
            'label' => 'Slug',
            'placeholder' => 'Auto-generated from name',
        ],
        'description' => [
            'label' => 'Description',
            'placeholder' => 'Enter condition description',
        ],
        'is_active' => [
            'label' => 'Active',
        ],
        'sort_order' => [
            'label' => 'Sort Order',
            'placeholder' => 'Enter sort order (lower numbers appear first)',
        ],
    ],

    'toast' => [
        'success' => [
            'created' => 'Condition created successfully.',
            'updated' => 'Condition updated successfully.',
            'deleted' => 'Condition deleted successfully.',
            'restored' => 'Condition restored successfully.',
        ],
        'errors' => [
            'in_use' => 'This condition cannot be deleted because it is being used by listings.',
        ],
    ],

    'validation' => [
        'name' => [
            'required' => 'The condition name is required.',
            'unique' => 'This condition name already exists.',
        ],
        'slug' => [
            'unique' => 'This slug already exists.',
        ],
    ],
];

