<?php

return [
    'page' => [
        'title' => 'Listings',
        'heading' => 'Vehicle Listing Management',
        'button' => [
            'add' => 'Add New Listing',
        ],
    ],

    'table' => [
        'header' => [
            'title' => 'Title',
            'owner' => 'Owner',
            'price' => 'Price',
            'location' => 'Location',
            'type' => 'Type',
            'condition' => 'Condition',
            'status' => 'Status',
            'created' => 'Created',
            'updated' => 'Updated',
            'actions' => 'Actions',
        ],
        'actions' => [
            'approve' => 'Approve Listing',
            'reject' => 'Reject Listing',
            'view' => 'View Details',
            'edit' => 'Edit',
            'delete' => 'Delete',
        ],
    ],

    'modal' => [
        'header' => [
            'create' => [
                'title' => 'Add New Vehicle Listing',
            ],
            'edit' => [
                'title' => 'Update Vehicle Listing',
            ],
            'show' => [
                'title' => 'Listing Information',
            ],
        ],
        'show' => [
            'labels' => [
                'title' => 'Title',
                'description' => 'Description',
                'price' => 'Price',
                'location' => 'Location',
                'condition' => 'Condition',
                'status' => 'Status',
                'owner' => 'Owner',
                'created' => 'Created',
                'updated' => 'Updated',
            ],
        ],
    ],

    'form' => [
        'title' => [
            'label' => 'Title',
            'placeholder' => 'Enter listing title',
        ],
        'description' => [
            'label' => 'Description',
            'placeholder' => 'Enter vehicle description',
        ],
        'price' => [
            'label' => 'Price',
            'placeholder' => 'Enter price',
        ],
        'location' => [
            'label' => 'Location',
            'placeholder' => 'Enter location',
        ],
        'condition' => [
            'label' => 'Condition',
            'select_option' => 'Select condition',
        ],
        'vin' => [
            'label' => 'VIN',
            'placeholder' => 'Enter 17-character VIN',
        ],
        'make' => [
            'label' => 'Make',
            'placeholder' => 'Enter vehicle make',
        ],
        'model' => [
            'label' => 'Model',
            'placeholder' => 'Enter vehicle model',
        ],
        'year' => [
            'label' => 'Year',
            'placeholder' => 'Enter vehicle year',
        ],
        'trim' => [
            'label' => 'Trim',
            'placeholder' => 'Enter trim level',
        ],
        'mileage' => [
            'label' => 'Mileage',
            'placeholder' => 'Enter mileage',
        ],
        'color' => [
            'label' => 'Color',
            'placeholder' => 'Enter color',
        ],
    ],

    'toast' => [
        'success' => [
            'created' => 'Listing created successfully. It will be reviewed by admin before being published.',
            'updated' => 'Listing updated successfully.',
            'deleted' => 'Listing deleted successfully.',
            'approved' => 'Listing approved successfully. It is now visible on the public platform.',
            'rejected' => 'Listing rejected successfully.',
        ],
        'errors' => [
            'create_failed' => 'Failed to create listing. Please try again.',
            'update_failed' => 'Failed to update listing. Please try again.',
            'delete_failed' => 'Failed to delete listing. Please try again.',
            'approve_failed' => 'Failed to approve listing. Please try again.',
            'reject_failed' => 'Failed to reject listing. Please try again.',
        ],
    ],

    'confirmable' => [
        'approve' => [
            'title' => 'Approve Listing',
            'message' => 'Are you sure you want to approve this listing? It will be visible on the public platform.',
            'button' => 'Yes, approve it!',
        ],
        'reject' => [
            'title' => 'Reject Listing',
            'message' => 'Are you sure you want to reject this listing? The dealer will be notified.',
            'button' => 'Yes, reject it!',
        ],
        'delete' => [
            'title' => 'Delete Listing',
            'message' => 'Are you sure you want to delete this listing? This action cannot be undone.',
            'button' => 'Yes, delete it!',
        ],
    ],

    'status' => [
        'pending' => 'Pending Approval',
        'active' => 'Active',
        'approved' => 'Approved',
        'rejected' => 'Rejected',
        'inactive' => 'Inactive',
    ],
];

