<?php

return [
    'page' => [
        'title' => 'User Profile',
        'heading' => 'User Profile',
    ],

    'sidebar' => [
        'dropdown' => [
            'change_photo' => 'Change Photo',
        ],

        'tabs' => [
            'account_information' => 'Account Information',
            'company_information'        => 'Company Information',
            'representative_information' => 'Authorized Representative Information',
            'financial_information'      => 'Bank & Financial Information',
            'business_information'       => 'Dealer Business Information',
            'documents_information'      => 'Additional Documents',
            'change_password' => 'Change Password',
        ],
    ],

    'modal' => [
        'header' => [
            'edit' => [
                'title' => 'Update Profile',
            ],
            'update_avatar' => [
                'title' => 'Update Avatar',
            ],
            'update_password' => [
                'title' => 'Update Password',
            ],
        ],
    ],

    'account_information' => [
        'detail' => [
            'title' => 'Account Information',
            'heading' => 'Basic information, such as your name and address, used on Easy Ambulatorio.',
            'name' => 'User Name',
            'email' => 'Email',
            'phone' => 'Phone Number',
            'gender' => 'Gender',
            'date_of_birth' => 'Date of Birth',
        ],
        'form' => [
            'first_name' => [
                'label' => 'First Name',
                'placeholder' => 'Enter first name',
            ],
            'last_name' => [
                'label' => 'Last Name',
                'placeholder' => 'Enter last name',
            ],
            'phone' => [
                'label' => 'Phone Number',
                'placeholder' => 'Enter contact phone number',
            ],
            'gender' => [
                'label' => 'Gender',
                'select_option' => 'Select gender',
            ],
            'date_of_birth' => [
                'label' => 'Date of Birth',
                'placeholder' => 'Select date of birth',
            ],
        ],

        'validation' => [
            'date_format' => [
                'date_of_birth' => 'The date of birth field must match the format yyyy-mm-dd. For example, 1990-01-20',
            ],
        ],
    ],

    'update_avatar' => [
        'form' => [
            'buttons' => [
                'choose_avatar' => 'Choose Avatar',
                'start_upload' => 'Start Upload',
            ],
        ],

        'validation' => [
            'avatar' => [
                'limit' => 'The avatar must be less than 1 MB.',
            ],
        ],
    ],

    'company_information' => [
        'title'               => 'Company Information',
        'company_name'        => 'Company Name',
        'registration_number' => 'Official Registration Number / License Number',
        'tax_number'          => 'Tax Identification Number (NTN / Tax ID)',
        'address'             => 'Company Address',
        'contact_phone'       => 'Contact Phone',
        'contact_email'       => 'Contact Email',

        'edit' => [
            'title' => 'Edit Company Information',
        ],
    ],

    'representative_information' => [
        'title'              => 'Authorized Representative Information',
        'full_name'          => 'Full Name',
        'cnic'               => 'CNIC / Passport Copy',
        'position'           => 'Position',
        'contact'            => 'Contact Information',
        'manage'             => 'Manage Representatives',
        'manage_description' => 'Add, update, or remove authorized representatives',
        'no_data'            => 'No representative information added yet.',

        'add' => [
            'title' => 'Add Representative Information',
            'button' => 'Add Representative',
        ],
        'edit' => [
            'title' => 'Edit Representative Information',
        ],
    ],

    'financial_information' => [
        'title'              => 'Bank & Financial Information',
        'bank_name'          => 'Bank Name',
        'account_holder'     => 'Account Holder Name',
        'account_number'     => 'Account Number / IBAN',
        'manage'             => 'Manage Bank Accounts',
        'manage_description' => 'Add, update, or remove bank accounts',
        'no_data'            => 'No financial information added yet.',
        'add' => [
            'title' => 'Add Financial Information',
            'button' => 'Add Bank Account',
        ],
        'edit' => [
            'title' => 'Edit Financial Information',
        ],
    ],

    'business_information' => [
        'title'       => 'Dealer Business Information',
        'operations'  => 'Dealer Operations',
        'branches'    => 'Number of Branches & Locations',
        'branch_name' => 'Branch Name',
        'website'     => 'Website / Social Media Links',
        'manage'      => 'Manage Business Info',
        'manage_description' => 'Add, update, or remove business information',
        'edit' => [
            'title' => 'Edit Business Information',
        ],
    ],

    'documents_information' => [
        'title'            => 'Additional Documents',
        'swift'            => 'SWIFT / Branch Code',
        'business_license' => 'Business License Copy',
        'tax_certificate'  => 'Tax Certificate',
        'bank_statement'   => 'Bank Statement / Verification Letter',
        'constitution'     => 'Company Constitution / Certificate',
        'view_uploaded'    => 'View Uploaded',
        'manage'           => 'Manage Documents',

        'manage_description' => 'Upload, update, or remove additional documents',
        'edit' => [
            'title' => 'Edit Additional Documents',
        ],
    ],

    'update_password' => [
        'form' => [
            'old_password' => [
                'label' => 'Old Password',
                'placeholder' => 'Enter old password',
            ],
            'new_password' => [
                'label' => 'New Password',
                'placeholder' => 'Enter new password',
            ],
            'confirm_password' => [
                'label' => 'Confirm Password',
                'placeholder' => 'Re-enter new password',
            ],
        ],

        'validation' => [
            'old_password' => [
                'incorrect' => 'The provided old password is incorrect.',
            ],
        ],
    ],

    'toast' => [
        'success' => [
            'created' => 'Information added successfully.',
            'profile_updated' => 'Profile updated successfully.',
            'avatar_updated' => 'Avatar updated successfully.',
            'password_updated' => 'Password updated successfully.',
        ],
    ],
];
