<?php

return [
    'home' => [
        'page' => [
            'title' => 'Roles',
            'heading' => 'Role Management',
            'button' => [
                'create' => 'Create Role'
            ],
            'system_role' => 'System Role',
        ],

        'text' => [
            'system_roles' => 'System Role',
        ],

        'table' => [
            'header' => [
                'name' => 'Name',
                'total_users' => 'Total Users',
                'total_permissions' => 'Total Permissions',
                'created' => 'Created',
                'updated' => 'Updated',
                'actions' => 'Actions',
            ],
        ],
    ],
    'create' => [
        'page' => [
            'title' => 'Create New Role',
            'heading' => 'Create New Role',
        ],
    ],
    'edit' => [
        'page' => [
            'title' => 'Edit Role',
            'heading' => 'Edit Role',
        ],
    ],

    'form' => [
        'name' => [
            'label' => 'Name',
            'placeholder' => 'Enter name',
        ],
        'permissions' => [
            'label' => 'All permissions',
        ],
        'messages' => [
            'system_roles' => 'The name of system roles cannot be modified.',
        ]
    ],

    'activity_log_service' => [
        'created' => 'role created',
        'updated' => 'role updated',
        'deleted' => 'role deleted',
        'restored' => 'role restored',
    ],

    'toast' => [
        'success' => [
            'deleted' => 'Role deleted successfully.',
            'restored' => 'Role restored successfully.',
        ],
        'errors' => [
            'permissions' => 'Unable to remove the role with associated permissions.',
            'users' => 'Unable to remove the role with associated users.',
            'unable_to_remove' => 'Unable to remove the role.',
            'can_not_be_delete' => 'System role cannot be deleted.',
        ],
    ],

    'flash' => [
        'success' => [
            'created' => 'Role created successfully.',
            'updated' => 'Role updated successfully.',
        ],
        'errors' => [
            'created' => 'An error occurred while creating the role.',
            'updated' => 'An error occurred while updating the role.',
        ]
    ],
];
