<?php

return [
    /*
    |--------------------------------------------------------------------------
    | System Settings Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines are the default lines which match reasons
    | that are given by the system settings.
    | You are free to modify these language lines according to your application's requirements.
    |
    */

    'page' => [
        'title' => 'System Settings',
        'heading' => 'System Settings',
        'sidebar' => [
            'mail_settings' => 'Email Settings',
            'booking_overdue_settings' => 'Overdue Discount Settings',
        ]
    ],

    'mail_settings' => [
        'page' => [
            'heading' => 'Email Settings',
            'description' => 'Specify the email provider settings to be used by the application.',
        ],

        'modal' => [
            'header' => 'Update Email Settings',
        ],

        'form' => [
            'host' => [
                'label' => 'Host',
                'placeholder' => 'Enter mail host',
            ],
            'port' => [
                'label' => 'Port',
                'placeholder' => 'Enter port',
            ],
            'username' => [
                'label' => 'Username',
                'placeholder' => 'Enter username',
            ],
            'password' => [
                'label' => 'Password',
                'placeholder' => 'Enter password',
            ],
            'from_name' => [
                'label' => 'From Name',
                'placeholder' => 'Enter from name',
            ],
            'from_email' => [
                'label' => 'From Email',
                'placeholder' => 'Enter from email',
            ],
            'encryption' => [
                'label' => 'Encryption',
                'placeholder' => 'Enter encryption',
            ],
        ],

        'show' => [
            'host' => 'Mail Host',
            'port' => 'Mail Port',
            'username' => 'Username',
            'password' => 'Password',
            'from_email' => 'From Email',
            'from_name' => 'From Name',
            'encryption' => 'Encryption',
        ],

        'toast' => [
            'success' => [
                'updated' => 'Record updated successfully',
            ],
        ],
    ],

    'booking_overdue_threshold' => [
        'page' => [
            'heading' => 'Booking Overdue Threshold Settings',
            'description' => 'Specify the number of days for which the overdue threshold will apply.',
        ],

        'modal' => [
            'header' => 'Update Booking Overdue Threshold Settings',
        ],

        'form' => [
            'days' => [
                'label' => 'Overdue Threshold',
                'placeholder' => 'Enter overdue threshold in days',
            ],
        ],

        'show' => [
            'days' => 'Overdue Threshold',
        ],

        'toast' => [
            'success' => [
                'updated' => 'Record updated successfully',
            ],
        ],

        'toggle' => [
            'days_text' => '-1 means infinite (i.e., never), 0 means immediately, and positive integers indicate the number of days',
        ],
    ],
];
