<?php

return [
    'page' => [
        'title' => 'Users',
        'heading' => 'User Management',
        'button' => [
            'invite' => 'Invite New User'
        ],
        'status' => [
            'pending' => 'Pending email verification',
            'verified' => 'Verified',
            'active' => 'Active',
            'suspended' => 'Suspended',
            'invited' => 'Invited',
        ]
    ],

    'table' => [
        'header' => [
            'name' => 'Name',
            'phone' => 'Phone',
            'status' => 'Status',
            'comments' => 'Comments',
            'created' => 'Created',
            'updated' => 'Updated',
            'actions' => 'Actions',
        ],
        'actions' => [
            'resend_invitation' => 'Resend Invitation',
            'verify_email' => 'Verify Email',
            'approve_account' => 'Approve Account',
        ],
    ],

    'modal' => [
        'header' => [
            'invite' => [
                'title' => 'Invite New User',
            ],
            'edit' => [
                'title' => 'Update User',
            ],
            'show' => [
                'title' => 'User Information',
            ],
        ],
        'show' => [
            'labels' => [
                'name' => 'Name',
                'email' => 'Email',
                'phone' => 'Phone',
                'alternative_phone' => 'Alternative Phone',
                'status' => 'Status',
                'created_at' => 'Created At',
                'updated_at' => 'Updated At',
            ],
        ],
        'button' => [
            'invite' => 'Send Invitation',
        ],
    ],

    'form' => [
        'first_name' => [
            'label' => 'First Name',
            'placeholder' => 'Enter the user\'s first name',
        ],
        'last_name' => [
            'label' => 'Last Name',
            'placeholder' => 'Enter the user\'s last name',
        ],
        'phone' => [
            'label' => 'Enter Your Phone Number',
            'placeholder' => 'Enter the user\'s phone number',
        ],
        'email' => [
            'label' => 'Email',
            'placeholder' => 'Enter the user\'s email',
        ],
        'role' => [
            'label' => 'Role',
            'select_option' => 'Select role',
        ],
        'comments' => [
            'label' => 'Comments',
            'placeholder' => 'Enter your comments here. Typically used for suspension.',
        ],
        'active' => [
            'label' => 'Active',
        ],
    ],

    'toggle' => [
        'view_comments' => 'View Comments',
    ],

    'validation' => [
        'attribute' => [
            'comments' => [
                'required_without' => 'The comments field is required when the status is suspended.',
            ],
        ],
    ],

    'toast' => [
        'success' => [
            'created' => 'User successfully created.',
            'updated' => 'User successfully updated.',
            'deleted' => 'User successfully deleted.',
            'restored' => 'User successfully restored.',
            'invited' => 'Invitation sent successfully.',
            'approved' => 'The account has been approved successfully.',
            'verified' => 'The account has been verified successfully.',
        ],
        'errors' => [
            'unable_resend_invitation' => 'Unable to resend the invitation. Try reloading the page.',
            'not_found' => 'User not found.',
        ],
    ],

    'confirmable' => [
        'resend_invitation' => [
            'title' => 'Are you sure?',
            'message' => 'Do you really want to resend the invitation email?',
            'button' => 'Yes, do it!'
        ],
        'approve' => [
            'title' => 'Are you sure?',
            'message' => 'Do you really want to approve this email?',
            'button' => 'Yes, do it!',
        ],
        'verify' => [
            'title' => 'Are you sure?',
            'message' => 'Do you really want to verify this email?',
            'button' => 'Yes, do it!',
        ],
        'button' => [
            'delete' => 'Yes, delete it',
            'cancel' => 'Cancel',
            'restore' => 'Yes, do it',
        ],
    ],

    'activity_log_service' => [
        'invited' => 'invited',
        'reinvited' => 'reinvited',
        'activated' => 'activated',
        'approved' => 'approved',
        'suspended' => 'suspended',
        'deleted' => 'archived',
        'restored' => 'was restored',
    ],
];
