$(document).ready(function () {
    loadMailSettingsView();

    $('a[href="#mail-settings-tab"]').on('click', function (event) {
        event.preventDefault(); // Prevent default anchor behavior
        $('#mail-settings-tab').html(spinner);

        loadMailSettingsView();

        $(this).addClass('active');
        $('#mail-settings-tab').addClass('show active');
    });

    $(document).on('mailsettings.updated', function (e, params) {
        const mailSettings = $('#mail-settings-tab');

        for (const key in params) {
            mailSettings.find(`#${key}`).html(params[key] ?? '<small><i>Unavailable</i></small>');
        };
    });
});

function loadMailSettingsView() {
    window.axios.get('settings/mail')
        .then((response) => {
            $('#mail-settings-tab').html(response.data);
        }).catch((error) => {
            handleAxiosError(error, "error");
        })
}
