import { createApp } from 'vue';
import { createRouter, createWebHistory } from 'vue-router';
import App from './App.vue';
import routes from './routes';
import { createApiClient } from './services/api';

const router = createRouter({
    history: createWebHistory(),
    routes,
});

// Create API client instance
const apiClient = createApiClient();

// Provide API client to all components
const app = createApp(App);
app.use(router);
app.provide('api', apiClient);

// Mount the app
app.mount('#buyer-app');

