window.isAsyncFormProcessing = false;

window.notify = function (message = "", status = "error", isToast = true) {
    status = status == "error" ? status : "success";

    if (message == "")
        message = status == "error"
            ? "Something went wrong."
            : "The action was successful.";

    let options = isToast
        ? {
            icon: status,
            title: message,
            showConfirmButton: false,
            confirmButtonColor: "#6576ff",
            toast: true,
            position: "bottom-end",
            timer: 5000,
            timerProgressBar: true,
            grow: "fullscreen",
        }
        : {
            icon: status,
            title: message,
            position: "center",
        };

    window.swal.fire(options);
}

window.handleAxiosError = function (error, form = null) {
    if (error?.response === undefined) return notify(error, "error", false);

    let response = error.response;

    if (typeof response.data == "string") {
        notify(
            response.data.replace(/<[^>]*>?/gm, ""),
            "error",
            false
        );
    } else if (
        typeof response.data.errors !== "undefined" && form !== null
    ) {
        for (let key in response.data.errors) {
            let target = form.find(`[name="${key}"]`);

            if (
                target.siblings(".invalid-feedback").length > 0
            ) {
                target.addClass("is-invalid")
                    .siblings(".invalid-feedback").text(response.data.errors[key][0]).show();
            } else if (
                target.closest(".form-control-wrap").find(".invalid-feedback").length > 0
            ) {
                target.addClass("is-invalid")
                    .closest(".form-control-wrap").find(".invalid-feedback").text(response.data.errors[key][0]).show();
            } else if (
                target.closest(".form-group").find(".invalid-feedback").length > 0
            ) {
                target.addClass("is-invalid")
                    .closest(".form-group").find(".invalid-feedback").text(response.data.errors[key][0]).show();
            } else {
                notify(response.data.errors[key][0], "error", false);
            }
        }
    } else if (typeof response.data.message !== "undefined") {
        notify(
            response.data.message.replace(/<[^>]*>?/gm, ""),
            "error",
            false
        );
    } else {
        notify(
            "Oops! it seems like something is not right.",
            "error",
            false
        );
    }
}

$(function () {
    $("a.dark-switch").on("click", function () {
        window.axios({
            url: $(this).data("url"),
            method: "post",
            data: {
                is_dark_mode: $(this).data("value"),
            },
        });
    });

    $("a#toggle-sidebar").on("click", function () {
        window.axios({
            url: $(this).data("url"),
            method: "post",
            data: {
                is_compact_sidebar: $(this).data("value"),
            },
        });
    });

    $('.select2').select2();

    setTimeout(() => {
        $('.alert-auto-hide').slideUp(300);
    }, 4000);

    // Global DataTables error handler
    $.fn.dataTable.ext.errMode = function (settings, helpPage, message) {
        // Get the jqXHR object from settings
        let jqXHR = settings.jqXHR;

        if (!jqXHR) {
            notify("Unexpected error occurred.", "error");
            return;
        }

        switch (jqXHR.status) {
            case 500:
                notify("Server Error (500). Please try again later.", "error");
                break;
            case 401:
                notify("Unauthenticated (401). Please login.", "warning");
                break;
            case 403:
                notify("Forbidden (403). You don't have access.", "error");
                break;
            case 404:
                notify("Not Found (404).", "error");
                break;
            default:
                notify("Unexpected error: " + (jqXHR.statusText || "Unknown"), "error");
        }
    };


    $(document).on("mouseenter", ".swal2-container", function () {
        window.swal.stopTimer();
    });

    $(document).on("mouseleave", ".swal2-container", function () {
        window.swal.resumeTimer();
    });

    $(document).on("init.dt", function (e, settings) {
        $('[data-bs-toggle="tooltip"]').tooltip();
    });
});

window.richTextEditor = function (id, height = 500) {
    tinymce.init({
        selector: "textarea#" + id,
        height: height,
        plugins: "code table lists",
        toolbar: "undo redo | blocks | bold italic | alignleft aligncenter alignright | indent outdent | bullist numlist | code | table",
        cleanup: true,
        promotion: false,
        branding: false,
        menubar: "edit insert format table",
    });
};
