@extends('layouts.app')

@section('title', trans('activity-logs.page.title'))

@section('content')
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">@lang('activity-logs.page.title')</h3>
            </div>
            <div class="nk-block-head-content">
                <div class="toggle-wrap nk-block-tools-toggle">
                    <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="pageMenu">
                        <em class="icon ni ni-more-v"></em>
                    </a>
                    <div class="toggle-expand-content" data-content="pageMenu">
                        <ul class="nk-block-tools g-3">
                            <li>
                                <div class="form-group">
                                    <label class="form-label">@lang('activity-logs.page.filters.date.label'): </label>
                                    <div class="form-control-wrap" style="max-width: 300px;">
                                        <div class="input-daterange date-picker-range input-group" data-date-week-start="6" data-date-today-btn="linked"
                                            data-date-format="yyyy-mm-dd">
                                            <input type="text" class="form-control" placeholder="yyyy-mm-dd" autocomplete="false" value="{{ getFirstDay('Y-m-d') }}" readonly />
                                            <div class="input-group-addon">—</div>
                                            <input type="text" class="form-control" placeholder="yyyy-mm-dd" autocomplete="false" value="{{ getLastDay('Y-m-d') }}" readonly />
                                        </div>
                                    </div>
                                </div>
                            </li>
                            <li>
                                <div class="form-group">
                                    <label class="form-label" for="log_user">@lang('activity-logs.page.filters.user.label'): </label>
                                    <select class="form-control form-control-lg select2" name="log_user" id="log_user">
                                        <option value="all" selected>@lang('activity-logs.page.filters.user.select_option')</option>
                                        @foreach ($logUsers as $logUser)
                                            <option value="{{ $logUser->user?->uuid }}">{{ $logUser->user?->full_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </li>
                            <li class="d-none">
                                <div class="form-group">
                                    <label class="form-label" for="log_module">@lang('activity-logs.page.filters.module.label'): </label>
                                    <select class="form-control form-control-lg select2" name="log_module" id="log_module">
                                        <option value="all" selected>@lang('activity-logs.page.filters.module.select_option')</option>
                                        @foreach ($modules as $module)
                                            <option value="{{ $module->module }}">{{ str_replace('_', ' ', $module->module) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </li>
                            <li class="d-none">
                                <div class="form-group">
                                    <label class="form-label" for="activity_key">@lang('activity-logs.page.filters.activity.label'): </label>
                                    <select class="form-control form-control-lg select2" name="activity_key" id="activity_key">
                                        <option value="all" selected>@lang('activity-logs.page.filters.activity.select_option')</option>
                                        @foreach ($logKeys as $logKey)
                                            <option value="{{ $logKey->activity }}">{{ str_replace('_', ' ', $logKey->activity) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-inner-group">
                <div class="card-inner position-relative card-tools-toggle table-responsive">
                    <div class="text-end mb-3">
                        <a href="javascript:void(0);" class="btn btn-sm btn-light" id="toggleColumn">
                            <em class="icon ni ni-eye"></em>
                            <span>@lang('activity-logs.page.buttons.user_agent_column.show')</span>
                        </a>
                    </div>
                    <table id="activity-logs-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                        <thead>
                            <tr class="nk-tb-item nk-tb-head">
                                <th><span class="sub-text">@lang('activity-logs.table.header.labels.user')</span></th>
                                <th><span class="sub-text">@lang('activity-logs.table.header.labels.role')</span></th>
                                <th><span class="sub-text">@lang('activity-logs.table.header.labels.module')</span></th>
                                <th><span class="sub-text">@lang('activity-logs.table.header.labels.activity')</span></th>
                                <th><span class="sub-text">@lang('activity-logs.table.header.labels.ip')</span></th>
                                <th><span class="sub-text">@lang('activity-logs.table.header.labels.user_agent')</span></th>
                                <th><span class="sub-text">@lang('activity-logs.table.header.labels.description')</span></th>
                                <th class="text-right"><span class="sub-text">@lang('activity-logs.table.header.labels.activity_performed_at')</span></th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let filterModuleSelectOption = "{{ trans('activity-logs.page.filters.module.select_option') }}"
        let filterActivitySelectOption = "{{ trans('activity-logs.page.filters.activity.select_option') }}";
        let showUserAgent = "{{ trans('activity-logs.page.buttons.user_agent_column.show') }}";
        let hideUserAgent = "{{ trans('activity-logs.page.buttons.user_agent_column.hide') }}";
    </script>

    <script src="{{ asset('assets/js/activity-logs/activity-logs.js') }}"></script>
@endpush
