<h5 class="title pb-3">@lang('buyers.modal.header.edit.title')</h5>

<form action="{{ route('buyers.update', $user->uuid) }}"
      method="post"
      async-form
      on-async-modal
      data-datatable="#users-dt">
    @csrf
    @method('put')

    <div class="row gy-4">

        <div class="col-md-6">
            <div class="custom-control custom-switch checked">
                <input type="checkbox"
                       class="custom-control-input"
                       name="status"
                       id="status"
                       value="active"
                       @checked($user->status === \App\Enum\Status::ACTIVE)>
                <label class="custom-control-label" for="status">@lang('buyers.form.active.label')</label>
            </div>
            <span class="invalid-feedback"></span>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="comments">@lang('buyers.form.comments.label')</label>
                <textarea class="form-control form-control-lg"
                          id="comments"
                          name="comments"
                          placeholder="@lang('buyers.form.comments.placeholder')">{{ $user->admin_comments }}</textarea>
                <span class="invalid-feedback"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">@lang('global.form.button.update')</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>@lang('global.form.button.cancel')</button></li>
            </ul>
        </div>

    </div>
</form>
