@extends('layouts.app')

@section('title', 'Listing Details')

@section('content')
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">Listing Details</h3>
                <p class="text-soft">{{ $listing->title }}</p>
            </div>
            <div class="nk-block-head-content">
                <div class="toggle-wrap nk-block-tools-toggle">
                    <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1" data-target="pageMenu"><em class="icon ni ni-more-v"></em></a>
                    <div class="toggle-expand-content" data-content="pageMenu">
                        <ul class="nk-block-tools g-3">
                            <li>
                                <a href="{{ route('admin.listings.edit', $listing->uuid) }}" class="btn btn-primary">
                                    <em class="icon ni ni-edit"></em>
                                    <span>Edit Listing</span>
                                </a>
                            </li>
                            <li>
                                <a href="{{ route('admin.listings.index') }}" class="btn btn-outline-light">
                                    <em class="icon ni ni-arrow-left"></em>
                                    <span>Back to Listings</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="row g-4">
            {{-- 1. Basic Information --}}
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">1. Basic Information</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Make</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->make ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Model</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->model ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Year</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->year ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Trim / Edition</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->trim ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">VIN Code</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->vin ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- 2. Technical Specifications --}}
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">2. Technical Specifications</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Engine Capacity</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->engine_capacity ?? 'N/A' }} cc</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Fuel Type</label>
                                <p class="form-control-plaintext">{{ ucfirst($listing->specification?->fuel_type ?? 'N/A') }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Transmission</label>
                                <p class="form-control-plaintext">{{ ucfirst($listing->specification?->transmission ?? 'N/A') }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Drive Type</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->drive_type ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Mileage</label>
                                <p class="form-control-plaintext">{{ number_format($listing->specification?->mileage ?? 0) }} miles</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- 3. Body and Exterior --}}
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">3. Body and Exterior</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Body Type</label>
                                <p class="form-control-plaintext">{{ ucfirst($listing->specification?->body_type ?? 'N/A') }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Exterior Color</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->exterior_color ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Interior Color</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->interior_color ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Number of Seats</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->seats ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Number of Doors</label>
                                <p class="form-control-plaintext">{{ $listing->specification?->doors ?? 'N/A' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- 4. Price and Financing --}}
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">4. Price and Financing</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Price</label>
                                <p class="form-control-plaintext">${{ number_format($listing->price, 2) }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Financing Options</label>
                                <p class="form-control-plaintext">
                                    @if ($listing->financing_options && count($listing->financing_options) > 0)
                                        {{ implode(', ', array_map('ucfirst', $listing->financing_options)) }}
                                    @else
                                        N/A
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- 5. Features and Options --}}
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">5. Features and Options</h5>
                        @if ($listing->features && $listing->features->count() > 0)
                            @php
                                $safetyFeatures = $listing->features->where('category', 'safety');
                                $comfortFeatures = $listing->features->where('category', 'comfort');
                                $entertainmentFeatures = $listing->features->where('category', 'entertainment');
                            @endphp

                            @if ($safetyFeatures->count() > 0)
                                <div class="mb-3">
                                    <strong>Safety Features:</strong>
                                    <div class="mt-2">
                                        @foreach ($safetyFeatures as $feature)
                                            <span class="badge bg-success me-1 mb-1">{{ $feature->name }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            @if ($comfortFeatures->count() > 0)
                                <div class="mb-3">
                                    <strong>Comfort Features:</strong>
                                    <div class="mt-2">
                                        @foreach ($comfortFeatures as $feature)
                                            <span class="badge bg-info me-1 mb-1">{{ $feature->name }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            @if ($entertainmentFeatures->count() > 0)
                                <div class="mb-3">
                                    <strong>Entertainment Features:</strong>
                                    <div class="mt-2">
                                        @foreach ($entertainmentFeatures as $feature)
                                            <span class="badge bg-primary me-1 mb-1">{{ $feature->name }}</span>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                        @else
                            <p class="text-muted">No features listed</p>
                        @endif
                    </div>
                </div>
            </div>

            {{-- 6. Additional Information --}}
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">6. Additional Information</h5>
                        <div class="row g-3">
                            <div class="col-md-12">
                                <label class="form-label">Listing Title</label>
                                <p class="form-control-plaintext">{{ $listing->title }}</p>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Location</label>
                                <p class="form-control-plaintext">{{ $listing->location }}</p>
                            </div>
                            @if ($listing->description)
                                <div class="col-md-12">
                                    <label class="form-label">Description</label>
                                    <p class="form-control-plaintext">{{ $listing->description }}</p>
                                </div>
                            @endif
                            <div class="col-md-6">
                                <label class="form-label">Status</label>
                                <p class="form-control-plaintext">{!! $listing->status->badge() !!}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Created At</label>
                                <p class="form-control-plaintext">{{ $listing->created_at->format('d M Y, h:i A') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- 7. Dealer Information --}}
            <div class="col-12">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <h5 class="card-title">7. Dealer Information</h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Dealer Name</label>
                                <p class="form-control-plaintext">{{ $listing->owner->fullName }}</p>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Contact Number</label>
                                <p class="form-control-plaintext">{{ $listing->owner->phone ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-12">
                                <label class="form-label">Email</label>
                                <p class="form-control-plaintext">{{ $listing->owner->email }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- 8. Images --}}
            @if ($listing->image_url && count($listing->image_url) > 0)
                <div class="col-12">
                    <div class="card card-bordered">
                        <div class="card-inner">
                            <h5 class="card-title">8. Vehicle Images</h5>
                            <div class="row g-3">
                                @foreach ($listing->image_url as $image)
                                    <div class="col-md-4">
                                        <div class="card">
                                            <img src="{{ $image }}" alt="Listing Image" class="card-img-top" style="height: 250px; object-fit: cover;">
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endsection
