@extends('layouts.auth.app', [
    'cardWidth' => 'wide-sm',
])

@section('title', 'Buyer Registration')

@section('content')
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">Customer Registration</h4>
                    <div class="nk-block-des">
                        <p>Please provide the required information to register as a customer on BURD.</p>
                    </div>
                </div>
            </div>

            <form method="POST" action="{{ route('buyers-register.store') }}">
                @csrf

                @if ($errors->any())
                    <div class="alert alert-danger alert-icon mb-3">
                        <em class="icon ni ni-cross-circle"></em>
                        <strong>Whoops!</strong> Please fix the following errors:
                    </div>
                @endif

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">First Name <span class="text-danger">*</span></label>
                        <input type="text" name="first_name" class="form-control @error('first_name') is-invalid @enderror"
                               value="{{ old('first_name') }}" placeholder="first name" required>
                        @error('first_name') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Last Name <span class="text-danger">*</span></label>
                        <input type="text" name="last_name" class="form-control @error('last_name') is-invalid @enderror"
                               value="{{ old('last_name') }}" placeholder="last name" required>
                        @error('last_name') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Email <span class="text-danger">*</span></label>
                        <input type="email" name="email" class="form-control @error('email') is-invalid @enderror"
                               value="{{ old('email') }}" placeholder="Your Email" required>
                        @error('email') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Phone <span class="text-danger">*</span></label>
                        <input type="text" name="phone" class="form-control @error('phone') is-invalid @enderror"
                               value="{{ old('phone') }}" placeholder="Phone number" required>
                        @error('phone') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                   {{-- Dx Service Dropdown --}}
                    <div class="col-md-6">
                        <label class="form-label">Dx Customer <span class="text-danger">*</span></label>
                        <select name="dx_service_id" class="form-control @error('dx_service_id') is-invalid @enderror" required>
                            <option value="">-- Select Customer --</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ old('dx_customer_id') == $customer->id ? 'selected' : '' }}>
                                    {{ ucwords($customer->customer_name) }}
                                </option>
                            @endforeach
                        </select>
                        @error('dx_customer_id')
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Password <span class="text-danger">*</span></label>
                        <input type="password" name="password" class="form-control @error('password') is-invalid @enderror"
                               value="{{ old('password') }}" placeholder="password" required>
                        @error('password') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Confirm Password <span class="text-danger">*</span></label>
                        <input type="password" name="password_confirmation" class="form-control" required>
                    </div>
                </div>

                {{-- Terms --}}
                <div class="form-group mt-3">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" name="terms" class="custom-control-input @error('terms') is-invalid @enderror"
                               id="terms" {{ old('terms') ? 'checked' : '' }} required>
                        <label class="custom-control-label" for="terms">
                            I agree to the <a href="#">Terms & Conditions</a>.
                        </label>
                        @error('terms') <small class="text-danger d-block mt-1">{{ $message }}</small> @enderror
                    </div>
                </div>

                {{-- Submit --}}
                <div class="form-group mt-4 text-end">
                    <button type="submit" class="btn btn-lg btn-primary">Register Customer</button>
                </div>
            </form>
        </div>
    </div>
@endsection

