@extends('layouts.auth.app', [
    'cardWidth' => 'wide-md',
])

@section('title', 'Dealer Registration')

@section('content')
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">Dealer Registration</h4>
                    <div class="nk-block-des">
                        <p>Please provide the required information to register as a dealer on BURD.</p>
                    </div>
                </div>
            </div>

            <form method="POST" action="{{ route('dealers-register.store') }}">
                @csrf

                @if ($errors->any())
                    <div class="alert alert-danger alert-icon mb-3">
                        <em class="icon ni ni-cross-circle"></em>
                        <strong>Whoops!</strong> Please fix the following errors:
                    </div>
                @endif

                {{-- Company Information --}}
                <h5 class="mb-3">1. Company Information</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Company Name <span class="text-danger">*</span></label>
                        <input type="text" name="company_name" class="form-control @error('company_name') is-invalid @enderror"
                               value="{{ old('company_name') }}" placeholder="e.g. ABC Motors Pvt Ltd" required>
                        @error('company_name') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Registration / License Number <span class="text-danger">*</span></label>
                        <input type="text" name="registration_number" class="form-control @error('registration_number') is-invalid @enderror"
                               value="{{ old('registration_number') }}" placeholder="e.g. REG-123456" required>
                        @error('registration_number') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Tax Identification Number (NTN) <span class="text-danger">*</span></label>
                        <input type="text" name="tax_id" class="form-control @error('tax_id') is-invalid @enderror"
                               value="{{ old('tax_id') }}" placeholder="e.g. 1234567-8" required>
                        @error('tax_id') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    {{-- Address Breakdown --}}
                    <div class="col-md-4">
                        <label class="form-label">Country <span class="text-danger">*</span></label>
                        <input type="text" name="country" class="form-control @error('country') is-invalid @enderror"
                               value="{{ old('country') }}" placeholder="e.g. Pakistan" required>
                        @error('country') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">State / Province <span class="text-danger">*</span></label>
                        <input type="text" name="state" class="form-control @error('state') is-invalid @enderror"
                               value="{{ old('state') }}" placeholder="e.g. Punjab" required>
                        @error('state') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">City <span class="text-danger">*</span></label>
                        <input type="text" name="city" class="form-control @error('city') is-invalid @enderror"
                               value="{{ old('city') }}" placeholder="e.g. Lahore" required>
                        @error('city') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-8">
                        <label class="form-label">Street Address <span class="text-danger">*</span></label>
                        <input type="text" name="street" class="form-control @error('street') is-invalid @enderror"
                               value="{{ old('street') }}" placeholder="e.g. 123 Main Boulevard" required>
                        @error('street') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Postal Code <span class="text-danger">*</span></label>
                        <input type="text" name="postal_code" class="form-control @error('postal_code') is-invalid @enderror"
                               value="{{ old('postal_code') }}" placeholder="e.g. 54000" required>
                        @error('postal_code') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Contact Phone <span class="text-danger">*</span></label>
                        <input type="text" name="company_phone" class="form-control @error('company_phone') is-invalid @enderror"
                               value="{{ old('company_phone') }}" placeholder="+92 300 1234567" required>
                        @error('company_phone') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Contact Email <span class="text-danger">*</span></label>
                        <input type="email" name="company_email" class="form-control @error('company_email') is-invalid @enderror"
                               value="{{ old('company_email') }}" placeholder="info@abc-motors.com" required>
                        @error('company_email') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Password <span class="text-danger">*</span></label>
                        <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" required>
                        @error('password') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Confirm Password <span class="text-danger">*</span></label>
                        <input type="password" name="password_confirmation" class="form-control" required>
                    </div>
                </div>

                <hr class="my-4">

                {{-- Representative --}}
                <h5 class="mb-3">2. Authorized Representative Information</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Full Name <span class="text-danger">*</span></label>
                        <input type="text" name="rep_name" class="form-control @error('rep_name') is-invalid @enderror"
                               value="{{ old('rep_name') }}" placeholder="e.g. Ali Khan" required>
                        @error('rep_name') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">CNIC / Passport <span class="text-danger">*</span></label>
                        <input type="text" name="rep_cnic" id="rep_cnic"
                               class="form-control @error('rep_cnic') is-invalid @enderror"
                               value="{{ old('rep_cnic') }}" placeholder="e.g. 12345-1234567-1">
                        @error('rep_cnic') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Position <span class="text-danger">*</span></label>
                        <input type="text" name="rep_position" class="form-control @error('rep_position') is-invalid @enderror"
                               value="{{ old('rep_position') }}" placeholder="e.g. General Manager" required>
                        @error('rep_position') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Representative Contact <span class="text-danger">*</span></label>
                        <input type="text" name="rep_contact" class="form-control @error('rep_contact') is-invalid @enderror"
                               value="{{ old('rep_contact') }}" placeholder="+92 321 9876543" required>
                        @error('rep_contact') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>
                </div>

                <hr class="my-4">

                {{-- Bank --}}
                <h5 class="mb-3">3. Bank & Financial Information</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Bank Name <span class="text-danger">*</span></label>
                        <input type="text" name="bank_name" class="form-control @error('bank_name') is-invalid @enderror"
                               value="{{ old('bank_name') }}" placeholder="e.g. HBL" required>
                        @error('bank_name') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Account Holder Name <span class="text-danger">*</span></label>
                        <input type="text" name="account_holder" class="form-control @error('account_holder') is-invalid @enderror"
                               value="{{ old('account_holder') }}" placeholder="e.g. ABC Motors Pvt Ltd" required>
                        @error('account_holder') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>

                    <div class="col-md-12">
                        <label class="form-label">Account Number / IBAN <span class="text-danger">*</span></label>
                        <input type="text" name="account_number" class="form-control @error('account_number') is-invalid @enderror"
                               value="{{ old('account_number') }}" placeholder="e.g. PK36SCBL0000001123456702" required>
                        @error('account_number') <small class="text-danger">{{ $message }}</small> @enderror
                    </div>
                </div>

                <hr class="my-4">

                {{-- Terms --}}
                <div class="form-group mt-3">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" name="terms" class="custom-control-input @error('terms') is-invalid @enderror"
                               id="terms" {{ old('terms') ? 'checked' : '' }} required>
                        <label class="custom-control-label" for="terms">
                            I agree to the <a href="#">Terms & Conditions</a>.
                        </label>
                        @error('terms') <small class="text-danger d-block mt-1">{{ $message }}</small> @enderror
                    </div>
                </div>

                {{-- Submit --}}
                <div class="form-group mt-4 text-end">
                    <button type="submit" class="btn btn-lg btn-primary">Register Dealer</button>
                </div>
            </form>
        </div>
    </div>
@endsection
