@extends('layouts.app')

@section('title', 'Branches Management')

@section('content')
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title branch-title">@lang('branch.page.heading')</h3>
            </div>
            @can('dealers.branch.add')
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="branchMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="branchMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">
                                        <a href="{{ route('branches.create') }}" class="form-control btn btn-primary" async-modal async-modal-size="lg">
                                            <em class="icon ni ni-plus"></em>
                                            <span>@lang('branch.page.button.add')</span>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endcan
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-preview">
            <div class="card-inner">
                <table id="branches-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th><span class="sub-text">#</span></th>
                            <th><span class="sub-text">@lang('branch.table.header.name')</span></th>
                            <th><span class="sub-text">@lang('branch.table.header.address')</span></th>
                            <th><span class="sub-text">@lang('branch.table.header.created')</span></th>
                            <th><span class="sub-text">@lang('branch.table.header.updated')</span></th>
                            <th class="text-right"><span class="sub-text">@lang('branch.table.header.actions')</span></th>
                        </tr
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let columns = [
            {
                data: 'DT_RowIndex',
                name: 'uuid',
                orderable: false,
                searchable: false,
            },
            {
                data: 'branch_name',
                name: 'branch_name',
            },
            {
                data: 'address',
                name: 'address',
            },
            {
                data: 'created',
                name: 'created',
                searchable: false,
            },
            {
                data: 'updated',
                name: 'updated',
                searchable: false,
            },
            {
                data: 'actions',
                name: 'actions',
                searchable: false,
            },
        ];

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        let dt = $('#branches-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "{{ route('branches.datatable') }}",
                type: "GET", // you can use POST if your route expects it
                dataType: "json",
                error: function (xhr, error, thrown) {
                    console.error('DataTable AJAX error:', xhr.responseText);
                    if (xhr.status === 401) {
                        alert('Session expired. Please log in again.');
                        window.location.reload();
                    }
                }
            },
            columns: columns,
        });

        $('#branches-dt').on('draw.dt', function() {
            let queryString = new URLSearchParams({
                search: $('[type="search"]').val(),
            }).toString();
            console.log('Search Query:', queryString);
        });
    </script>
@endpush
