<link rel="stylesheet" href="{{ asset('assets/css/summernote-3.2.3.css') }}">

@php $url = isset($branch) ? route('branches.update', $branch->uuid) : route('branches.store'); @endphp

<h5 class="title pb-3">{{ isset($branch) ? 'Update' : 'Add New' }} Branch</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#branches-dt">
    @csrf

    @isset($branch)
        @method('put')
    @endisset

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="branc_name">@lang('branch.form.name.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="branch_name" name="branch_name" placeholder="@lang('branch.form.name.placeholder')" required value="{{ old('branch_name', isset($branch) ? $branch->branch_name : '') }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="address">@lang('branch.form.address.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="address" name="address" placeholder="@lang('branch.form.address.placeholder')" required value="{{ old('address', isset($branch) ? $branch->address : '') }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">{{ isset($branch) ? 'Update' : 'Add' }}</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="{{ asset('assets/js/summernote-3.2.3.js') }}"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
