<article class="bg-white shadow-sm rounded border border-gray-200 hover:shadow-md transition flex flex-col">

    {{-- Car Image --}}
    <div class="border-b border-gray-200">
        <img src="{{ $car->image_url }}" alt="{{ $car->name }}" class="w-full h-48 object-cover">
    </div>

    {{-- Car Info --}}
    <div class="p-4 flex-1 flex flex-col justify-between">
        <div>
            <div class="flex items-start justify-between">
                <div>
                    <h3 class="font-semibold text-gray-900">{{ $car->name }}</h3>
                    <p class="text-xs text-gray-500">{{ $car->type }} • {{ $car->year }}</p>

                    {{-- Dotted Line --}}
                    <div class="border-b border-dotted border-gray-300 my-2"></div>
                </div>
                <span class="font-semibold text-gray-900">${{ number_format($car->price) }}</span>
            </div>

            {{-- Car Specs --}}
            <div class="flex items-center justify-between mt-4 text-gray-600 text-xs">
                @foreach ($car->specs as $spec)
                    <div class="flex flex-col items-center text-center w-16">
                        <img src="{{ $spec['icon'] }}" class="w-6 h-6 object-contain mb-1" alt="icon">
                        <span class="text-[10px] leading-tight">{{ $spec['value'] }}</span>
                    </div>
                @endforeach
            </div>
        </div>

        {{-- Footer --}}
        <footer class="mt-4 flex flex-wrap items-center gap-4 text-xs text-gray-600 border-t border-dotted border-gray-200 pt-3">
            <span><span class="font-semibold text-gray-800">City:</span> {{ $car->city }}</span>
            <span><span class="font-semibold text-gray-800">Agent:</span> {{ $car->agent }}</span>
            <span class="text-gray-400">Added: {{ $car->added_at->format('m.d.y') }}</span>
        </footer>
    </div>
</article>
