@props(['listing'])

@php
    $spec = $listing->specification;
    $mainImage = $listing->image_url && is_array($listing->image_url) && count($listing->image_url) > 0
        ? $listing->image_url[0]
        : asset('assets/images/placeholder.png');
    $dealerName = $listing->owner ? ($listing->owner->first_name . ' ' . $listing->owner->last_name) : 'N/A';
    $addedDate = $listing->created_at ? $listing->created_at->format('d.m.y') : 'N/A';
@endphp

<article class="product-card">
    <a href="{{ route('buyer.index') }}#listing-{{ $listing->uuid }}" class="product-card-link">
        <!-- Car Image -->
        <div class="product-card-image">
            <img
                src="{{ $mainImage }}"
                alt="{{ $listing->title }}"
                class="product-card-img"
            >
        </div>

        <!-- Card Content -->
        <div class="product-card-content">
            <!-- Title and Price Row -->
            <div class="product-card-header">
                <h3 class="product-card-title">{{ $listing->title }}</h3>
                <p class="product-card-price">${{ number_format($listing->price, 0) }}</p>
            </div>

            <!-- Body Type and Year -->
            <div class="product-card-basic-info">
                @if($spec?->body_type)
                    <span>{{ $spec->body_type }}</span>
                @endif
                @if($spec?->year)
                    <span class="product-card-separator">•</span>
                    <span>{{ $spec->year }}</span>
                @endif
            </div>

            <!-- Dashed Separator -->
            <div class="product-card-divider"></div>

            <!-- Specifications Grid -->
            <div class="product-card-specs">
                <!-- Mileage -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="{{ asset('assets/buyer/product/speedometer.svg') }}" alt="Mileage" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        {{ $spec?->mileage ? number_format($spec->mileage) : '0' }}
                    </span>
                </div>

                <!-- Engine -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="{{ asset('assets/buyer/product/fa_gears.svg') }}" alt="Engine" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        {{ $spec?->engine_capacity ? ($spec->engine_capacity / 1000) . 'L' : 'N/A' }}
                        @if($spec?->engine_capacity && $spec->engine_capacity >= 3000)
                            Twinscroll
                        @endif
                    </span>
                </div>

                <!-- Fuel Type -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="{{ asset('assets/buyer/product/fuel.svg') }}" alt="Fuel Type" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        {{ $spec?->fuel_type ?: 'N/A' }}
                    </span>
                </div>

                <!-- Transmission -->
                <div class="product-card-spec-item">
                    <div class="product-card-spec-icon">
                        <img src="{{ asset('assets/buyer/product/car_type.svg') }}" alt="Transmission" class="product-card-icon-img">
                    </div>
                    <span class="product-card-spec-value">
                        {{ $spec?->transmission ?: 'N/A' }}
                    </span>
                </div>
            </div>

            <!-- Dashed Separator -->
            <div class="product-card-divider"></div>

            <!-- Footer Info -->
            <div class="product-card-footer">
                <div class="product-card-footer-item">
                    <span class="product-card-footer-label">City:</span>
                    <span class="product-card-footer-value">{{ $listing->location ?: 'N/A' }}</span>
                </div>
                <div class="product-card-footer-item">
                    <span class="product-card-footer-label">Agent:</span>
                    <span class="product-card-footer-value">{{ $dealerName }}</span>
                </div>
                <div class="product-card-footer-item">
                    <span class="product-card-footer-label">Added:</span>
                    <span class="product-card-footer-value">{{ $addedDate }}</span>
                </div>
            </div>
        </div>
    </a>
</article>

