@extends('layouts.buyer.app')

@section('meta_title', $meta_title ?? 'Home')
@section('meta_description', $meta_description ?? 'Find your perfect vehicle')
@section('meta_keywords', $meta_keywords ?? 'vehicles, cars')

@section('content')
<div class="min-h-screen bg-white">

    <!-- Hero Section -->
    <section class="relative bg-black text-white overflow-hidden h-screen">
        <!-- Background -->
        <div class="absolute inset-0 z-0 overflow-hidden">
            <img src="{{ asset('assets/buyer/home/hero-section.png') }}" alt="Hero Car" class="w-full h-full object-cover" />
            <div class="absolute inset-0 bg-black/10"></div>
        </div>

        <!-- Content Overlay -->
        <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-col justify-center h-full">
            <div class="w-full text-center sm:text-left mt-[500px] ">
                <p class="text-white mb-2 text-base sm:text-lg md:text-xl">Find the Perfect Car, Right Here</p>
                <h1 class="text-white text-4xl sm:text-5xl md:text-6xl font-bold leading-tight">Drive Home Happy</h1>
            </div>
        </div>
    </section>

    <!-- Learn More Section -->
    <section class="bg-white py-24">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="flex flex-col lg:flex-row justify-between items-start gap-12 lg:gap-16">
                <!-- Left Text + Image -->
                <div class="flex flex-col items-center lg:items-start text-center lg:text-left">
                    <p class="uppercase mb-4 text-sm md:text-base">Learn More</p>
                    <h2 class="uppercase mb-8 text-2xl md:text-3xl lg:text-4xl leading-tight">
                        <span class="block">Discover Tesla's</span>
                        <span class="block">Mission And Vision</span>
                    </h2>
                    <div class="rounded-xl overflow-hidden w-full sm:w-80 md:w-96 h-72 sm:h-96 md:h-[470px] mt-4">
                        <img src="{{ asset('assets/buyer/home/learn-more-2.png') }}" class="w-full h-full object-cover" alt="White Sports Car">
                    </div>
                </div>

                <!-- Right Image + Optional Text -->
                <div class="flex flex-col items-center lg:items-start text-center lg:text-left">
                    <div class="rounded-xl overflow-hidden w-full sm:w-80 md:w-96 h-72 sm:h-96 md:h-[470px]">
                        <img src="{{ asset('assets/buyer/home/learn-more-1.png') }}" class="w-full h-full object-cover" alt="Driver's Perspective - BMW Interior">
                    </div>
                    <p class="text-sm md:text-base text-gray-500 leading-relaxed max-w-sm mt-6">
                        Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Premium Quality Section -->
    <section class="bg-white relative">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex flex-col lg:flex-row items-center lg:items-start gap-8 lg:gap-16">

            <!-- Left Image -->
            <div class="w-full lg:w-1/2 flex justify-center lg:justify-start">
                <img src="{{ asset('assets/buyer/home/car-sketch.png') }}" class="w-full max-w-sm lg:max-w-full object-contain" alt="Premium Quality Car Sketch">
            </div>

            <!-- Centered Text -->
            <div class="w-full lg:w-1/2 text-center lg:text-left">
                <p class="uppercase font-semibold text-gray-600">Premium Quality</p>
                <div class="mb-8 lg:mb-10">
                    <p class="mb-1">Lorem Ipsum is simmply</p>
                    <p class="mb-1">dummyy text of is of the printing</p>
                    <p class="mb-1">and typesetting industry.</p>
                </div>
                <div>
                    <p class="font-bold">Peter Watson</p>
                    <p class="text-gray-500">Car Dealer</p>
                </div>
            </div>

        </div>
    </section>

    <!-- Featured Vehicles -->
    <section class="py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <header class="mb-8 text-center">
                <h2 class="text-3xl font-bold uppercase mb-2">Featured Vehicles</h2>
            </header>

            <div id="cars-container" class="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
                @foreach ($cars as $car)
                    @include('buyer.components.car-card', ['car' => $car])
                @endforeach
            </div>

            <div class="mt-8 flex justify-center">
                @if ($cars->hasMorePages())
                    <button id="load-more-btn" data-next="{{ $cars->nextPageUrl() }}" class="px-6 py-2 text-sm font-medium text-white bg-blue-600 rounded hover:bg-blue-700">
                        Load More
                    </button>
                @endif
            </div>
        </div>
    </section>

    <!-- Design Efficiency -->
    <section class="relative py-16 md:py-20 lg:py-24 overflow-hidden">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 mb-8 md:mb-12 lg:mb-10">
            <h2 class="text-black text-3xl md:text-4xl lg:text-5xl xl:text-5xl font-bold uppercase leading-tight tracking-tight">Designed for Efficiency</h2>
        </div>
        <div class="w-full">
            <img src="{{ asset('assets/buyer/home/design-efficiency.svg') }}" class="w-full h-auto object-cover" alt="Design Efficiency">
        </div>
        <div class="absolute inset-0 opacity-5 pointer-events-none flex items-center justify-center">
            <p class="text-6xl md:text-8xl lg:text-9xl font-bold text-white uppercase">Design Efficiency</p>
        </div>
    </section>

    <!-- FAQ Section -->
    <section class="py-16 md:py-20 lg:py-24 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
            <p class="text-xs uppercase tracking-[0.2em] text-gray-500 mb-2 md:mb-3 font-medium">Questions and Answers</p>
            <h2 class="text-3xl md:text-4xl lg:text-5xl xl:text-6xl font-bold text-black mb-2 md:mb-3 uppercase leading-tight tracking-tight">Answers to Questions</h2>
            <h2 class="text-3xl md:text-4xl lg:text-5xl xl:text-6xl font-bold text-black uppercase leading-tight tracking-tight">About Electric Car</h2>
        </div>

        <div class="max-w-3xl mx-auto mt-8 space-y-4">
            @php
                $faqList = [
                    ['question' => 'How long does it take to charge an electric car?', 'answer' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.'],
                    ['question' => 'Can I charge an electric car at home?', 'answer' => 'Yes, you can charge an electric car at home using a standard electrical outlet or a dedicated charging station installed in your garage or driveway.'],
                    ['question' => 'How much does it cost to charge an electric car?', 'answer' => 'The cost of charging an electric car varies depending on your location, electricity rates, and the car\'s battery capacity. On average, it costs less than half the price of gasoline.'],
                    ['question' => 'What happens if the battery runs out on the road?', 'answer' => 'If your electric car battery runs out, you\'ll need to call for roadside assistance. Many electric vehicle manufacturers offer roadside assistance programs that can provide a mobile charger or tow your vehicle to the nearest charging station.']
                ];
            @endphp

            @foreach ($faqList as $faq)
                <div class="border border-gray-200 rounded-lg overflow-hidden">
                    <div class="w-full px-4 sm:px-5 md:px-6 py-4 sm:py-5">
                        <h3 class="font-semibold text-black text-sm sm:text-base md:text-base mb-2 sm:mb-3">{{ $faq['question'] }}</h3>
                        <p class="text-gray-600 text-sm sm:text-base md:text-base leading-relaxed">{{ $faq['answer'] }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </section>

</div>

@include('buyer.components.footer')
@endsection

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).on("click", "#load-more-btn", function() {
    let btn = $(this);
    let nextUrl = btn.data("next");

    if (!nextUrl) return;

    btn.text("Loading...");

    $.get(nextUrl, function(res) {
        let html = $(res).find("#cars-container").html();
        let newCars = $(html).children();
        $("#cars-container").append(newCars);

        let newNext = $(res).find("#load-more-btn").data("next");
        if (newNext) {
            btn.data("next", newNext);
            btn.text("Load More");
        } else {
            btn.remove();
        }
    });
});
</script>
