@extends('layouts.buyer.app')

@section('content')
    {{-- HEADER --}}
    @include('buyer.components.header')

    {{-- PAGE BANNER --}}
    <section class="relative bg-black text-white py-20">
        <div class="container mx-auto px-4 text-center">
            <h1 class="text-5xl md:text-6xl font-bold uppercase mt-20">Tesla Model 2</h1>
            <p class="mt-2 text-sm md:text-base text-gray-300">
                HOME / ALL CARS / TESLA MODEL 2
            </p>
        </div>
    </section>

    {{-- Cars Images --}}
    <section class="w-full py-10 bg-gray-100">
        <div class="max-w-5xl mx-auto px-4">

            <!-- Main Image -->
            <div class=" p-2 bg-white">
                <img src="{{ asset('assets/buyer/home/product.png') }}" alt="Car Image" class="w-full h-[450px] object-contain bg-white">
            </div>

            <!-- Thumbnails -->
            <div class="flex justify-between gap-4 mt-4 overflow-x-auto pb-2">
                <img src="{{ asset('assets/buyer/home/product.png') }}"
                    class="w-32 h-24 object-cover cursor-pointer border border-transparent hover:border-blue-500 transition">
                <img src="{{ asset('assets/buyer/home/product.png') }}"
                    class="w-32 h-24 object-cover cursor-pointer border border-transparent hover:border-blue-500 transition">
                <img src="{{ asset('assets/buyer/home/product.png') }}"
                    class="w-32 h-24 object-cover cursor-pointer border border-transparent hover:border-blue-500 transition">
                <img src="{{ asset('assets/buyer/home/product.png') }}"
                    class="w-32 h-24 object-cover cursor-pointer border border-transparent hover:border-blue-500 transition">
                <img src="{{ asset('assets/buyer/home/product.png') }}"
                    class="w-32 h-24 object-cover cursor-pointer border border-transparent hover:border-blue-500 transition">
            </div>

        </div>
    </section>

    {{-- Title, Price, Description --}}
    <section class="w-full bg-white py-16">
        <div class="max-w-5xl mx-auto px-4">

            <!-- TITLE & PRICE -->
            <div class="flex flex-col md:flex-row md:justify-between md:items-start gap-4">
                <div>
                    <h1 class="text-3xl font-bold uppercase">Tesla Model 2</h1>
                    <p class="text-sm text-gray-500 mt-1">
                        Sedan &nbsp;•&nbsp; 2020 &nbsp;•&nbsp; Chicago
                    </p>
                </div>
                <div class="text-right">
                    <p class="text-2xl font-semibold">$300,000</p>
                    <p class="text-xs text-gray-400 mt-1">August 11, 2025</p>
                </div>
            </div>

            <!-- DESCRIPTION -->
            <p class="mt-6 text-sm text-gray-600 leading-relaxed">
                Lorem Ipsum is simply dummy text of is of the printing and typesetting industry. Lorem Ipsum is simply dummy
                text of is of the printing and typesetting industry. Lorem Ipsum is simply dummy text text is of the printing
                and typesetting industry.
            </p>

            <!-- DETAILS -->
            <div class="mt-10">
                <h3 class="text-sm font-semibold uppercase">Details</h3>
                <div class="border-b border-gray-200 mt-3 mb-6"></div>

                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-y-4 text-sm text-gray-600">
                    <p><span class="font-medium text-gray-900">Car ID:</span> Tesla-Model2</p>
                    <p><span class="font-medium text-gray-900">Manufacturer:</span> Tesla</p>
                    <p><span class="font-medium text-gray-900">Model:</span> Model 2</p>

                    <p><span class="font-medium text-gray-900">Transmission:</span> Automatic</p>
                    <p><span class="font-medium text-gray-900">Type of drive:</span> Front-wheel drive</p>
                    <p><span class="font-medium text-gray-900">Fuel:</span> Gasoline</p>

                    <p><span class="font-medium text-gray-900">Engine:</span> 3.0 L TwinScroll</p>
                    <p><span class="font-medium text-gray-900">Engine power:</span> 425 horses</p>
                    <p><span class="font-medium text-gray-900">Engine power:</span> 220 watts</p>
                </div>
            </div>

            <!-- FEATURES -->
            <div class="mt-10">
                <h3 class="text-sm font-semibold uppercase">Features</h3>
                <div class="border-b border-gray-200 mt-3 mb-6"></div>

                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-y-3 text-sm text-gray-600">
                    <p>✔ Climate Control</p>
                    <p>✔ Heated Seats</p>
                    <p>✔ Keyless Entry</p>
                    <p>✔ Leather Seats</p>
                    <p>✔ Navigation System</p>
                    <p>✔ Power Windows</p>
                </div>
            </div>

            <!-- VIDEO -->
            <div class="mt-10">
                <h3 class="text-sm font-semibold uppercase">Video</h3>
                <div class="border-b border-gray-200 mt-3 mb-6"></div>

                <p class="text-sm text-gray-600 mb-6 leading-relaxed">
                    Lorem Ipsum is simply dummy text of is of the printing and typesetting industry. Lorem Ipsum is simply dummy
                    text text is of the printing and typesetting industry.
                </p>

                <div class="relative w-full h-[260px] md:h-[340px] bg-gray-900 flex items-center justify-center rounded">
                    <div class="w-14 h-14 bg-white rounded-full flex items-center justify-center">
                        <svg class="w-6 h-6 text-black ml-1" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M6 4l10 6-10 6V4z"></path>
                        </svg>
                    </div>
                </div>
            </div>

            <!-- CONTACTS -->
            <div class="mt-10">
                <h3 class="text-sm font-semibold uppercase">Contacts</h3>
                <div class="border-b border-gray-200 mt-3"></div>
            </div>

        </div>
    </section>

    {{-- Listing images --}}
    <section class="py-12">
        <div class="max-w-5xl mx-auto px-4">

            {{-- Title --}}
            <div class="mt-10">
                <h3 class="text-xl font-semibold uppercase text-gray-900">
                    You Also Like
                </h3>
                <div class="border-b border-gray-200 mt-3 mb-8"></div>
            </div>

            {{-- Cards Grid --}}
            <div id="cars-container" class="grid gap-8 sm:grid-cols-2 lg:grid-cols-3">
                @foreach ($cars as $car)
                    @include('buyer.components.car-card', ['car' => $car])
                @endforeach
            </div>

        </div>
    </section>

    {{-- FOOTER --}}
    @include('buyer.components.footer')
@endsection
