@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="nk-block">
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">Dashboard Overview</h3>
                <div class="nk-block-des text-soft">
                    <p>Welcome to your dashboard. Here is an overview of the platform.</p>
                </div>
            </div>
            <div class="nk-block-head-content">
                <div class="toggle-wrap nk-block-tools-toggle">
                    <a href="#" class="btn btn-icon btn-trigger toggle-expand me-n1" data-target="pageMenu"><em class="icon ni ni-more-v"></em></a>
                    <div class="toggle-expand-content" data-content="pageMenu">
                        <ul class="nk-block-tools g-3">
                            <li>
                                <div class="drodown">
                                    <a href="#" class="dropdown-toggle btn btn-white btn-dim btn-outline-light" data-bs-toggle="dropdown"><em
                                            class="d-none d-sm-inline icon ni ni-calender-date"></em><span><span class="d-none d-md-inline">Last</span> 30 Days</span><em
                                            class="dd-indc icon ni ni-chevron-right"></em></a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <ul class="link-list-opt no-bdr">
                                            <li><a href="#"><span>Last 30 Days</span></a></li>
                                            <li><a href="#"><span>Last 6 Months</span></a></li>
                                            <li><a href="#"><span>Last 1 Years</span></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="nk-block">
        <div class="row g-gs">

            {{-- Stats Cards --}}
            <div class="col-xxl-3 col-sm-6">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-2">
                            <div class="card-title">
                                <h6 class="title">Total Admins</h6>
                            </div>
                            <div class="card-tools">
                                <em class="card-hint icon ni ni-list-thumb bg-info-dim"></em>
                            </div>
                        </div>
                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                            <div class="nk-sale-data">
                                <span class="amount">{{ $totalAdminUsers }}</span>
                                <span class="sub-title">Live on platform</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-6">
                <div class="card card-bordered card-full">
                    <div class="card-inner">
                        <div class="card-title-group">
                            <div class="card-title">
                                <h6 class="title">Recent Dealers</h6>
                            </div>
                            <div class="card-tools">
                                <a href="{{ route('dealers.index') }}" class="link">View All</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-inner p-0 border-top">
                        <div class="nk-tb-list nk-tb-orders">
                            <div class="nk-tb-item nk-tb-head">
                                <div class="nk-tb-col"><span>Name</span></div>
                                <div class="nk-tb-col tb-col-sm"><span>Email</span></div>
                                <div class="nk-tb-col"><span>Joined</span></div>
                                <div class="nk-tb-col"><span>Status</span></div>
                            </div>
                            @foreach ($recentDealers as $dealer)
                                <div class="nk-tb-item">
                                    <div class="nk-tb-col">
                                        <span class="tb-lead">{{ $dealer->full_name }}</span>
                                    </div>
                                    <div class="nk-tb-col tb-col-sm">
                                        <span class="tb-sub">{{ $dealer->email }}</span>
                                    </div>
                                    <div class="nk-tb-col">
                                        <span class="tb-sub">{{ $dealer->created_at->format('d M Y') }}</span>
                                    </div>
                                    <div class="nk-tb-col">
                                        <span class="badge badge-dot {{ $dealer->status->value == 1 ? 'bg-success' : 'bg-danger' }}">{{ $dealer->status->name }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

            {{-- Total Customers --}}
            <div class="col-xxl-3 col-sm-6">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-2">
                            <div class="card-title">
                                <h6 class="title">Total Customers</h6>
                            </div>
                            <div class="card-tools">
                                <em class="card-hint icon ni ni-users bg-primary-dim"></em>
                            </div>
                        </div>
                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                            <div class="nk-sale-data">
                                <span class="amount">{{ $buyersCount }}</span>
                                <span class="sub-title">Active Buyers</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Active Dealers --}}
            <div class="col-xxl-3 col-sm-6">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-2">
                            <div class="card-title">
                                <h6 class="title">Active Dealers</h6>
                            </div>
                            <div class="card-tools">
                                <em class="card-hint icon ni ni-user-check bg-success-dim"></em>
                            </div>
                        </div>
                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                            <div class="nk-sale-data">
                                <span class="amount">{{ $dealersCount }}</span>
                                <span class="sub-title">Active Dealers</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Active Listings --}}
            <div class="col-xxl-3 col-sm-6">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-2">
                            <div class="card-title">
                                <h6 class="title">Active Listings</h6>
                            </div>
                            <div class="card-tools">
                                <em class="card-hint icon ni ni-list-thumb bg-info-dim"></em>
                            </div>
                        </div>
                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                            <div class="nk-sale-data">
                                <span class="amount">{{ $activeListingsCount }}</span>
                                <span class="sub-title">Live on platform</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Pending Listings --}}
            <div class="col-xxl-3 col-sm-6">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-2">
                            <div class="card-title">
                                <h6 class="title">Pending Listings</h6>
                            </div>
                            <div class="card-tools">
                                <em class="card-hint icon ni ni-clock bg-warning-dim"></em>
                            </div>
                        </div>
                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                            <div class="nk-sale-data">
                                <span class="amount">{{ $pendingListingsCount }}</span>
                                <span class="sub-title">Awaiting approval</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Dex Users --}}
            <div class="col-xxl-3 col-sm-6">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-2">
                            <div class="card-title">
                                <h6 class="title">Dex Users</h6>
                            </div>
                            <div class="card-tools">
                                <em class="card-hint icon ni ni-user-check bg-success-dim"></em>
                            </div>
                        </div>
                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                            <div class="nk-sale-data">
                                <span class="amount">{{ $totalDexUser }}</span>
                                <span class="sub-title">All Dex Users</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Dx Customers --}}
            <div class="col-xxl-3 col-sm-6">
                <div class="card card-bordered">
                    <div class="card-inner">
                        <div class="card-title-group align-start mb-2">
                            <div class="card-title">
                                <h6 class="title">Dx Customers</h6>
                            </div>
                            <div class="card-tools">
                                <em class="card-hint icon ni ni-user-check bg-success-dim"></em>
                            </div>
                        </div>
                        <div class="align-end flex-sm-wrap g-4 flex-md-nowrap">
                            <div class="nk-sale-data">
                                <span class="amount">{{ $totalDxCustomer }}</span>
                                <span class="sub-title">All Dx Customer</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Charts --}}
            <div class="col-xxl-6">
                <div class="card card-bordered h-100">
                    <div class="card-inner">
                        <div class="card-title-group align-start mn-2">
                            <div class="card-title">
                                <h6 class="title">User Growth Trend</h6>
                                <span class="sub-text">New user registrations over the last 30 days</span>
                            </div>
                        </div>
                        <div class="nk-order-ovwg">
                            <div class="row g-4 align-end">
                                <div class="col-xxl-12">
                                    <div class="nk-order-ovwg-ck">
                                        <canvas class="line-chart" id="userTrendChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xxl-6">
                <div class="card card-bordered h-100">
                    <div class="card-inner">
                        <div class="card-title-group align-start mn-2">
                            <div class="card-title">
                                <h6 class="title">Listings by Status</h6>
                                <span class="sub-text">Distribution of listing statuses</span>
                            </div>
                        </div>
                        <div class="nk-order-ovwg">
                            <div class="row g-4 align-end">
                                <div class="col-xxl-12">
                                    <div class="nk-order-ovwg-ck">
                                        <canvas class="doughnut-chart" id="listingStatusChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Recent Listings --}}
            <div class="col-xxl-6">
                <div class="card card-bordered card-full">
                    <div class="card-inner">
                        <div class="card-title-group">
                            <div class="card-title">
                                <h6 class="title">Recent Listings</h6>
                            </div>
                            <div class="card-tools">
                                <a href="{{ route('admin.listings.index') }}" class="link">View All</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-inner p-0 border-top">
                        <div class="nk-tb-list nk-tb-orders">
                            <div class="nk-tb-item nk-tb-head">
                                <div class="nk-tb-col"><span>Title</span></div>
                                <div class="nk-tb-col tb-col-sm"><span>Owner</span></div>
                                <div class="nk-tb-col tb-col-md"><span>Price</span></div>
                                <div class="nk-tb-col"><span>Status</span></div>
                            </div>
                            @foreach ($recentListings as $listing)
                                <div class="nk-tb-item">
                                    <div class="nk-tb-col">
                                        <span class="tb-lead"><a href="{{ route('admin.listings.show', $listing->id) }}">{{ Str::limit($listing->title, 20) }}</a></span>
                                    </div>
                                    <div class="nk-tb-col tb-col-sm">
                                        <div class="user-card">
                                            <div class="user-name">
                                                <span class="tb-lead">{{ $listing->owner->name ?? 'Unknown' }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="nk-tb-col tb-col-md">
                                        <span class="tb-sub">{{ number_format($listing->price, 2) }}</span>
                                    </div>
                                    <div class="nk-tb-col">
                                        {!! $listing->status->badge() !!}
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // User Trend Chart
    const userTrendCtx = document.getElementById('userTrendChart').getContext('2d');
    new Chart(userTrendCtx, {
        type: 'line',
        data: {
            labels: @json($userTrendLabels),
            datasets: [{
                label: 'New Registrations',
                data: @json($userTrendData),
                borderColor: '#854fff',
                backgroundColor: 'rgba(133, 79, 255, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: '#e5e9f2'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Listing Status Chart
    const listingStatusCtx = document.getElementById('listingStatusChart').getContext('2d');
    const listingData = @json($listingsByStatus);

    new Chart(listingStatusCtx, {
        type: 'doughnut',
        data: {
            labels: listingData.map(item => item.label),
            datasets: [{
                data: listingData.map(item => item.value),
                backgroundColor: listingData.map(item => item.color),
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'right',
                    labels: {
                        usePointStyle: true,
                        boxWidth: 10
                    }
                }
            },
            cutout: '70%'
        }
    });
});
</script>
@endpush
