@extends('layouts.auth.app')

@section('title', trans('forgot_password.page.title'))

@section('content')
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">@lang('forgot_password.page.heading')</h4>
                    <div class="nk-block-des">
                        <p>@lang('forgot_password.page.description')</p>
                    </div>
                </div>
            </div>

            @if (session('status'))
                <div class="alert alert-info">{{ session('status') }}</div>
            @endif

            <form method="post" action="{{ route('dealers.password.email') }}">
                @csrf

                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="email">@lang('forgot_password.form.email.label')</label>
                    </div>
                    <div class="form-control-wrap">
                        <input type="email" class="form-control form-control-lg" id="email" name="email" value="{{ old('email') }}" required autofocus autocomplete="off"
                            placeholder="@lang('forgot_password.form.email.placeholder')">
                        @if ($errors->has('email'))
                            <small class="text-danger">{{ $errors->first('email') }}</small>
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-lg btn-primary btn-block">
                        @lang('forgot_password.page.buttons.reset_password_link')
                    </button>
                </div>
            </form>

            @if (Route::has('dealers.login'))
                <div class="form-note-s2 text-center pt-4">
                    @lang('forgot_password.page.question.signin') <a href="{{ route('dealers.login') }}">@lang('forgot_password.page.buttons.login')</a>
                </div>
            @endif
        </div>
    </div>
@endsection
