@extends('layouts.auth.app')

@section('title', trans('login.page.title'))

@section('content')
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">@lang('login.page.heading')</h4>
                    <div class="nk-block-des">
                        <p>@lang('login.page.description')</p>
                    </div>
                </div>
            </div>

            @if (session('status'))
                <div class="alert alert-info">{{ session('status') }}</div>
            @endif

            <form method="post" action="{{ route('dealers.login.store') }}">
                @csrf

                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="email">@lang('login.form.email.label')</label>
                    </div>
                    <div class="form-control-wrap">
                        <input type="email" class="form-control form-control-lg" id="email" name="email" value="{{ old('email') }}" required autofocus
                            placeholder="@lang('login.form.email.placeholder')">
                        @if ($errors->has('email'))
                            <small class="text-danger">{{ $errors->first('email') }}</small>
                        @endif
                    </div>
                </div>

                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="password">@lang('login.form.password.label')</label>
                        @if (Route::has('dealers.password.request'))
                            <a class="link link-primary link-sm" href="{{ route('dealers.password.request') }}" tabindex="-1">@lang('login.page.question.forgot_password')</a>
                        @endif
                    </div>
                    <div class="form-control-wrap">
                        <a href="javascript:void(0);" class="form-icon form-icon-right passcode-switch lg" data-target="password" tabindex="-1">
                            <em class="passcode-icon icon-show icon ni ni-eye"></em>
                            <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
                        </a>
                        <input type="password" class="form-control form-control-lg" id="password" name="password" required placeholder="@lang('login.form.password.placeholder')">
                        @if ($errors->has('password'))
                            <small class="text-danger">{{ $errors->first('password') }}</small>
                        @endif
                    </div>
                </div>

                <div class="my-3">
                    <div class="form-group m-0">
                        <div class="custom-control custom-control-xs custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="terms" id="terms">
                            <label class="custom-control-label" for="terms">@lang('login.page.checkbox.terms_and_conditions.accept')</label>
                        </div>
                    </div>
                    @if ($errors->has('terms'))
                        <small class="text-danger">{{ $errors->first('terms') }}</small>
                    @endif
                </div>

                <div class="form-group">
                    <div class="custom-control custom-control-xs custom-checkbox">
                        <input type="checkbox" class="custom-control-input" name="remember" id="remember">
                        <label class="custom-control-label" for="remember">@lang('login.page.checkbox.remember_me')</label>
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-lg btn-primary btn-block">@lang('login.page.buttons.login')</button>
                </div>
            </form>
            @if (Route::has('dealers.register'))
                <div class="form-note-s2 text-center pt-4">
                    @lang('login.page.question.register') <a href="{{ route('dealers.register') }}">@lang('login.page.buttons.register')</a>
                </div>
            @endif
        </div>
    </div>
@endsection
