@extends('layouts.auth.app')

@section('title', trans('reset_password.page.title'))

@section('content')
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">@lang('reset_password.page.heading')</h4>
                    <div class="nk-block-des">
                        <p>@lang('reset_password.page.description')</p>
                    </div>
                </div>
            </div>

            @if (session('status'))
                <div class="alert alert-info">{{ session('status') }}</div>
            @endif

            <form method="post" action="{{ route('dealers.password.store') }}">
                @csrf

                <input type="hidden" name="token" value="{{ $request->route('token') }}">

                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="email">@lang('reset_password.form.email.label')</label>
                    </div>
                    <div class="form-control-wrap">
                        <input type="email" class="form-control form-control-lg" id="email" name="email" value="{{ old('email', $request->email) }}" required readonly
                            autocomplete="off" placeholder="@lang('reset_password.form.email.placeholder')">
                        @if ($errors->has('email'))
                            <small class="text-danger">{{ $errors->first('email') }}</small>
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="password">@lang('reset_password.form.password.label')</label>
                    </div>
                    <div class="form-control-wrap">
                        <a href="javascript:void(0);" class="form-icon form-icon-right passcode-switch lg" data-target="password" tabindex="-1">
                            <em class="passcode-icon icon-show icon ni ni-eye"></em>
                            <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
                        </a>
                        <input type="password" class="form-control form-control-lg" id="password" name="password" required autofocus placeholder="@lang('reset_password.form.password.placeholder')">
                        @if ($errors->has('password'))
                            <small class="text-danger">{{ $errors->first('password') }}</small>
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <div class="form-label-group">
                        <label class="form-label" for="password_confirmation">@lang('reset_password.form.confirm_password.label')</label>
                    </div>
                    <div class="form-control-wrap">
                        <a href="javascript:void(0);" class="form-icon form-icon-right passcode-switch lg" data-target="password_confirmation" tabindex="-1">
                            <em class="passcode-icon icon-show icon ni ni-eye"></em>
                            <em class="passcode-icon icon-hide icon ni ni-eye-off"></em>
                        </a>
                        <input type="password" class="form-control form-control-lg" id="password_confirmation" name="password_confirmation" required
                            placeholder="@lang('reset_password.form.confirm_password.placeholder')">
                        @if ($errors->has('password_confirmation'))
                            <small class="text-danger">{{ $errors->first('password_confirmation') }}</small>
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-lg btn-primary btn-block">@lang('reset_password.page.buttons.submit')</button>
                </div>
            </form>

            @if (Route::has('dealers.login'))
                <div class="form-note-s2 text-center pt-4">
                    @lang('reset_password.page.question.signin') <a href="{{ route('dealers.login') }}">@lang('reset_password.page.buttons.login')</a>
                </div>
            @endif
        </div>
    </div>
@endsection
