@extends('layouts.auth.app')

@section('title', trans('verify_email.page.title'))

@section('content')
    <div class="card card-bordered">
        <div class="card-inner card-inner-lg">
            <div class="nk-block-head">
                <div class="nk-block-head-content">
                    <h4 class="nk-block-title">@lang('verify_email.page.heading')</h4>
                    <div class="nk-block-des">
                        <p>@lang('verify_email.page.description')</p>
                    </div>
                </div>
            </div>

            @if (session('status') == 'verification-link-sent')
                <div class="alert alert-info">@lang('verify_email.flash.success.verification_link_sent')</div>
            @endif

            <form method="POST" action="{{ route('dealers.verification.send') }}">
                @csrf

                <div class="form-group">
                    <button type="submit" class="btn btn-lg btn-primary btn-block">@lang('verify_email.page.buttons.submit')</button>
                </div>
            </form>

            <form method="POST" action="{{ route('dealers.logout') }}" class="mt-2">
                @csrf

                <div class="form-group">
                    <button type="submit" class="btn btn-lg btn-warning btn-block">@lang('verify_email.page.buttons.logout')</button>
                </div>
            </form>
        </div>
    </div>
@endsection
