@extends('layouts.dealer.app')

@section('title', 'My Listings')

@section('content')
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">My Listings</h3>
            </div>

            @can('listing.add')
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="branchMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="branchMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">
                                        <a href="{{ route('dealers.listings.create') }}" class="form-control btn btn-primary" >
                                            <em class="icon ni ni-plus"></em>
                                            <span>Create Listing</span>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endcan
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-aside-wrap">
                <div class="card-content">
                    <div class="card-inner position-relative card-tools-toggle table-responsive">
                        <table id="listings-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                            <thead>
                                <tr class="nk-tb-item nk-tb-head">
                                    <th><span class="sub-text">#</span></th>
                                    <th><span class="sub-text">Title</span></th>
                                    <th><span class="sub-text">Owner</span></th>
                                    <th><span class="sub-text">Price</span></th>
                                    <th><span class="sub-text">Location</span></th>
                                    <th><span class="sub-text">Type</span></th>
                                    <th><span class="sub-text">Status</span></th>
                                    <th><span class="sub-text">Created</span></th>
                                    <th class="text-right"><span class="sub-text">Actions</span></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        var table = $('#listings-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "{{ route('dealers.listings.datatable') }}",
            },
            columns: [
                {
                    data: 'DT_RowIndex',
                    name: 'id',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'title',
                    name: 'title'
                },
                {
                    data: 'owner',
                    name: 'owner'
                },
                {
                    data: 'price',
                    name: 'price'
                },
                {
                    data: 'location',
                    name: 'location'
                },
                {
                    data: 'type',
                    name: 'type'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'created',
                    name: 'created',
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    searchable: false
                },
            ],
        });
    </script>
@endpush
