<h5 class="title pb-3">@lang('profile.business_information.edit.title')</h5>

<form action="{{ route('dealers.profile.business.update') }}" method="post" async-form on-async-modal data-event="profile.updated">
    @csrf
    @method('put')

    <div class="row gy-4">

        {{-- Dealer Operations --}}
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label">Dealer Operations</label>
                <div id="operations-wrapper">
                    @php
                        $oldOps = old('operations', $dealer->operations->toArray());
                    @endphp
                    @forelse ($oldOps as $i => $operation)
                        <div class="d-flex mb-2 operation-row">
                            <input type="text" name="operations[{{ $i }}][operation]" class="form-control form-control-lg me-2"
                                value="{{ $operation['operation'] ?? '' }}" placeholder="Enter operation">
                            <button type="button" class="btn btn-danger remove-operation">X</button>
                        </div>
                    @empty
                        <div class="d-flex mb-2 operation-row">
                            <input type="text" name="operations[0][operation]" class="form-control form-control-lg me-2" placeholder="Enter operation">
                            <button type="button" class="btn btn-danger remove-operation">X</button>
                        </div>
                    @endforelse
                </div>
                <button type="button" id="add-operation" class="btn btn-sm btn-secondary mt-2">+ Add Operation</button>
            </div>
        </div>

        {{-- Dealer Branches --}}
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label">Dealer Branches</label>
                <div id="branches-wrapper">
                    @php
                        $oldBranches = old('branches', $dealer->branches->toArray());
                    @endphp
                    @forelse ($oldBranches as $i => $branch)
                        <div class="d-flex mb-2 branch-row">
                            <input type="text" name="branches[{{ $i }}][branch_name]" class="form-control form-control-lg me-2"
                                value="{{ $branch['branch_name'] ?? '' }}" placeholder="Enter branch name">
                            <select name="branches[{{ $i }}][status]" class="form-select form-select-lg me-2" style="max-width: 150px;">
                                <option value="1" {{ ($branch['status'] ?? 1) == 1 ? 'selected' : '' }}>Active</option>
                                <option value="0" {{ ($branch['status'] ?? 1) == 0 ? 'selected' : '' }}>Inactive</option>
                            </select>
                            <button type="button" class="btn btn-danger remove-branch">X</button>
                        </div>
                    @empty
                        <div class="d-flex mb-2 branch-row">
                            <input type="text" name="branches[0][branch_name]" class="form-control form-control-lg me-2" placeholder="Enter branch name">
                            <select name="branches[0][status]" class="form-select form-select-lg me-2" style="max-width: 150px;">
                                <option value="1" selected>Active</option>
                                <option value="0">Inactive</option>
                            </select>
                            <button type="button" class="btn btn-danger remove-branch">X</button>
                        </div>
                    @endforelse
                </div>
                <button type="button" id="add-branch" class="btn btn-sm btn-secondary mt-2">+ Add Branch</button>
            </div>
        </div>

        <div class="col-12">
            <button class="btn btn-primary btn-lg">@lang('global.form.button.save')</button>
        </div>
    </div>
</form>

<script>
    $(document).ready(function() {

        function reindexRows(wrapper, rowClass) {
            $(wrapper).find(rowClass).each(function(index, row) {
                $(row).find('input, select').each(function() {
                    let name = $(this).attr('name');
                    if (name) {
                        name = name.replace(/\[\d+\]/, '[' + index + ']');
                        $(this).attr('name', name);
                    }
                });
            });
        }

        // Add operation
        $("#add-operation").on("click", function() {
            $("#operations-wrapper").append(`
            <div class="d-flex mb-2 operation-row">
                <input type="text" name="operations[][operation]" class="form-control form-control-lg me-2" placeholder="Enter operation">
                <button type="button" class="btn btn-danger remove-operation">X</button>
            </div>
        `);
            reindexRows("#operations-wrapper", ".operation-row");
        });

        // Remove operation
        $(document).on("click", ".remove-operation", function() {
            $(this).closest(".operation-row").remove();
            reindexRows("#operations-wrapper", ".operation-row");
        });

        // Add branch
        $("#add-branch").on("click", function() {
            $("#branches-wrapper").append(`
            <div class="d-flex mb-2 branch-row">
                <input type="text" name="branches[][branch_name]" class="form-control form-control-lg me-2" placeholder="Enter branch name">
                <select name="branches[][status]" class="form-select form-select-lg me-2" style="max-width: 150px;">
                    <option value="1" selected>Active</option>
                    <option value="0">Inactive</option>
                </select>
                <button type="button" class="btn btn-danger remove-branch">X</button>
            </div>
        `);
            reindexRows("#branches-wrapper", ".branch-row");
        });

        // Remove branch
        $(document).on("click", ".remove-branch", function() {
            $(this).closest(".branch-row").remove();
            reindexRows("#branches-wrapper", ".branch-row");
        });

    });
</script>
