<h5 class="title pb-3">@lang('profile.representative_information.edit.title')</h5>

@php 
    $rep = $representative ?? ($dealer->representatives[0] ?? null); 
@endphp

<form action="{{ route('dealers.profile.representative.update', $rep ? $rep->id : 0) }}" method="post" async-form on-async-modal data-event="profile.updated">
    @csrf
    @method('put')

    <div class="row gy-4">
        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label required">Full Name <span class="text-danger">*</span></label>
                <div class="form-control-wrap">
                    <input type="text" name="rep_name" class="form-control form-control-lg" value="{{ old('rep_name', optional($rep)->full_name) }}">
                    <span class="invalid-feedback" role="alert" style="display: none;"></span>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">CNIC / Passport <span class="text-danger">*</span></label>
                <div class="form-control-wrap">
                    <input type="text" name="rep_cnic" class="form-control form-control-lg" value="{{ old('rep_cnic', optional($rep)->nic_number) }}">
                    <span class="invalid-feedback" role="alert" style="display: none;"></span>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Position</label>
                <div class="form-control-wrap">
                    <input type="text" name="rep_position" class="form-control form-control-lg" value="{{ old('rep_position', optional($rep)->position) }}">
                    <span class="invalid-feedback" role="alert" style="display: none;"></span>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Contact Phone</label>
                <div class="form-control-wrap">
                    <input type="text" name="rep_contact" class="form-control form-control-lg" value="{{ old('rep_contact', optional($rep)->contact_phone) }}">
                    <span class="invalid-feedback" role="alert" style="display: none;"></span>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="form-group">
                <label class="form-label">Contact Email</label>
                <div class="form-control-wrap">
                    <input type="email" name="rep_email" class="form-control form-control-lg" value="{{ old('rep_email', optional($rep)->contact_email) }}">
                    <span class="invalid-feedback" role="alert" style="display: none;"></span>
                </div>
            </div>
        </div>

        <div class="col-12">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">@lang('global.form.button.save')</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>@lang('global.form.button.cancel')</button></li>
            </ul>
        </div>
    </div>
</form>
