@extends('layouts.app')

@section('title', trans('dealers.page.title'))

@section('content')
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title">@lang('dealers.page.heading')</h3>
            </div>
            @can('dealers.add')
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="pageMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="pageMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">

                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endcan
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-stretch">
            <div class="card-aside-wrap">
                <div class="card-content">
                    <ul class="nav nav-tabs nav-tabs-mb-icon nav-tabs-card">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#active"><em class="icon ni ni-activity"></em><span>@lang('global.table.type.active')</span></a>
                        </li>
                        @if (auth()->user()->can('dealers.delete'))
                            <li class="nav-item">
                                <a class="nav-link" data-bs-toggle="tab" href="#archived" id="archived_tab"><em class="icon ni ni-trash"></em><span>@lang('global.table.type.deleted')</span></a>
                            </li>
                        @endif
                    </ul>
                    <div class="card-inner position-relative card-tools-toggle table-responsive">
                        <div class="tab-content">
                            <div class="tab-pane active" id="active">
                                <table id="dealers-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                                    <thead>
                                        <tr class="nk-tb-item nk-tb-head">
                                            <th><span class="sub-text">#</span></th>
                                            <th><span class="sub-text">@lang('dealers.table.header.name')</span></th>
                                            <th><span class="sub-text">@lang('dealers.table.header.phone')</span></th>
                                            <th><span class="sub-text">@lang('dealers.table.header.status')</span></th>
                                            <th><span class="sub-text">@lang('dealers.table.header.created')</span></th>
                                            <th><span class="sub-text">@lang('dealers.table.header.updated')</span></th>
                                            <th class="text-right"><span class="sub-text">@lang('dealers.table.header.actions')</span></th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            @if (auth()->user()->can('dealers.delete'))
                                <div class="tab-pane" id="archived">
                                    <table id="archived-dealers-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                                        <thead>
                                            <tr class="nk-tb-item nk-tb-head">
                                                <th><span class="sub-text">#</span></th>
                                                <th><span class="sub-text">@lang('dealers.table.header.name')</span></th>
                                                <th><span class="sub-text">@lang('dealers.table.header.phone')</span></th>
                                                <th><span class="sub-text">@lang('dealers.table.header.status')</span></th>
                                                <th><span class="sub-text">@lang('dealers.table.header.created')</span></th>
                                                <th><span class="sub-text">@lang('dealers.table.header.updated')</span></th>
                                                <th class="text-right"><span class="sub-text">@lang('dealers.table.header.actions')</span></th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        var table = $('#dealers-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "{{ route('dealers.dataTable') }}",
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'uuid',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'phone',
                    name: 'phone'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'created',
                    name: 'created',
                    searchable: false
                },
                {
                    data: 'updated',
                    name: 'updated',
                    searchable: false
                },
                {
                    data: 'actions',
                    name: 'actions',
                    searchable: false
                },
            ],
        });

        var archivedTable;

        $(document).ready(function() {
            @if (auth()->user()->can('dealers.delete'))
                $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function(event) {
                    var target = $(event.target).attr("href");
                    if (target === "#active") {
                        table.ajax.reload();
                    } else if (target === "#archived") {
                        if (!archivedTable) {
                            archivedTable = $('#archived-dealers-dt').DataTable({
                                processing: true,
                                serverSide: true,
                                scrollX: false,
                                ordering: false,
                                autoWidth: true,
                                ajax: "{{ route('dealers.dataTable.archived') }}",
                                columns: [{
                                        data: 'DT_RowIndex',
                                        name: 'uuid',
                                        orderable: false,
                                        searchable: false
                                    },
                                    {
                                        data: 'name',
                                        name: 'name'
                                    },
                                    {
                                        data: 'phone',
                                        name: 'phone'
                                    },
                                    {
                                        data: 'status',
                                        name: 'status'
                                    },
                                    {
                                        data: 'created',
                                        name: 'created',
                                        searchable: false
                                    },
                                    {
                                        data: 'updated',
                                        name: 'updated',
                                        searchable: false
                                    },
                                    {
                                        data: 'actions',
                                        name: 'actions',
                                        searchable: false
                                    },
                                ],
                                createdRow: function(row, data, index) {
                                    $(row).addClass('nk-tb-item');
                                }
                            });
                        } else {
                            archivedTable.ajax.reload();
                        }
                    }
                });
            @endif
        });
    </script>
@endpush
