        {{-- Company Information --}}
        <h5 class="mb-3">1. Company Information</h5>
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Company Name</label>
                <p class="form-control-plaintext">{!! canEmpty($dealer->company_name) !!}</p>
            </div>
            <div class="col-md-6">
                <label class="form-label">Registration / License Number</label>
                <p class="form-control-plaintext">{!! canEmpty($dealer->registration_number) !!}</p>
            </div>
            <div class="col-md-6">
                <label class="form-label">Tax Identification Number (NTN)</label>
                <p class="form-control-plaintext">{!! canEmpty($dealer->tax_identification_number) !!}</p>
            </div>

            @if ($dealer->addresses->isNotEmpty())
                @php $addr = $dealer->addresses->first(); @endphp
                <div class="col-md-4">
                    <label class="form-label">Country</label>
                    <p class="form-control-plaintext">{!! canEmpty($addr->country) !!}</p>
                </div>
                <div class="col-md-4">
                    <label class="form-label">State / Province</label>
                    <p class="form-control-plaintext">{!! canEmpty($addr->state) !!}</p>
                </div>
                <div class="col-md-4">
                    <label class="form-label">City</label>
                    <p class="form-control-plaintext">{!! canEmpty($addr->city) !!}</p>
                </div>
                <div class="col-md-8">
                    <label class="form-label">Street Address</label>
                    <p class="form-control-plaintext">{!! canEmpty($addr->street) !!}</p>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Postal Code</label>
                    <p class="form-control-plaintext">{!! canEmpty($addr->postal_code) !!}</p>
                </div>
            @endif

            <div class="col-md-6">
                <label class="form-label">Contact Phone</label>
                <p class="form-control-plaintext">{!! canEmpty(optional($dealer->user)->phone) !!}</p>
            </div>
            <div class="col-md-6">
                <label class="form-label">Contact Email</label>
                <p class="form-control-plaintext">{!! canEmpty(optional($dealer->user)->email) !!}</p>
            </div>
        </div>

        <hr class="my-4">

        {{-- Representative --}}
        <h5 class="mb-3">2. Authorized Representative Information</h5>
        @if ($dealer->representatives->isNotEmpty())
            @php $rep = $dealer->representatives->first(); @endphp
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Full Name</label>
                    <p class="form-control-plaintext">{!! canEmpty($rep->full_name) !!}</p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">CNIC / Passport</label>
                    <p class="form-control-plaintext">{!! canEmpty($rep->nic_number) !!}</p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Position</label>
                    <p class="form-control-plaintext">{!! canEmpty($rep->position) !!}</p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Representative Contact</label>
                    <p class="form-control-plaintext">{!! canEmpty($rep->contact_phone) !!}</p>
                </div>
            </div>
        @endif

        <hr class="my-4">

        {{-- Bank --}}
        <h5 class="mb-3">3. Bank & Financial Information</h5>
        @if ($dealer->finances->isNotEmpty())
            @php $finance = $dealer->finances->first(); @endphp
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Bank Name</label>
                    <p class="form-control-plaintext">{!! canEmpty($finance->name) !!}</p>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Account Holder Name</label>
                    <p class="form-control-plaintext">{!! canEmpty($finance->account_holder_name) !!}</p>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Account Number / IBAN</label>
                    <p class="form-control-plaintext">{!! canEmpty($finance->account_number) !!}</p>
                </div>
            </div>
        @endif

        <hr class="my-4">

        {{-- Status & Timestamps --}}
        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Status</label>
                <p class="form-control-plaintext">{!! $dealer->user->getStatusBadge() !!}</p>
            </div>
            <div class="col-md-4">
                <label class="form-label">Created At</label>
                <p class="form-control-plaintext">{!! createdAt($dealer, isHumanTime: false) !!}</p>
            </div>
            <div class="col-md-4">
                <label class="form-label">Updated At</label>
                <p class="form-control-plaintext">{!! updatedAt($dealer, isHumanTime: false) !!}</p>
            </div>
        </div>

        <hr class="my-4">

        {{-- Listings --}}
        <h5 class="mb-3">Dealer Listings</h5>
        @if ($dealer->user && $dealer->user->listings->isNotEmpty())
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Price</th>
                            <th>Location</th>
                            <th>Type</th>
                            <th>Status</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($dealer->user->listings as $listing)
                            <tr>
                                <td>{{ $listing->title }}</td>
                                <td>${{ number_format($listing->price, 2) }}</td>
                                <td>{{ $listing->location }}</td>
                                <td>{{ ucfirst($listing->type) }}</td>
                                <td>{!! $listing->status->badge() !!}</td>
                                <td>{{ $listing->created_at->format('d M Y') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <p class="text-muted">No listings found for this dealer.</p>
        @endif
