@extends('layouts.app')

@section('title', 'DexUsers Management')

@section('content')
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title tax-title">@lang('dex-user.page.heading')</h3>
            </div>
            @can('dex_user.add')
                <div class="nk-block-head-content">
                    <div class="toggle-wrap nk-block-tools-toggle">
                        <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand" data-target="taxMenu">
                            <em class="icon ni ni-more-v"></em>
                        </a>
                        <div class="toggle-expand-content" data-content="taxMenu">
                            <ul class="nk-block-tools g-3">
                                <li class="nk-block-tools-opt">
                                    <div class="form-group">
                                        <a href="{{ route('dex-users.create') }}" class="form-control btn btn-primary" async-modal async-modal-size="lg">
                                            <em class="icon ni ni-plus"></em>
                                            <span>@lang('dex-user.page.button.add')</span>
                                        </a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endcan
        </div>
    </div>

    <div class="nk-block">
        <div class="card card-bordered card-preview">
            <div class="card-inner">
                <table id="dex-user-dt" class="table nowrap nk-tb-list nk-tb-ulist dataTable no-footer" width="100%">
                    <thead>
                        <tr class="nk-tb-item nk-tb-head">
                            <th><span class="sub-text">#</span></th>
                            <th><span class="sub-text">@lang('dex-user.table.header.first_name')</span></th>
                            <th><span class="sub-text">@lang('dex-user.table.header.last_name')</span></th>
                            <th><span class="sub-text">@lang('dex-user.table.header.email')</span></th>
                            <th><span class="sub-text">@lang('dex-user.table.header.created')</span></th>
                            <th><span class="sub-text">@lang('dex-user.table.header.updated')</span></th>
                            <th class="text-right"><span class="sub-text">@lang('dex-user.table.header.actions')</span></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script>
        let columns = [{
                data: 'DT_RowIndex',
                name: 'uuid',
                orderable: false,
                searchable: false,

            },
            {
                data: 'first_name',
                name: 'first_name',
            },
            {
                data: 'last_name',
                name: 'last_name',
            },
            {
                data: 'email',
                name: 'email',
            },
            {
                data: 'created',
                name: 'created',
                searchable: false
            },
            {
                data: 'updated',
                name: 'updated',
                searchable: false
            },
            {
                data: 'actions',
                name: 'actions',
                searchable: false
            },
        ];

        let dt = $('#dex-user-dt').DataTable({
            processing: true,
            serverSide: true,
            scrollX: false,
            ordering: false,
            autoWidth: true,
            ajax: {
                url: "{{ route('dex-users.datatable') }}",
            },
            columns: columns,
        });

        $('#dex-users-dt').on('draw.dt', function() {
            let queryString = new URLSearchParams({
                search: $('[type="search"]').val(),
            }).toString();
        });
    </script>
@endpush
