@php $url = isset($documentation) ? route('documentations.update', $documentation->uuid) : route('documentations.store'); @endphp

<h5 class="title pb-3">{{ isset($documentation) ? trans('documentations.modal.header.edit.title') : trans('documentations.modal.header.create.title') }}</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#documentations-dt">
    @csrf

    @isset($documentation)
        @method('put')
    @endisset

    <div class="row gy-4">
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="title">@lang('documentations.form.title.label')</label>
                <input class="form-control form-control-lg" id="title" name="title" placeholder="@lang('documentations.form.title.placeholder')"
                    value="{{ isset($documentation) ? $documentation->title : '' }}"></input>
                <span class="invalid-feedback pb-3" role="alert"></span>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="content">@lang('documentations.form.content.label')</label>
                <textarea class="form-control form-control-lg" id="editor-container" name="content" placeholder="@lang('documentations.form.content.placeholder')">{{ isset($documentation) ? $documentation->content : '' }}</textarea>
                <span class="invalid-feedback pb-3" role="alert"></span>
            </div>
        </div>
        <div class="col-12">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">@lang('global.form.button.save')</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>@lang('global.form.button.cancel')</button></li>
            </ul>
        </div>
    </div>
</form>
