<link rel="stylesheet" href="{{ asset('assets/css/summernote-3.2.3.css') }}">

@php $url = isset($customer) ? route('dx-customers.update', $customer->uuid) : route('dx-customers.store'); @endphp

<h5 class="title pb-3">{{ isset($customer) ? 'Update' : 'Add New' }} Dx Customer</h5>

<form action="{{ $url }}" method="post" async-form on-async-modal data-datatable="#dx-customer-dt">
    @csrf

    @isset($customer)
        @method('put')
    @endisset

        <div class="col-md-12">
            <div class="form-group">
                <label class="form-label" for="customer_name">@lang('dx-customer.form.name.label') <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="customer_name" name="customer_name" placeholder="@lang('dx-customer.form.name.placeholder')" required value="{{ old('customer_name', isset($customer) ? $customer->customer_name : '') }}">
                <span class="invalid-feedback" role="alert"></span>
            </div>
        </div>

        <div class="col-12 pt-1">
            <ul class="align-center flex-wrap flex-sm-nowrap gx-4 gy-2">
                <li><button type="submit" class="btn btn-lg btn-primary">{{ isset($customer) ? 'Update' : 'Add' }}</button></li>
                <li><button type="button" class="btn btn-lg btn-outline-danger" async-modal-close>Cancel</button></li>
            </ul>
        </div>
    </div>
</form>

<script src="{{ asset('assets/js/summernote-3.2.3.js') }}"></script>
<script>
    $('#summernote').summernote({
        placeholder: 'Describe your privacy policy here.',
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'underline', 'italic']],
            ['font', ['superscript', 'subscript']],
            ['color', ['color']],
            ['fontsize', ['fontsize']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['view', ['fullscreen', 'codeview']]
        ]
    });
</script>
